/*
 * Decompiled with CFR 0.152.
 */
package moon.logprocess.task;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import moon.logprocess.module.AdditionalAction;
import moon.logprocess.module.BackLogWriter;
import moon.logprocess.module.LogFileFilter;
import moon.logprocess.module.LogFileNamePatch;
import moon.logprocess.module.LogFileNamingRule;
import moon.logprocess.module.LogFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.live.monitor.MonitorInfoCollector;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.log.LogFilter;
import pluto.log.LogParser;
import pluto.log.LogUpdator;
import pluto.net.communicator.ServerStatusInfo;
import pluto.schedule.Task;
import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;

public class SsLifeAutoAnalyzerMainTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(SsLifeAutoAnalyzerMainTask.class);
    private static final String NULL_LOG_UPDATOR_CLASS_NAME = "pluto.common.log.NullLogUpdator";
    private static final String DEFAULT_READER_CLASS_NAME = "moon.logprocess.module.LineReadLogFileReader";
    protected static long _CHECK_INTERVAL_ = 1L;
    protected static String _TARGET_LOG_DIRECTORY_ = null;
    protected static String _BACK_LOG_DIRECTORY_ = null;
    protected static LogParser _LOG_PARSER_ = null;
    protected static LogFilter _LOG_FILTER_ = null;
    protected static LinkedList _DB_PRE_UPDATOR_ = null;
    protected static LogUpdator _DB_UPDATOR_ = null;
    protected static LogFileFilter _TARGET_LOG_FILE_FILTER_ = null;
    protected static LogFileFilter _BACK_LOG_FILE_FILTER_ = null;
    protected static LogFileReader _TARGET_LOG_READER_ = null;
    protected static BackLogWriter _BACK_LOG_WRITER_ = null;
    protected static LogFileNamingRule _TARGET_LOG_NAMING_RULE_ = null;
    protected static LogFileNamingRule _BACK_LOG_NAMING_RULE_ = null;
    protected static LogFileNamePatch _TARGET_LOG_NAME_PATCH_ = null;
    protected static LogFileNamePatch _BACK_LOG_NAME_PATCH_ = null;
    private static LinkedList INNER_ADD_ACTIONS = null;
    protected static LogChannel ERROR_LOG_CHANNEL_INSTANCE = null;
    protected static String MOBILE_DEVICE_USEYN = null;
    protected static String m_QUERY_SELECT_MOBILE_DEVICE_INFO = "";
    protected static PreparedStatement EMS_P_STATEMENT = null;
    public static ArrayList MOBILE_DEVICE_LIST = null;
    public static ResultSet MOBILE_RS = null;
    protected static String MOBILE_DEVICE_UPDATOR_URL = "";
    protected static String MOBILE_DEVICE_UPDATOR_FILENAME = "";
    protected static String MOBILE_DEVICE_UPDATOR_FILE_DELIM = "";
    protected static String MOBILE_DEVICE_FILE_PATH = "";
    protected eMsConnection EMS_CONNECTION = null;

    public static synchronized void init(Object o_prop) throws Exception {
        String key;
        Properties prop = (Properties)o_prop;
        Properties __SETUP_PROPERTY__ = new Properties();
        log.debug("[LOAD]LogParser .... ");
        _LOG_PARSER_ = (LogParser)Class.forName(prop.getProperty("parser.class")).newInstance();
        _LOG_PARSER_.setParsingRules(o_prop);
        log.debug("[LOAD]LogParser .... [OK]");
        log.debug("[LOAD]Pre Updator .... ");
        _DB_PRE_UPDATOR_ = new LinkedList();
        String pre_class = prop.getProperty("pre.updator.class", NULL_LOG_UPDATOR_CLASS_NAME);
        eMsStringTokenizer TMP_TOKEN = new eMsStringTokenizer();
        TMP_TOKEN.parse(pre_class, ",");
        while (TMP_TOKEN.hasMoreTokens()) {
            String tmp_class = TMP_TOKEN.nextToken();
            log.debug("[LOAD]Pre Updator sub classes=>" + tmp_class);
            LogUpdator tmpUpdator = (LogUpdator)Class.forName(tmp_class).newInstance();
            tmpUpdator.setUpdateRules(o_prop);
            _DB_PRE_UPDATOR_.add(tmpUpdator);
        }
        log.debug("[LOAD]Pre Updator .... [OK]");
        log.debug("[LOAD]LogUpdator .... ");
        _DB_UPDATOR_ = (LogUpdator)Class.forName(prop.getProperty("updator.class")).newInstance();
        _DB_UPDATOR_.setUpdateRules(o_prop);
        log.debug("[LOAD]LogUpdator .... [OK]");
        log.debug("[LOAD]LogFilter .... ");
        _LOG_FILTER_ = (LogFilter)Class.forName(prop.getProperty("filter.class")).newInstance();
        _LOG_FILTER_.setFilteringRules(o_prop);
        log.debug("[LOAD]LogFilter .... [OK]");
        __SETUP_PROPERTY__.clear();
        log.debug("[INIT]Target Parameters .... ");
        Enumeration<Object> ENUM = prop.keys();
        while (ENUM.hasMoreElements()) {
            key = (String)ENUM.nextElement();
            if (!key.startsWith("target.")) continue;
            __SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
        }
        log.debug("[INIT]Target Parameters ....[OK] ");
        log.debug("[INIT]Target NamingRule .... ");
        _TARGET_LOG_NAMING_RULE_ = (LogFileNamingRule)Class.forName(prop.getProperty("target.naming.rule")).newInstance();
        _TARGET_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]Target NamingRule ....[OK] ");
        log.debug("[INIT]Target NamePatch .... ");
        _TARGET_LOG_NAME_PATCH_ = (LogFileNamePatch)Class.forName(prop.getProperty("target.name.patch")).newInstance();
        _TARGET_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]Target NamePatch ....[OK] ");
        log.debug("[INIT]Target LogFileFilter .... ");
        _TARGET_LOG_FILE_FILTER_ = (LogFileFilter)Class.forName(prop.getProperty("target.name.filter")).newInstance();
        _TARGET_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("target.log.dir"));
        _TARGET_LOG_FILE_FILTER_.setNameRule(_TARGET_LOG_NAMING_RULE_);
        _TARGET_LOG_FILE_FILTER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
        log.debug("[INIT]Target LogFileFilter ....[OK] ");
        log.debug("[INIT]Target LogFileReader .... ");
        _TARGET_LOG_READER_ = (LogFileReader)Class.forName(prop.getProperty("target.reader.class", DEFAULT_READER_CLASS_NAME)).newInstance();
        _TARGET_LOG_READER_.setFileFilter(_TARGET_LOG_FILE_FILTER_);
        _TARGET_LOG_READER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
        _TARGET_LOG_READER_.setNamingRule(_TARGET_LOG_NAMING_RULE_);
        log.debug("[INIT]Target LogFileReader ....[OK] ");
        __SETUP_PROPERTY__.clear();
        log.debug("[INIT]BackupLog Parameters .... ");
        ENUM = prop.keys();
        while (ENUM.hasMoreElements()) {
            key = (String)ENUM.nextElement();
            if (!key.startsWith("update.")) continue;
            __SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
        }
        log.debug("[INIT]BackupLog Parameters ...[OK]. ");
        log.debug("[INIT]BackupLog LogFileNamingRule .... ");
        _BACK_LOG_NAMING_RULE_ = (LogFileNamingRule)Class.forName(prop.getProperty("update.naming.rule")).newInstance();
        _BACK_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]BackupLog LogFileNamingRule ....[OK] ");
        log.debug("[INIT]BackupLog LogFileNamePatch .... ");
        _BACK_LOG_NAME_PATCH_ = (LogFileNamePatch)Class.forName(prop.getProperty("update.name.patch")).newInstance();
        _BACK_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]BackupLog LogFileNamePatch ....[OK] ");
        log.debug("[INIT]BackupLog LogFileFilter .... ");
        _BACK_LOG_FILE_FILTER_ = (LogFileFilter)Class.forName(prop.getProperty("update.name.filter")).newInstance();
        _BACK_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("update.log.dir"));
        _BACK_LOG_FILE_FILTER_.setNameRule(_BACK_LOG_NAMING_RULE_);
        _BACK_LOG_FILE_FILTER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
        log.debug("[INIT]BackupLog LogFileFilter ....[OK] ");
        log.debug("[INIT]BackupLog BackLogWriter .... ");
        _BACK_LOG_WRITER_ = new BackLogWriter();
        _BACK_LOG_WRITER_.setFileFilter(_BACK_LOG_FILE_FILTER_);
        _BACK_LOG_WRITER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
        _BACK_LOG_WRITER_.setNamingRule(_BACK_LOG_NAMING_RULE_);
        log.debug("[INIT]BackupLog BackLogWriter ....[OK] ");
        String add_action_class = prop.getProperty("addtional.action.class");
        if (add_action_class != null) {
            TMP_TOKEN = new eMsStringTokenizer();
            TMP_TOKEN.parse(add_action_class, ",");
            INNER_ADD_ACTIONS = new LinkedList();
            while (TMP_TOKEN.hasMoreTokens()) {
                String __CLASS_NAME__ = TMP_TOKEN.nextToken();
                AdditionalAction __ADDITIONAL_ACTION__ = (AdditionalAction)Class.forName(__CLASS_NAME__).newInstance();
                __ADDITIONAL_ACTION__.init(o_prop);
                INNER_ADD_ACTIONS.addLast(__ADDITIONAL_ACTION__);
            }
        }
        _BACK_LOG_DIRECTORY_ = prop.getProperty("update.log.dir");
        String LOGCHANNEL_ID = prop.getProperty("logger.id");
        if (LOGCHANNEL_ID == null) {
            log.error("ERROR LOGCHANNEL IS NOT SET.......");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("ERROR LOGGER=>" + LOGCHANNEL_ID);
            }
            ERROR_LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
        }
        log.debug("[init]LogUpdateTask .... [OK]");
        if (prop.containsKey("mobile.stat.use")) {
            MOBILE_DEVICE_USEYN = prop.getProperty("mobile.stat.use");
            if (MOBILE_DEVICE_USEYN.equals("Y")) {
                MOBILE_DEVICE_UPDATOR_URL = prop.getProperty("mobile.device.updator.url");
                MOBILE_DEVICE_UPDATOR_FILENAME = prop.getProperty("mobile.device.updator.file.name");
                MOBILE_DEVICE_UPDATOR_FILE_DELIM = prop.getProperty("mobile.device.updator.file.delim");
                MOBILE_DEVICE_FILE_PATH = prop.getProperty("mobile.device.file.path");
                m_QUERY_SELECT_MOBILE_DEVICE_INFO = SqlManager.getQuery("MOBILE_DEVICE_CHECK", "QUERY_SELECT_MOBILE_DEVICE_INFO");
            }
        } else {
            MOBILE_DEVICE_USEYN = "N";
        }
    }

    public SsLifeAutoAnalyzerMainTask() {
        super((short)2, _CHECK_INTERVAL_);
        this.setName("SsLifeAutoAnalyzerMainTask");
        this.setTaskID("SsLifeAutoAnalyzerMainTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute_initiate() throws Exception {
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        try {
            if (MOBILE_DEVICE_USEYN.equals("Y")) {
                MOBILE_DEVICE_LIST = new ArrayList();
                EMS_P_STATEMENT = this.EMS_CONNECTION.prepareStatement(m_QUERY_SELECT_MOBILE_DEVICE_INFO);
                MOBILE_RS = EMS_P_STATEMENT.executeQuery();
                while (MOBILE_RS.next()) {
                    String mobile_entry = MOBILE_RS.getString("MB_DEVICE");
                    MOBILE_DEVICE_LIST.add(mobile_entry);
                }
                EMS_P_STATEMENT.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (EMS_P_STATEMENT != null) {
                EMS_P_STATEMENT.close();
            }
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        _TARGET_LOG_READER_.close();
        _BACK_LOG_WRITER_.close();
        _DB_UPDATOR_.clear_connection();
        for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
            tmpUpdator.clear_connection();
        }
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute() throws Exception {
        _DB_UPDATOR_.init_connection(this.EMS_CONNECTION);
        _DB_UPDATOR_.setStart();
        for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
            tmpUpdator.init_connection(this.EMS_CONNECTION);
            tmpUpdator.setStart();
        }
        if (log.isDebugEnabled()) {
            log.debug(" get Connection  INIT OK ");
        }
        this.work(this.EMS_CONNECTION);
        if (INNER_ADD_ACTIONS != null) {
            for (AdditionalAction __INNER_ADDITIONAL_ACTION__ : INNER_ADD_ACTIONS) {
                if (!__INNER_ADDITIONAL_ACTION__.isValidTime()) continue;
                try {
                    __INNER_ADDITIONAL_ACTION__.init_connection(this.EMS_CONNECTION);
                    __INNER_ADDITIONAL_ACTION__.execute();
                }
                catch (Throwable e) {
                    log.error(e.getMessage());
                }
                finally {
                    __INNER_ADDITIONAL_ACTION__.clean();
                }
            }
        }
        _DB_UPDATOR_.setEnd();
        for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
            tmpUpdator.setEnd();
        }
    }

    protected void work(eMsConnection EMS_CONNECTION) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(" Start work ");
        }
        String __START_LOG_FILE_NAME__ = null;
        String __LAST_LOG_STRING__ = null;
        long __START_LOG_FILE_POINT__ = 0L;
        String __FINAL_BACK_LOG_FILE__ = _BACK_LOG_FILE_FILTER_.getLastFilename();
        if (__FINAL_BACK_LOG_FILE__ != null) {
            __START_LOG_FILE_NAME__ = _TARGET_LOG_NAME_PATCH_.getInverseInfo(_BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
            log.info("Target Back Log File => ".concat(__FINAL_BACK_LOG_FILE__));
            if (!new File(_TARGET_LOG_FILE_FILTER_.getFullName(__START_LOG_FILE_NAME__)).exists()) {
                log.info("Target Log File Not Exist.... so Delete BackLog ");
                new File(__FINAL_BACK_LOG_FILE__).delete();
                log.debug("Miss Match BackLog Delete => ".concat(__FINAL_BACK_LOG_FILE__));
                return;
            }
        }
        if (__FINAL_BACK_LOG_FILE__ == null) {
            if (log.isDebugEnabled()) {
                log.debug("Backup Log File Not Exist.... so Check First Target Log File.. ");
            }
            if ((__START_LOG_FILE_NAME__ = _TARGET_LOG_FILE_FILTER_.getNextFilename()) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Start Target Log File is Not Exist.. so return... ");
                }
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Open Target Log File [0] : " + __START_LOG_FILE_NAME__);
                }
                _TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, 0L);
            }
            catch (Throwable e) {
                log.error(e.getMessage());
                return;
            }
        }
        __START_LOG_FILE_NAME__ = _TARGET_LOG_NAME_PATCH_.getInverseInfo(_BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
        if (log.isDebugEnabled()) {
            log.debug("Choose Target Log File : " + __START_LOG_FILE_NAME__);
        }
        try {
            __LAST_LOG_STRING__ = LogFileReader.getLastLine(_BACK_LOG_DIRECTORY_ + "/" + __FINAL_BACK_LOG_FILE__);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        try {
            __START_LOG_FILE_POINT__ = LogFileReader.getFileID(__LAST_LOG_STRING__);
        }
        catch (Exception _ex) {
            __START_LOG_FILE_POINT__ = 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug("Choose Target Log File Pointer: " + String.valueOf(__START_LOG_FILE_POINT__));
        }
        try {
            _TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, __START_LOG_FILE_POINT__);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Set Start log file : " + __START_LOG_FILE_NAME__);
            log.debug("Set Last log String : " + __LAST_LOG_STRING__);
            log.debug("Set Work BackLogFile : " + __FINAL_BACK_LOG_FILE__);
        }
        try {
            _BACK_LOG_WRITER_.openFile(_TARGET_LOG_NAME_PATCH_.getInfo(__START_LOG_FILE_NAME__));
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        Object _LOG_INFO_ = null;
        String __UPDATE_RESULT_STRING__ = null;
        while (true) {
            __LAST_LOG_STRING__ = _TARGET_LOG_READER_.readLine();
            __START_LOG_FILE_POINT__ = _TARGET_LOG_READER_.getFilePoint();
            if (__LAST_LOG_STRING__ == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Check Next LogFile .... ");
                }
                if (_TARGET_LOG_READER_.next()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Switch Next LogFile .... ".concat(_TARGET_LOG_READER_.getWorkingFileName()));
                    }
                    _BACK_LOG_WRITER_.openFile(_TARGET_LOG_NAME_PATCH_.getInfo(_TARGET_LOG_READER_.getWorkingFileName()));
                    continue;
                }
                return;
            }
            if (__LAST_LOG_STRING__.trim().length() < 2) continue;
            ServerStatusInfo.plusUpdateCnt();
            MonitorInfoCollector.addCntUpdate();
            try {
                if (log.isDebugEnabled()) {
                    log.debug(__LAST_LOG_STRING__);
                }
                if ((_LOG_INFO_ = _LOG_PARSER_.parse(__LAST_LOG_STRING__)) == null) {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", "invalid log");
                    MonitorInfoCollector.addCntUpdateFail();
                    continue;
                }
                if (_LOG_INFO_ instanceof String) {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", _LOG_INFO_.toString());
                    MonitorInfoCollector.addCntUpdateFail();
                    continue;
                }
                if ((_LOG_INFO_ = _LOG_FILTER_.convert(_LOG_INFO_)) instanceof String) {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", _LOG_INFO_.toString());
                    MonitorInfoCollector.addCntUpdateFail();
                    continue;
                }
                for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
                    try {
                        tmpUpdator.update(_LOG_INFO_);
                    }
                    catch (Throwable _ex) {
                        _ex.printStackTrace();
                        log.error(this.getName(), _ex);
                    }
                }
                try {
                    __UPDATE_RESULT_STRING__ = _DB_UPDATOR_.update(_LOG_INFO_);
                }
                catch (Throwable ex_) {
                    if (ERROR_LOG_CHANNEL_INSTANCE != null) {
                        ERROR_LOG_CHANNEL_INSTANCE.write(__LAST_LOG_STRING__);
                    }
                    log.error(this.getName(), ex_);
                    if (log.isDebugEnabled()) {
                        ex_.printStackTrace();
                    }
                    if (ex_ instanceof SQLException) {
                        _DB_UPDATOR_.ensureDBConnection();
                    }
                    __UPDATE_RESULT_STRING__ = ex_.toString().replace('\r', ' ').replace('\n', ' ');
                }
                this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", __UPDATE_RESULT_STRING__);
            }
            catch (Throwable e) {
                log.error(this.getName(), e);
                try {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", StringUtil.nl2blank(e.toString().trim()));
                }
                catch (Throwable _ex) {
                    log.error(this.getName(), _ex);
                }
                MonitorInfoCollector.addCntUpdateFail();
                return;
            }
        }
    }

    protected void appendBackLog(long __START_LOG_FILE_POINT__, String __LAST_LOG_STRING__, String result, String ext) throws Throwable {
        _BACK_LOG_WRITER_.append(String.valueOf(__START_LOG_FILE_POINT__), __LAST_LOG_STRING__.concat(result).concat(ext));
    }
}

