/*
 * Decompiled with CFR 0.152.
 */
package moon.logprocess.task;

import java.io.File;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import moon.logprocess.module.AdditionalAction;
import moon.logprocess.module.BackLogWriterPps;
import moon.logprocess.module.LogFileFilterPps;
import moon.logprocess.module.LogFileNamePatch;
import moon.logprocess.module.LogFileNamingRule;
import moon.logprocess.module.LogFileReaderPps;
import moon.logprocess.updator.DomainUpdateBean;
import moon.logprocess.updator.MassMissSummary;
import moon.logprocess.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsStatement;
import pluto.io.eMsFileWriter;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.log.LogFilter;
import pluto.log.LogParser;
import pluto.log.LogUpdator;
import pluto.schedule.Task;
import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;

public class JupiterAnalyzerMainTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(JupiterAnalyzerMainTask.class);
    private static final String NULL_LOG_UPDATOR_CLASS_NAME = "pluto.common.log.NullLogUpdator";
    private static final String DEFAULT_READER_CLASS_NAME = "moon.logprocess.module.LineReadLogFileReaderPps";
    protected static long _CHECK_INTERVAL_ = 1L;
    protected static String _TARGET_LOG_DIRECTORY_ = null;
    protected static String _BACK_LOG_DIRECTORY_ = null;
    protected static LogParser _LOG_PARSER_ = null;
    protected static LogFilter _LOG_FILTER_ = null;
    protected static LinkedList _DB_PRE_UPDATOR_ = null;
    protected static LogUpdator _DB_UPDATOR_ = null;
    protected static LogFileFilterPps _TARGET_LOG_FILE_FILTER_ = null;
    protected static LogFileFilterPps _BACK_LOG_FILE_FILTER_ = null;
    protected static LogFileReaderPps _TARGET_LOG_READER_ = null;
    protected static BackLogWriterPps _BACK_LOG_WRITER_ = null;
    protected static LogFileNamingRule _TARGET_LOG_NAMING_RULE_ = null;
    protected static LogFileNamingRule _BACK_LOG_NAMING_RULE_ = null;
    protected static LogFileNamePatch _TARGET_LOG_NAME_PATCH_ = null;
    protected static LogFileNamePatch _BACK_LOG_NAME_PATCH_ = null;
    private static LinkedList INNER_ADD_ACTIONS = null;
    protected static LogChannel ERROR_LOG_CHANNEL_INSTANCE = null;
    protected static int ACT_CNT = 0;
    protected static long LAST_FILE_POINT = 0L;
    protected static String LAST_FILE_NAME = "";
    protected static eMsFileWriter LOG_PRC_CHANNEL = null;
    protected static String LOG_PRC_DIR = "";
    public static String PRC_TARGET = null;
    protected static MassMissSummary MASS_SUMMARY = null;
    protected static String QUERY_UPDATE_SEND_SUMMARY = SqlManager.getQuery("MASS_LOG_UPDATE_PPS", "QUERY_UPDATE_SEND_SUMMARY");
    protected static String QUERY_INSERT_SEND_SUMMARY = SqlManager.getQuery("MASS_LOG_UPDATE_PPS", "QUERY_INSERT_SEND_SUMMARY");
    protected static String QUERY_UPDATE_70_SUMMARY = SqlManager.getQuery("MASS_LOG_UPDATE_PPS", "QUERY_UPDATE_70_SUMMARY");
    protected StringBuffer LOG_WORK_BUFFER = new StringBuffer(512);
    public static Hashtable MASS_DOMAIN_PPT = new Hashtable();
    public static Hashtable MASS_SCHEDULE_PPT = new Hashtable();
    public static int SUMMARY_CNT = 1000;
    public eMsPreparedStatement PPS_UPDATE_SEND_SUMMARY = null;
    public eMsPreparedStatement PPS_INSERT_SEND_SUMMARY = null;
    public eMsPreparedStatement PPS_UPDATE_70_SUMMARY = null;
    protected eMsConnection EMS_CONNECTION = null;

    public static synchronized void init(Object o_prop) throws Exception {
        String key;
        Properties prop = (Properties)o_prop;
        Properties __SETUP_PROPERTY__ = new Properties();
        SUMMARY_CNT = Integer.parseInt(prop.getProperty("summary.cnt", "1000"));
        log.debug("[LOAD]LogParser .... ");
        _LOG_PARSER_ = (LogParser)Class.forName(prop.getProperty("parser.class")).newInstance();
        _LOG_PARSER_.setParsingRules(o_prop);
        log.debug("[LOAD]LogParser .... [OK]");
        log.debug("[LOAD]Pre Updator .... ");
        _DB_PRE_UPDATOR_ = new LinkedList();
        String pre_class = prop.getProperty("pre.updator.class", NULL_LOG_UPDATOR_CLASS_NAME);
        eMsStringTokenizer TMP_TOKEN = new eMsStringTokenizer();
        TMP_TOKEN.parse(pre_class, ",");
        while (TMP_TOKEN.hasMoreTokens()) {
            String tmp_class = TMP_TOKEN.nextToken();
            log.debug("[LOAD]Pre Updator sub classes=>" + tmp_class);
            LogUpdator tmpUpdator = (LogUpdator)Class.forName(tmp_class).newInstance();
            tmpUpdator.setUpdateRules(o_prop);
            _DB_PRE_UPDATOR_.add(tmpUpdator);
        }
        log.debug("[LOAD]Pre Updator .... [OK]");
        log.debug("[LOAD]LogUpdator .... ");
        _DB_UPDATOR_ = (LogUpdator)Class.forName(prop.getProperty("updator.class")).newInstance();
        _DB_UPDATOR_.setUpdateRules(o_prop);
        log.debug("[LOAD]LogUpdator .... [OK]");
        log.debug("[LOAD]LogFilter .... ");
        _LOG_FILTER_ = (LogFilter)Class.forName(prop.getProperty("filter.class")).newInstance();
        _LOG_FILTER_.setFilteringRules(o_prop);
        log.debug("[LOAD]LogFilter .... [OK]");
        __SETUP_PROPERTY__.clear();
        log.debug("[INIT]Target Parameters .... ");
        Enumeration<Object> eNum = prop.keys();
        while (eNum.hasMoreElements()) {
            key = (String)eNum.nextElement();
            if (!key.startsWith("target.")) continue;
            __SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
        }
        log.debug("[INIT]Target Parameters ....[OK] ");
        log.debug("[INIT]Target NamingRule .... ");
        _TARGET_LOG_NAMING_RULE_ = (LogFileNamingRule)Class.forName(prop.getProperty("target.naming.rule")).newInstance();
        _TARGET_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]Target NamingRule ....[OK] ");
        log.debug("[INIT]Target NamePatch .... ");
        _TARGET_LOG_NAME_PATCH_ = (LogFileNamePatch)Class.forName(prop.getProperty("target.name.patch")).newInstance();
        _TARGET_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]Target NamePatch ....[OK] ");
        log.debug("[INIT]Target LogFileFilterPps .... ");
        _TARGET_LOG_FILE_FILTER_ = (LogFileFilterPps)Class.forName(prop.getProperty("target.name.filter")).newInstance();
        _TARGET_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("target.log.dir"));
        _TARGET_LOG_FILE_FILTER_.setNameRule(_TARGET_LOG_NAMING_RULE_);
        _TARGET_LOG_FILE_FILTER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
        log.debug("[INIT]Target LogFileFilterPps ....[OK] ");
        log.debug("[INIT]Target LogFileReaderPps .... ");
        _TARGET_LOG_READER_ = (LogFileReaderPps)Class.forName(prop.getProperty("target.reader.class", DEFAULT_READER_CLASS_NAME)).newInstance();
        _TARGET_LOG_READER_.setFileFilter(_TARGET_LOG_FILE_FILTER_);
        _TARGET_LOG_READER_.setNamePatch(_TARGET_LOG_NAME_PATCH_);
        _TARGET_LOG_READER_.setNamingRule(_TARGET_LOG_NAMING_RULE_);
        log.debug("[INIT]Target LogFileReaderPps ....[OK] ");
        __SETUP_PROPERTY__.clear();
        log.debug("[INIT]BackupLog Parameters .... ");
        eNum = prop.keys();
        while (eNum.hasMoreElements()) {
            key = (String)eNum.nextElement();
            if (!key.startsWith("update.")) continue;
            __SETUP_PROPERTY__.setProperty(key.substring(key.indexOf(".") + 1), prop.getProperty(key));
        }
        log.debug("[INIT]BackupLog Parameters ...[OK]. ");
        log.debug("[INIT]BackupLog LogFileNamingRule .... ");
        _BACK_LOG_NAMING_RULE_ = (LogFileNamingRule)Class.forName(prop.getProperty("update.naming.rule")).newInstance();
        _BACK_LOG_NAMING_RULE_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]BackupLog LogFileNamingRule ....[OK] ");
        log.debug("[INIT]BackupLog LogFileNamePatch .... ");
        _BACK_LOG_NAME_PATCH_ = (LogFileNamePatch)Class.forName(prop.getProperty("update.name.patch")).newInstance();
        _BACK_LOG_NAME_PATCH_.init(__SETUP_PROPERTY__);
        log.debug("[INIT]BackupLog LogFileNamePatch ....[OK] ");
        log.debug("[INIT]BackupLog LogFileFilterPps .... ");
        _BACK_LOG_FILE_FILTER_ = (LogFileFilterPps)Class.forName(prop.getProperty("update.name.filter")).newInstance();
        _BACK_LOG_FILE_FILTER_.setTargetDir(prop.getProperty("update.log.dir"));
        _BACK_LOG_FILE_FILTER_.setNameRule(_BACK_LOG_NAMING_RULE_);
        _BACK_LOG_FILE_FILTER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
        log.debug("[INIT]BackupLog LogFileFilterPps ....[OK] ");
        log.debug("[INIT]BackupLog BackLogWriterPps .... ");
        _BACK_LOG_WRITER_ = new BackLogWriterPps();
        _BACK_LOG_WRITER_.setFileFilter(_BACK_LOG_FILE_FILTER_);
        _BACK_LOG_WRITER_.setNamePatch(_BACK_LOG_NAME_PATCH_);
        _BACK_LOG_WRITER_.setNamingRule(_BACK_LOG_NAMING_RULE_);
        log.debug("[INIT]BackupLog BackLogWriterPps ....[OK] ");
        String add_action_class = prop.getProperty("addtional.action.class");
        if (add_action_class != null) {
            TMP_TOKEN = new eMsStringTokenizer();
            TMP_TOKEN.parse(add_action_class, ",");
            INNER_ADD_ACTIONS = new LinkedList();
            while (TMP_TOKEN.hasMoreTokens()) {
                String __CLASS_NAME__ = TMP_TOKEN.nextToken();
                AdditionalAction __ADDITIONAL_ACTION__ = (AdditionalAction)Class.forName(__CLASS_NAME__).newInstance();
                __ADDITIONAL_ACTION__.init(o_prop);
                INNER_ADD_ACTIONS.addLast(__ADDITIONAL_ACTION__);
            }
        }
        _BACK_LOG_DIRECTORY_ = prop.getProperty("update.log.dir");
        String LOGCHANNEL_ID = prop.getProperty("logger.id");
        if (LOGCHANNEL_ID == null) {
            log.error("ERROR LOGCHANNEL IS NOT SET.......");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("ERROR LOGGER=>" + LOGCHANNEL_ID);
            }
            ERROR_LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
        }
        MASS_SUMMARY = (MassMissSummary)Class.forName(prop.getProperty("mass.summary")).newInstance();
        LOG_PRC_DIR = prop.getProperty("check.summary.dir");
        LOG_PRC_CHANNEL = new eMsFileWriter(LOG_PRC_DIR + File.separator + "update_point.info", true);
        PRC_TARGET = prop.getProperty("mass.summary.type");
        log.debug("[init]LogUpdateTask .... [OK]");
    }

    public JupiterAnalyzerMainTask() {
        super((short)2, _CHECK_INTERVAL_);
        this.setName("JupiterAnalyzerMainTask");
        this.setTaskID("JupiterAnalyzerMainTask");
    }

    @Override
    public void execute_initiate() throws Exception {
        this.EMS_CONNECTION = ConnectionPool.getConnection();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        _TARGET_LOG_READER_.close();
        _BACK_LOG_WRITER_.close();
        _DB_UPDATOR_.clear_connection();
        for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
            tmpUpdator.clear_connection();
        }
        if (this.PPS_UPDATE_SEND_SUMMARY != null) {
            this.PPS_UPDATE_SEND_SUMMARY.close();
            this.PPS_UPDATE_SEND_SUMMARY = null;
        }
        if (this.PPS_INSERT_SEND_SUMMARY != null) {
            this.PPS_INSERT_SEND_SUMMARY.close();
            this.PPS_INSERT_SEND_SUMMARY = null;
        }
        if (this.PPS_UPDATE_70_SUMMARY != null) {
            this.PPS_UPDATE_70_SUMMARY.close();
            this.PPS_UPDATE_70_SUMMARY = null;
        }
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute() throws Exception {
        _DB_UPDATOR_.init_connection(this.EMS_CONNECTION);
        if (log.isDebugEnabled()) {
            log.debug("DB UPDATOR DBCONNECTION setting OK");
        }
        _DB_UPDATOR_.setStart();
        if (log.isDebugEnabled()) {
            log.debug("\t\t[_DB_PRE_UPDATOR_] size:" + _DB_PRE_UPDATOR_.size());
        }
        for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
            tmpUpdator.init_connection(this.EMS_CONNECTION);
            tmpUpdator.setStart();
        }
        if (log.isDebugEnabled()) {
            log.debug(" get Connection  INIT OK ");
        }
        if (ACT_CNT == 0) {
            if (log.isDebugEnabled()) {
                log.debug("*****[ MISS SUMMARY  START ]***************************************");
            }
            if (this.getMissSummaryInfo()) {
                this.setMissSummary(this.EMS_CONNECTION);
                if (log.isDebugEnabled()) {
                    log.debug("\n[ miss SUMMARY DB UPDATE start]");
                }
                int domain_result_cnt = this.summaryDomain(this.EMS_CONNECTION);
                int schedule_result_cnt = this.summarySchedule(this.EMS_CONNECTION);
                if (log.isDebugEnabled()) {
                    log.debug("[ miss SUMMARY DB UPDATE end]\n");
                }
                if (domain_result_cnt < 0 || schedule_result_cnt < 0) {
                    if (domain_result_cnt < 0) {
                        log.debug("[MISS DOMAIN SUMMARY ERROR !!! ]");
                    }
                    if (schedule_result_cnt < 0) {
                        log.debug("[MISS SCHEDULE SUMMARY ERROR !!! ]");
                    }
                    System.exit(1);
                }
                MASS_DOMAIN_PPT.clear();
                MASS_SCHEDULE_PPT.clear();
            }
            if (log.isDebugEnabled()) {
                log.debug("*****[ MISS SUMMARY  END ]*****************************************");
            }
        }
        this.work(this.EMS_CONNECTION);
        if (log.isDebugEnabled()) {
            log.debug("*****[ SUMMARY  START ]***************************************");
        }
        int domain_result_cnt = this.summaryDomain(this.EMS_CONNECTION);
        int schedule_result_cnt = this.summarySchedule(this.EMS_CONNECTION);
        if (domain_result_cnt < 0 || schedule_result_cnt < 0) {
            if (domain_result_cnt < 0) {
                log.debug("[DOMAIN SUMMARY ERROR !!! ]");
            }
            if (schedule_result_cnt < 0) {
                log.debug("[SCHEDULE SUMMARY ERROR !!! ]");
            }
            System.exit(1);
        }
        if (log.isDebugEnabled()) {
            log.debug("*****[ SUMMARY  END ]*****************************************");
        }
        if (INNER_ADD_ACTIONS != null) {
            for (AdditionalAction __INNER_ADDITIONAL_ACTION__ : INNER_ADD_ACTIONS) {
                if (!__INNER_ADDITIONAL_ACTION__.isValidTime()) continue;
                try {
                    __INNER_ADDITIONAL_ACTION__.init_connection(this.EMS_CONNECTION);
                    __INNER_ADDITIONAL_ACTION__.execute();
                }
                catch (Throwable e) {
                    log.error(e.getMessage());
                }
                finally {
                    __INNER_ADDITIONAL_ACTION__.clean();
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug(" INNER_ADD_ACTIONS IS NULL  <SKIP> ");
        }
        _DB_UPDATOR_.setEnd();
        for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
            tmpUpdator.setEnd();
        }
        if (log.isDebugEnabled()) {
            log.debug("[LOG ENGINE ACT CNT :" + ACT_CNT + "]");
        }
        ++ACT_CNT;
    }

    protected boolean getMissSummaryInfo() {
        String last_string = "";
        boolean act_flag = true;
        try {
            last_string = LogFileReaderPps.getLastLine(LOG_PRC_DIR + "/" + "update_point.info");
        }
        catch (Throwable e) {
            act_flag = false;
            e.printStackTrace();
            log.error(e.getMessage());
        }
        if (last_string == null) {
            LAST_FILE_POINT = 0L;
            LAST_FILE_NAME = _TARGET_LOG_FILE_FILTER_.getNextFilename(false);
        } else {
            try {
                LAST_FILE_POINT = LogFileReaderPps.getFileID(last_string);
                LAST_FILE_NAME = LogFileReaderPps.getFileName(last_string);
            }
            catch (Exception _ex) {
                act_flag = false;
                log.error(this.getName(), (Throwable)_ex);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("----------------------------------[getMissSummaryInfo][LOG point]:" + LAST_FILE_POINT + " [FILE_NAME]:" + LAST_FILE_NAME);
        }
        return act_flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMissSummary(eMsConnection EMS_CONNECTION) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("[----------------- setMissSummary start------------------]\n");
        }
        String __SUMMARY_END_FILE_NAME__ = null;
        long __SUMMARY_END_FILE_POINT__ = 0L;
        String __START_LOG_FILE_NAME__ = null;
        String __LAST_LOG_STRING__ = null;
        long __START_LOG_FILE_POINT__ = 0L;
        String __FINAL_BACK_LOG_FILE__ = _BACK_LOG_FILE_FILTER_.getLastFilename();
        log.info("Target Back Log File => " + __FINAL_BACK_LOG_FILE__);
        if (__FINAL_BACK_LOG_FILE__ == null) {
            return;
        }
        __SUMMARY_END_FILE_NAME__ = _TARGET_LOG_NAME_PATCH_.getInverseInfo(_BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
        if (!new File(_TARGET_LOG_FILE_FILTER_.getFullName(__SUMMARY_END_FILE_NAME__)).exists()) {
            return;
        }
        try {
            __LAST_LOG_STRING__ = LogFileReaderPps.getLastLine(_BACK_LOG_DIRECTORY_ + "/" + __FINAL_BACK_LOG_FILE__);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        try {
            __SUMMARY_END_FILE_POINT__ = LogFileReaderPps.getFileID(__LAST_LOG_STRING__);
        }
        catch (Exception _ex) {
            __SUMMARY_END_FILE_POINT__ = 0L;
        }
        if (__SUMMARY_END_FILE_POINT__ == LAST_FILE_POINT && __SUMMARY_END_FILE_NAME__.equals(LAST_FILE_NAME)) {
            log.debug("[SUMMARY NOTING!]");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Choose final Pointer: " + String.valueOf(__SUMMARY_END_FILE_POINT__));
        }
        try {
            _TARGET_LOG_READER_.openFile(LAST_FILE_NAME, LAST_FILE_POINT);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        Object _LOG_INFO_ = null;
        String __UPDATE_RESULT_STRING__ = null;
        eMsStatement EMS_UPDATE_STATEMENT = null;
        try {
            EMS_UPDATE_STATEMENT = EMS_CONNECTION.createStatement();
            do {
                __LAST_LOG_STRING__ = _TARGET_LOG_READER_.readLine();
                LAST_FILE_NAME = __START_LOG_FILE_NAME__ = _TARGET_LOG_READER_.getWorkingFileName();
                log.debug("[LAST_FILE_NAME]:" + LAST_FILE_NAME);
                LAST_FILE_POINT = __START_LOG_FILE_POINT__ = _TARGET_LOG_READER_.getFilePoint();
                log.debug("[LAST_FILE_POINT]:" + LAST_FILE_POINT);
                if (__LAST_LOG_STRING__ == null) {
                    if (_TARGET_LOG_READER_.next()) {
                        LAST_FILE_NAME = __START_LOG_FILE_NAME__ = _TARGET_LOG_READER_.getWorkingFileName();
                        log.debug("[LAST_FILE_NAME]:" + LAST_FILE_NAME);
                        LAST_FILE_POINT = __START_LOG_FILE_POINT__ = 0L;
                        log.debug("[LAST_FILE_POINT]:" + LAST_FILE_POINT);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("summary Switch Next LogFile .... ".concat(_TARGET_LOG_READER_.getWorkingFileName()));
                        continue;
                    }
                    return;
                }
                if (__LAST_LOG_STRING__.trim().length() < 2) continue;
                try {
                    _LOG_INFO_ = _LOG_PARSER_.parse(__LAST_LOG_STRING__);
                    if (_LOG_INFO_ == null || _LOG_INFO_ instanceof String) continue;
                    _LOG_INFO_ = _LOG_FILTER_.convert(_LOG_INFO_);
                    try {
                        __UPDATE_RESULT_STRING__ = MASS_SUMMARY.summary(_LOG_INFO_, EMS_UPDATE_STATEMENT);
                    }
                    catch (Throwable ex_) {
                        if (ERROR_LOG_CHANNEL_INSTANCE != null) {
                            ERROR_LOG_CHANNEL_INSTANCE.write(__LAST_LOG_STRING__);
                        }
                        log.error(this.getName(), ex_);
                        if (!log.isDebugEnabled()) continue;
                        ex_.printStackTrace();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error(e.getMessage());
                    eMsStatement.releaseStmt(EMS_UPDATE_STATEMENT);
                    return;
                }
            } while (__START_LOG_FILE_POINT__ != __SUMMARY_END_FILE_POINT__ || !__START_LOG_FILE_NAME__.equals(__SUMMARY_END_FILE_NAME__));
        }
        catch (SQLException se) {
            log.error(this.getName(), (Throwable)se);
        }
        finally {
            eMsStatement.releaseStmt(EMS_UPDATE_STATEMENT);
        }
    }

    protected void work(eMsConnection EMS_CONNECTION) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("[----------------- work start------------------]\n");
        }
        String __START_LOG_FILE_NAME__ = null;
        String __LAST_LOG_STRING__ = null;
        long __START_LOG_FILE_POINT__ = 0L;
        String __FINAL_BACK_LOG_FILE__ = _BACK_LOG_FILE_FILTER_.getLastFilename();
        log.info("Target Back Log File => " + __FINAL_BACK_LOG_FILE__);
        if (__FINAL_BACK_LOG_FILE__ == null) {
            if (log.isDebugEnabled()) {
                log.debug("Backup Log File Not Exist.... so Check First Target Log File.. ");
            }
            LAST_FILE_NAME = __START_LOG_FILE_NAME__ = _TARGET_LOG_FILE_FILTER_.getNextFilename(false);
            if (__START_LOG_FILE_NAME__ == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Start Target Log File is Not Exist.. so return... ");
                }
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Open Target Log File [0] : " + __START_LOG_FILE_NAME__);
                }
                _TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, 0L);
            }
            catch (Throwable e) {
                log.error(e.getMessage());
                return;
            }
        }
        LAST_FILE_NAME = __START_LOG_FILE_NAME__ = _TARGET_LOG_NAME_PATCH_.getInverseInfo(_BACK_LOG_NAME_PATCH_.getInfo(__FINAL_BACK_LOG_FILE__));
        if (log.isDebugEnabled()) {
            log.debug("[LAST_FILE_NAME]:" + LAST_FILE_NAME);
        }
        if (!new File(_TARGET_LOG_FILE_FILTER_.getFullName(__START_LOG_FILE_NAME__)).exists()) {
            log.info("Target Log File Not Exist.... so Delete BackLog ");
            new File(__FINAL_BACK_LOG_FILE__).delete();
            log.debug("Miss Match BackLog Delete => ".concat(__FINAL_BACK_LOG_FILE__));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Choose Target Log File : " + __START_LOG_FILE_NAME__);
        }
        try {
            __LAST_LOG_STRING__ = LogFileReaderPps.getLastLine(_BACK_LOG_DIRECTORY_ + "/" + __FINAL_BACK_LOG_FILE__);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        try {
            __START_LOG_FILE_POINT__ = LogFileReaderPps.getFileID(__LAST_LOG_STRING__);
        }
        catch (Exception _ex) {
            __START_LOG_FILE_POINT__ = 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug("Choose Target Log File Pointer: " + String.valueOf(__START_LOG_FILE_POINT__));
        }
        try {
            _TARGET_LOG_READER_.openFile(__START_LOG_FILE_NAME__, __START_LOG_FILE_POINT__);
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\nSet Start log file : " + __START_LOG_FILE_NAME__);
            log.debug("Set Last log String : " + __LAST_LOG_STRING__);
            log.debug("Set Work BackLogFile : " + __FINAL_BACK_LOG_FILE__ + "\n");
        }
        try {
            _BACK_LOG_WRITER_.openFile(_TARGET_LOG_NAME_PATCH_.getInfo(__START_LOG_FILE_NAME__));
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return;
        }
        Object _LOG_INFO_ = null;
        int act_line_cnt = 0;
        String __UPDATE_RESULT_STRING__ = null;
        do {
            __LAST_LOG_STRING__ = _TARGET_LOG_READER_.readLine();
            LAST_FILE_POINT = __START_LOG_FILE_POINT__ = _TARGET_LOG_READER_.getFilePoint();
            if (__LAST_LOG_STRING__ == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Check Next LogFile .... ");
                }
                if (_TARGET_LOG_READER_.next()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Switch Next LogFile .... ".concat(_TARGET_LOG_READER_.getWorkingFileName()));
                    }
                    LAST_FILE_NAME = _TARGET_LOG_READER_.getWorkingFileName();
                    if (log.isDebugEnabled()) {
                        log.debug("[LAST_FILE_NAME]:" + LAST_FILE_NAME);
                    }
                    LAST_FILE_POINT = 0L;
                    _BACK_LOG_WRITER_.openFile(_TARGET_LOG_NAME_PATCH_.getInfo(_TARGET_LOG_READER_.getWorkingFileName()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[NON BAK LOG FILE]");
                }
                return;
            }
            if (__LAST_LOG_STRING__.trim().length() < 2) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug(__LAST_LOG_STRING__);
                }
                if ((_LOG_INFO_ = _LOG_PARSER_.parse(__LAST_LOG_STRING__)) == null) {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", "invalid log");
                    continue;
                }
                if (_LOG_INFO_ instanceof String) {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", _LOG_INFO_.toString());
                    continue;
                }
                _LOG_INFO_ = _LOG_FILTER_.convert(_LOG_INFO_);
                for (LogUpdator tmpUpdator : _DB_PRE_UPDATOR_) {
                    try {
                        tmpUpdator.update(_LOG_INFO_);
                    }
                    catch (Throwable _ex) {
                        _ex.printStackTrace();
                        log.error(this.getName(), _ex);
                    }
                }
                ++act_line_cnt;
                try {
                    __UPDATE_RESULT_STRING__ = _DB_UPDATOR_.update(_LOG_INFO_);
                }
                catch (Throwable ex_) {
                    if (ERROR_LOG_CHANNEL_INSTANCE != null) {
                        ERROR_LOG_CHANNEL_INSTANCE.write(__LAST_LOG_STRING__);
                    }
                    log.error(this.getName(), ex_);
                    if (log.isDebugEnabled()) {
                        ex_.printStackTrace();
                    }
                    if (ex_ instanceof SQLException) {
                        _DB_UPDATOR_.ensureDBConnection();
                    }
                    __UPDATE_RESULT_STRING__ = ex_.toString().replace('\r', ' ').replace('\n', ' ');
                }
                this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", __UPDATE_RESULT_STRING__);
            }
            catch (Throwable e) {
                log.error(this.getName(), e);
                try {
                    this.appendBackLog(__START_LOG_FILE_POINT__, __LAST_LOG_STRING__, "\t UPDATE=>", StringUtil.nl2blank(e.toString().trim()));
                }
                catch (Throwable _ex) {
                    log.error(this.getName(), _ex);
                }
                return;
            }
        } while (act_line_cnt < SUMMARY_CNT);
    }

    protected void appendBackLog(long __START_LOG_FILE_POINT__, String __LAST_LOG_STRING__, String result, String ext) throws Throwable {
        _BACK_LOG_WRITER_.append(String.valueOf(__START_LOG_FILE_POINT__), __LAST_LOG_STRING__.concat(result).concat(ext));
    }

    protected int summaryDomain(eMsConnection EMS_CONNECTION) throws Exception {
        DomainUpdateBean domainBean = null;
        int result = 0;
        int count = 0;
        if (log.isDebugEnabled()) {
            log.debug("[summaryDomain START] MASS_DOMAIN_PPT size==>" + MASS_DOMAIN_PPT.size());
        }
        try {
            if (MASS_DOMAIN_PPT.size() <= 0) {
                return result;
            }
            Enumeration e = MASS_DOMAIN_PPT.elements();
            while (e.hasMoreElements()) {
                result = 0;
                domainBean = (DomainUpdateBean)e.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("[domainBean content]\n\t" + domainBean.toMassString());
                }
                if (this.PPS_UPDATE_SEND_SUMMARY == null) {
                    this.PPS_UPDATE_SEND_SUMMARY = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SEND_SUMMARY, "${", "}");
                }
                if ((result = this.PPS_UPDATE_SEND_SUMMARY.executeUpdate(domainBean.getElement("MASS"))) < 1) {
                    if (log.isDebugEnabled()) {
                        log.debug("[update fail==> insert domain]" + domainBean.getName());
                    }
                    if (this.PPS_INSERT_SEND_SUMMARY == null) {
                        this.PPS_INSERT_SEND_SUMMARY = EMS_CONNECTION.prepareStatement(QUERY_INSERT_SEND_SUMMARY, "${", "}");
                    }
                    this.PPS_INSERT_SEND_SUMMARY.executeUpdate(domainBean.getElement("MASS"));
                    result = this.PPS_UPDATE_SEND_SUMMARY.executeUpdate(domainBean.getElement("MASS"));
                    if (result >= 1 && log.isDebugEnabled()) {
                        log.debug("[update OK]");
                    }
                }
                if (result <= 0) {
                    log.debug("[DOMAIN SUMMARY FAIL]:" + domainBean.getName());
                    continue;
                }
                ++count;
            }
            if (count == MASS_DOMAIN_PPT.size() && log.isDebugEnabled()) {
                log.debug("\t\t\t\t[DOMAIN SUMMARY SUCCESS !!!]");
            }
        }
        catch (SQLException sq_e) {
            log.error(this.getName(), (Throwable)sq_e);
            log.error("ERROR MASS DOMAIN SUMMARY : PONINT {} , FILENAME", (Object)LAST_FILE_POINT, (Object)LAST_FILE_NAME);
            result = -1;
        }
        return result;
    }

    protected int summarySchedule(eMsConnection EMS_CONNECTION) throws Exception {
        ScheduleTblBean stBean = null;
        String UPDATE_QUERY = "";
        int result = 0;
        int count = 0;
        if (log.isDebugEnabled()) {
            log.debug("[summarySchedule START]MASS_SCHEDULE_PPT size==>" + MASS_SCHEDULE_PPT.size());
        }
        try {
            if (MASS_SCHEDULE_PPT.size() <= 0) {
                return result;
            }
            Enumeration e = MASS_SCHEDULE_PPT.elements();
            while (e.hasMoreElements()) {
                stBean = (ScheduleTblBean)e.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("[stBean content]\n\t" + stBean.toString());
                }
                if (this.PPS_UPDATE_70_SUMMARY == null) {
                    this.PPS_UPDATE_70_SUMMARY = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_70_SUMMARY, "${", "}");
                }
                if ((result = this.PPS_UPDATE_70_SUMMARY.executeUpdate(stBean.getElement("MASS"))) < 1) {
                    log.debug("[SCHEDULE SUMMARY FAIL]:" + stBean.getName());
                    continue;
                }
                ++count;
            }
            if (count == MASS_SCHEDULE_PPT.size() && log.isDebugEnabled()) {
                log.debug("\t\t\t\t[SCHEDULE SUMMARY SUCCESS !!!]");
            }
        }
        catch (SQLException sq_e) {
            log.error(this.getName(), (Throwable)sq_e);
            log.error("ERROR MASS SCHD SUMMARY : PONINT {} , FILENAME", (Object)LAST_FILE_POINT, (Object)LAST_FILE_NAME);
            result = -1;
        }
        if (MASS_SCHEDULE_PPT.size() > 0) {
            JupiterAnalyzerMainTask.log(LAST_FILE_POINT, LAST_FILE_NAME);
        }
        return result;
    }

    protected static void log(long point, String file_name) {
        try {
            log.debug("[LOG point]:" + point + " [FILE_NAME]:" + file_name);
            LOG_PRC_CHANNEL.write("[" + point + "]");
            LOG_PRC_CHANNEL.write("\t");
            LOG_PRC_CHANNEL.println("[" + file_name + "]");
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }
}

