/*
 * Decompiled with CFR 0.152.
 */
package moon.logprocess.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import moon.logprocess.bean.AutoRemainBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.log.LogChannel;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class AutoRemainSendTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(AutoRemainSendTask.class);
    protected static long _CHECK_INTERVAL_ = 1L;
    protected static LogChannel ERROR_LOG_CHANNEL_INSTANCE = null;
    protected static ArrayList REMAIN_CAMP_LIST = null;
    protected static ArrayList REMAIN_OLD_CAMP_LIST = null;
    protected static Properties DO_ACT_CAMP = null;
    private String now_time = "";
    private String before_30min = "";
    protected static StringBuffer TMP_WORK_BUFFER = null;
    public static int REMAIN_ACT_CNT = 0;
    public static int WAIT_TIME = 0;
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement EMS_UPDATE_STATEMENT = null;
    protected eMsStatement EMS_RESEND_STATEMENT = null;
    protected eMsResultSet EMS_RESULTSET = null;
    public static String QUERY_REMAIN_MAIL_LIST = null;
    public static String QUERY_REMAIN_RESEND_UPDATE = null;

    public static synchronized void init(Object o_prop) throws Exception {
        Properties prop = (Properties)o_prop;
        REMAIN_ACT_CNT = Integer.parseInt(prop.getProperty("remain.act.cnt", "2")) - 1;
        log.debug("[init] REMAIN_ACT_CNT .... " + REMAIN_ACT_CNT);
        WAIT_TIME = Integer.parseInt(prop.getProperty("wait.time", "30")) * -1;
        log.debug("[init] WAIT_TIME .... " + WAIT_TIME);
        try {
            QUERY_REMAIN_MAIL_LIST = SqlManager.getQuery("REMAIN_SEND_QUERY", "QUERY_REMAIN_MAIL_LIST");
            QUERY_REMAIN_RESEND_UPDATE = SqlManager.getQuery("REMAIN_SEND_QUERY", "QUERY_REMAIN_RESEND_UPDATE");
            log.debug("[init] query .... [OK]");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            System.exit(1);
        }
        REMAIN_CAMP_LIST = new ArrayList();
        DO_ACT_CAMP = new Properties();
        TMP_WORK_BUFFER = new StringBuffer();
        log.debug("[init]RemainSendTask .... [OK]");
    }

    public AutoRemainSendTask() {
        super((short)2, _CHECK_INTERVAL_);
        this.setName("AutoRemainSendTask");
        this.setTaskID("AutoRemainSendTask");
    }

    @Override
    public void execute_initiate() throws Exception {
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        if (log.isDebugEnabled()) {
            log.debug("[execute_initiate] connection .... [OK]");
        }
        this.EMS_UPDATE_STATEMENT = this.EMS_CONNECTION.createStatement();
        if (log.isDebugEnabled()) {
            log.debug("[execute_initiate] update statement .... [OK]");
        }
        this.EMS_RESEND_STATEMENT = this.EMS_CONNECTION.createStatement();
        if (log.isDebugEnabled()) {
            log.debug("[execute_initiate] resend statement .... [OK]");
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.EMS_UPDATE_STATEMENT != null) {
            this.EMS_CONNECTION.recycleStatement(this.EMS_UPDATE_STATEMENT);
            if (log.isDebugEnabled()) {
                log.debug("[release_Resource] update statement .... [OK]");
            }
        }
        if (this.EMS_RESEND_STATEMENT != null) {
            this.EMS_CONNECTION.recycleStatement(this.EMS_RESEND_STATEMENT);
            if (log.isDebugEnabled()) {
                log.debug("[release_Resource] resend statement .... [OK]");
            }
        }
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
            if (log.isDebugEnabled()) {
                log.debug("[release_Resource] connection .... [OK]");
            }
        }
    }

    @Override
    public synchronized void execute() throws Exception {
        REMAIN_OLD_CAMP_LIST = REMAIN_CAMP_LIST;
        REMAIN_CAMP_LIST = new ArrayList();
        this.now_time = Cal.getSerialDate();
        this.before_30min = AutoRemainSendTask.getAddMin(WAIT_TIME);
        if (log.isDebugEnabled()) {
            log.debug("[now_time]:" + this.now_time + " [before_" + WAIT_TIME + "min]:" + this.before_30min);
        }
        AutoRemainBean bean = null;
        String bean_id = "";
        Properties bean_info = new Properties();
        int update_return = 0;
        int while_cnt = 0;
        this.EMS_RESULTSET = this.EMS_UPDATE_STATEMENT.executeQuery(QUERY_REMAIN_MAIL_LIST);
        while (this.EMS_RESULTSET.next()) {
            String doActCamp_str;
            if (log.isDebugEnabled()) {
                log.debug("[EMS_UPDATE_STATEMENT] ACT_CNT:" + ++while_cnt);
            }
            if ((doActCamp_str = DO_ACT_CAMP.getProperty(bean_id = this.EMS_RESULTSET.getString("WORKDAY") + "_" + this.EMS_RESULTSET.getString("SEQNO"))) != null && doActCamp_str.equals("" + REMAIN_ACT_CNT)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("[" + bean_id + "] - 3times ACT : SKIP!!");
                continue;
            }
            bean = AutoRemainSendTask.isBeanInList(bean_id);
            if (bean != null) {
                if (log.isDebugEnabled()) {
                    log.debug("[" + bean_id + "] - before list:match. [ACT:COMPARE]");
                }
                if (bean.samePushCnt(this.EMS_RESULTSET.getString("PUSHED_CNT"))) {
                    if (log.isDebugEnabled()) {
                        log.debug("[" + bean_id + "] - pushed_cnt:no change. [ACT:ATTANTION]");
                    }
                    if (bean.doActTime(this.before_30min)) {
                        log.debug("[" + bean_id + "] - check_time: over 30minute. [ACT: RESEND(job_status-35)]");
                        bean_info.clear();
                        bean_info.setProperty("WORKDAY", bean.getWorkday());
                        bean_info.setProperty("SEQNO", bean.getSeqno());
                        TMP_WORK_BUFFER.setLength(0);
                        StringConvertUtil.ConvertString(TMP_WORK_BUFFER, QUERY_REMAIN_RESEND_UPDATE, bean_info, "${", "}", true, false);
                        if (log.isDebugEnabled()) {
                            log.debug("update_exec=>" + TMP_WORK_BUFFER.toString());
                        }
                        if ((update_return = this.EMS_RESEND_STATEMENT.executeUpdate(TMP_WORK_BUFFER.toString())) > 0) {
                            log.debug("[RESEND] ID:" + bean.getBeanId() + "<SUCCESS>");
                            String act_cnt = DO_ACT_CAMP.getProperty(bean.getBeanId());
                            if (act_cnt == null) {
                                DO_ACT_CAMP.setProperty(bean.getBeanId(), "1");
                                log.debug("[DO_ACT_CAMP-ADD] ID:" + bean.getBeanId() + " [CNT]:1");
                                continue;
                            }
                            DO_ACT_CAMP.setProperty(bean.getBeanId(), "" + (Integer.parseInt(act_cnt) + 1));
                            log.debug("[DO_ACT_CAMP-MODY] ID:" + bean.getBeanId() + " [CNT]:" + DO_ACT_CAMP.getProperty(bean.getBeanId()));
                            continue;
                        }
                        log.debug("[RESEND] ID:" + bean.getBeanId() + "<FAIL>");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[" + bean_id + "] - check_time: yet " + WAIT_TIME + "minute. [ACT: PASS & ATTANTION]");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("\t\t\tcheck_time:" + bean.getCheck_time());
                    }
                    REMAIN_CAMP_LIST.add(bean);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[" + bean_id + "] - pushed_cnt: change. [ACT: PASS & LOOK]");
                }
                bean.setPushed_cnt(this.EMS_RESULTSET.getString("PUSHED_CNT"));
                bean.setCheck_time(this.now_time);
                log.debug("\t\t[~ING] ID:" + bean.getBeanId() + " PUSH:" + this.EMS_RESULTSET.getString("PUSHED_CNT") + " CHECK_TIME:" + this.now_time);
                REMAIN_CAMP_LIST.add(bean);
                continue;
            }
            bean = new AutoRemainBean();
            bean.setWorkday(this.EMS_RESULTSET.getString("WORKDAY"));
            bean.setSeqno(this.EMS_RESULTSET.getString("SEQNO"));
            bean.setCycle_type(this.EMS_RESULTSET.getString("CYCLE_TYPE"));
            bean.setEnd_date(this.EMS_RESULTSET.getString("END_DATE"));
            bean.setTarget_cnt(this.EMS_RESULTSET.getString("TARGET_CNT"));
            bean.setPushed_cnt(this.EMS_RESULTSET.getString("PUSHED_CNT"));
            bean.setCheck_time(this.now_time);
            REMAIN_CAMP_LIST.add(bean);
            if (!log.isDebugEnabled()) continue;
            log.debug("[" + bean_id + "] - before list: no match. [ACT:ADD REMAIN_CAMP_LIST]");
        }
        if (this.EMS_RESULTSET != null) {
            this.EMS_RESULTSET.close();
        }
        int now_before_2day = Integer.parseInt(Cal.getAddDayDate(-1));
        AutoRemainSendTask.cleanList(now_before_2day);
        if (log.isDebugEnabled()) {
            log.debug("[execute] end");
        }
    }

    protected void work(eMsConnection EMS_CONNECTION) throws Exception {
    }

    public static String getAddMin(int add_min) {
        return Cal.getSerialDate(System.currentTimeMillis() + (long)(add_min * 1000 * 60));
    }

    public static AutoRemainBean isBeanInList(String id) {
        if (REMAIN_OLD_CAMP_LIST.isEmpty()) {
            return null;
        }
        int list_size = REMAIN_OLD_CAMP_LIST.size();
        AutoRemainBean extr = null;
        for (int i = 0; i < list_size; ++i) {
            extr = (AutoRemainBean)REMAIN_OLD_CAMP_LIST.get(i);
            if (!id.equals(extr.getBeanId())) continue;
            return extr;
        }
        return null;
    }

    public static void cleanList(int yyyymmdd) {
        if (DO_ACT_CAMP.size() < 1) {
            log.debug("[cleanList ACTION SKIP] - DUP LIST is Null");
            return;
        }
        String id_str = "";
        Enumeration<?> e = DO_ACT_CAMP.propertyNames();
        while (e.hasMoreElements()) {
            id_str = (String)e.nextElement();
            int workday = Integer.parseInt(id_str.substring(0, 8));
            if (workday >= yyyymmdd) continue;
            DO_ACT_CAMP.remove(id_str);
            log.debug("[cleanList]  ID:" + id_str + " - remove in DO_ACT_CAMP ");
        }
    }
}

