/*
 * Decompiled with CFR 0.152.
 */
package moon.logprocess.module;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import moon.logprocess.module.LogProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogFileReader
extends LogProcessor {
    private static final Logger log = LoggerFactory.getLogger(LogFileReader.class);

    public LogFileReader() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public abstract long getFilePoint() throws IOException;

    public abstract void openFile(String var1, long var2) throws IOException;

    public abstract void close();

    public abstract String readLine() throws IOException;

    public abstract boolean next();

    public static long getFileID(String log) {
        int idx1 = log.indexOf("[");
        if (idx1 < 0) {
            return -1L;
        }
        int idx2 = log.indexOf("]");
        if (idx2 < 0 || idx1 + 1 > idx2) {
            return -1L;
        }
        String pointer = log.substring(idx1 + 1, idx2);
        try {
            return Long.parseLong(pointer);
        }
        catch (Exception _ex) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastLine(String filename) throws IOException {
        File targetFile = new File(filename);
        String __RETURN_VALUE__ = null;
        try (RandomAccessFile AccessFile = null;){
            AccessFile = new RandomAccessFile(targetFile, "r");
            long length = targetFile.length();
            if (length > 4096L) {
                AccessFile.seek(length - 4096L);
            }
            String tmp = null;
            while ((tmp = AccessFile.readLine()) != null) {
                if (tmp.trim().length() < 1) continue;
                __RETURN_VALUE__ = tmp;
            }
        }
        return __RETURN_VALUE__;
    }
}

