/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.util;

import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;

public class MappingImgStripper {
    private static final Logger log = LoggerFactory.getLogger(MappingImgStripper.class);
    public static String HEADER_INDEX = "<img ";

    public static synchronized String process(String src) {
        String source = src.toLowerCase().replace('\'', '\"');
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(512);
            int idx1 = 0;
            int idx2 = 0;
            while ((idx2 = source.indexOf(HEADER_INDEX, idx1)) >= 0) {
                buffer.append(src.substring(idx1, idx2));
                idx1 = source.indexOf(">", idx2);
                if (idx1 < 0) break;
                buffer.append(MappingImgStripper.parse(src.substring(idx2, ++idx1)));
            }
            if (idx2 > 0) {
                buffer.append(src.substring(idx2));
            } else {
                buffer.append(src.substring(idx1));
            }
            String string = buffer.toString();
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    private static String parse(String original) {
        String src;
        int idxOfStart;
        if (log.isDebugEnabled()) {
            log.debug("PARSE=>", (Object)original);
        }
        if ((idxOfStart = (src = original.toLowerCase()).indexOf("alt=\"${")) < 0 && (idxOfStart = src.indexOf("alt=${")) < 0) {
            if (log.isDebugEnabled()) {
                log.debug("NO ALT INDEX=>", (Object)original);
            }
            return original;
        }
        int idxOfEnd = src.indexOf("}", idxOfStart = src.indexOf("${", idxOfStart));
        if (idxOfEnd < 0) {
            if (log.isDebugEnabled()) {
                log.debug("NO ALT CLOSE INDEX=>", (Object)original);
            }
            return original;
        }
        if (log.isDebugEnabled()) {
            log.debug("RESULT=>", (Object)original.substring(idxOfStart, idxOfEnd + 1));
        }
        return original.substring(idxOfStart, idxOfEnd + 1);
    }

    public static Vector getMappingVariables(String source) {
        Vector<String> returnValue = new Vector<String>();
        int idx1 = 0;
        int idx2 = 0;
        while ((idx1 = source.indexOf("${", idx2)) >= 0 && (idx2 = source.indexOf("}", idx1 + 2)) >= 0) {
            String key = source.substring(idx1 + 2, idx2);
            if (returnValue.contains(key)) continue;
            returnValue.addElement(key);
        }
        return returnValue;
    }

    static {
        try {
            HEADER_INDEX = "<".concat(eMsSystem.getProperty("mapping.tag.name", "img").toLowerCase()).concat(" ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

