/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.producer;

import java.util.Properties;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.BASE64;

public abstract class CommonContentPD
extends ContentPD {
    private static final Logger log = LoggerFactory.getLogger(CommonContentPD.class);
    protected eMsConnection EMS_CONNECTION = null;
    protected String WORK_FILE_ID = null;
    protected String POST_ID = null;
    protected ContentInfo SEND_CONTENT_INFO = null;
    protected Properties SCHEDULE_INFO = null;
    protected String instance_ATTACH_CONTENT_SELECT_QUERY = null;

    protected final void refreshDBConnection() throws Exception {
        if (this.EMS_CONNECTION == null) {
            this.EMS_CONNECTION = ConnectionPool.getConnection();
        } else {
            this.EMS_CONNECTION.recycle();
            this.EMS_CONNECTION = ConnectionPool.getConnection();
        }
    }

    protected final void closeDBConnection() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
            this.EMS_CONNECTION = null;
        }
    }

    @Override
    protected void initResource() throws Exception {
        this.TMP_BUFFER = new StringBuffer(2048);
        this.refreshDBConnection();
    }

    @Override
    protected void initProperty(Properties info) throws Exception {
        this.SCHEDULE_INFO = info;
    }

    @Override
    protected void initError(Throwable thw) {
    }

    @Override
    protected void mainError(Throwable thw) {
    }

    @Override
    protected void exec_close() {
        this.closeDBConnection();
        this.TMP_BUFFER.setLength(0);
        this.TMP_BUFFER = null;
    }

    @Override
    protected void process_main() throws Exception {
        boolean SAFEMAIL_YN;
        String __DB_CONTENT__ = this.SCHEDULE_INFO.getProperty("CONTENT");
        String __CONTENT_URL_ = null;
        __CONTENT_URL_ = __DB_CONTENT__.startsWith("http://") || __DB_CONTENT__.startsWith("https://") || __DB_CONTENT__.startsWith("ftp://") || __DB_CONTENT__.startsWith("file://") ? __DB_CONTENT__ : CONTENTS_BASE_URL + __DB_CONTENT__;
        String __CONTENT__ = null;
        try {
            __CONTENT__ = FileElement.getFileBody(__CONTENT_URL_);
        }
        catch (Exception e) {
            log.error(__CONTENT_URL_, (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug("CONTENT", (Object)__CONTENT__);
        }
        if (SAFEMAIL_YN = this.SCHEDULE_INFO.getProperty("SAFEMAIL_YN", "N").equalsIgnoreCase("Y")) {
            __CONTENT__ = this.addSafeMailSource(__CONTENT__);
        }
        if (this.SCHEDULE_INFO.getProperty("CONTENT_MAPPING_SERIALIZE_FLAG", "N").equalsIgnoreCase("Y")) {
            __CONTENT__ = StringUtil.GeneralizeContents(__CONTENT__, "${", "}", "map_");
        }
        log.debug(" pass get contents ");
        __CONTENT__ = this.execute_ContentProcess(eMsLocale.CONTENT_DEFAULT_HEADER + __CONTENT__ + eMsLocale.CONTENT_DEFAULT_TAIL);
        this.execute_ContentSave(__CONTENT__);
        log.debug(" pass result contents ");
        this.execute_createContentInfo();
        log.debug(" pass regist contensts infomation ");
    }

    protected String addSafeMailSource(String source) {
        String result = "";
        StringBuffer return_str = new StringBuffer();
        String SAFEMAIL_TAG_START = eMsSystem.getProperty("safemail.tag.start");
        String SAFEMAIL_TAG_END = eMsSystem.getProperty("safemail.tag.end");
        String CUST_ID = eMsSystem.getProperty("cust.id");
        String width = this.SCHEDULE_INFO.getProperty("TMS_M_WIDTH", "800");
        String enc_cid = BASE64.encode("CUST_ID=" + CUST_ID);
        String enc_pid = BASE64.encode("POST_ID=" + this.POST_ID);
        Properties prop = new Properties();
        prop.setProperty("ENC_CID", enc_cid);
        prop.setProperty("ENC_PID", enc_pid);
        prop.setProperty("TMS_M_WIDTH", width);
        String SAFEMAIL_TAG_START_ENC_PID = StringUtil.ConvertString(SAFEMAIL_TAG_START, prop, "@{", "}");
        int sStart = 0;
        int sEnd = 0;
        int eStart = 0;
        boolean eEnd = false;
        sStart = source.toLowerCase().indexOf("<body");
        if (sStart < 0) {
            sEnd = 0;
            eStart = source.length();
        } else {
            sEnd = source.toLowerCase().indexOf(">", sStart) + 1;
            eStart = source.toLowerCase().lastIndexOf("</body");
        }
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append(source.substring(0, sEnd)).append("\n");
        sbuffer.append(SAFEMAIL_TAG_START_ENC_PID);
        sbuffer.append(source.substring(sEnd, eStart)).append("\n");
        sbuffer.append(SAFEMAIL_TAG_END);
        sbuffer.append(source.substring(eStart, source.length()));
        result = sbuffer.toString();
        return result;
    }

    @Override
    public ContentInfo getContentInfo() {
        return this.SEND_CONTENT_INFO;
    }

    protected void execute_ContentSave(String source) throws Exception {
        String __THIS_DATE__ = Cal.getDayDate();
        String __CONTENT_SAVE_FILE_NAME__ = FileElement.CheckSubDirectory(CONTENTS_STORE_DIRECTORY, __THIS_DATE__) + "/" + this.WORK_FILE_ID + ".contents";
        eMsFileWriter wt = new eMsFileWriter(__CONTENT_SAVE_FILE_NAME__);
        try {
            if (!"EM".equals(this.SCHEDULE_INFO.get("CHANNEL_TYPE").toString().trim())) {
                wt.write(source);
            } else {
                wt.write(StringConvertUtil.GeneralizeMailContents(source));
            }
        }
        catch (Exception e) {
            wt.write(StringConvertUtil.GeneralizeMailContents(source));
        }
        wt.flush();
        if (wt != null) {
            wt.close();
        }
        this.SCHEDULE_INFO.setProperty("CONTENT", "file://" + __CONTENT_SAVE_FILE_NAME__);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_createContentInfo() throws Exception {
        String send_type = this.SCHEDULE_INFO.getProperty("SEND_TYPE");
        String send_state = this.SCHEDULE_INFO.getProperty("SEND_STATE");
        String mail_enc_type = this.SCHEDULE_INFO.getProperty("MAIL_ENC_TYPE", "");
        String header_mime_char_set = this.SCHEDULE_INFO.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
        Short nMailEncType = mail_enc_type.equals("") ? new Short(eMsLocale.MAIL_ENC_TYPE) : new Short(mail_enc_type);
        BodyParser __BODY_PARSER__ = (BodyParser)InstanceFactory.getInstance(send_type, send_state, (short)1);
        __BODY_PARSER__.setContents(this.SCHEDULE_INFO.getProperty("CONTENT"));
        Message myMessage = (Message)InstanceFactory.getInstance(send_type, send_state, (short)2);
        myMessage.setContent(__BODY_PARSER__);
        if (this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "H").equals("H")) {
            myMessage.setContentType(new Short(2));
        } else {
            myMessage.setContentType(new Short(1));
        }
        myMessage.setCharSet(header_mime_char_set.equals("") ? eMsLocale.MAIL_MIME_CHAR_SET : header_mime_char_set);
        myMessage.setContentEncoding(nMailEncType);
        myMessage.setMessageID(this.POST_ID);
        MailBody __MAILBODY__ = (MailBody)InstanceFactory.getInstance(send_type, send_state, (short)3);
        __MAILBODY__.setFromEmail(this.SCHEDULE_INFO.getProperty("FROM_EMAIL"));
        __MAILBODY__.setFromName(this.SCHEDULE_INFO.getProperty("FROM_NAME"));
        __MAILBODY__.setToEmail(this.SCHEDULE_INFO.getProperty("TO_EMAIL", "${TMS_M_TOKEN}"));
        __MAILBODY__.setToName(this.SCHEDULE_INFO.getProperty("TO_NAME", "${TMS_M_NAME}"));
        __MAILBODY__.setSubject(this.SCHEDULE_INFO.getProperty("SUBJECT"));
        __MAILBODY__.setEtcHeader(eMsLocale.DEFAULT_HEADER);
        __MAILBODY__.setMessage(myMessage);
        if (eMsLocale.ATTACH_LOGIC_EXECUTE_FLAG && this.instance_ATTACH_CONTENT_SELECT_QUERY != null) {
            this.refreshDBConnection();
            eMsStatement stmt = null;
            eMsResultSet rs = null;
            try {
                stmt = this.EMS_CONNECTION.createStatement();
                rs = stmt.executeQuery(this.instance_ATTACH_CONTENT_SELECT_QUERY);
                Properties prop = new Properties();
                while (rs.next()) {
                    rs.putToMap(prop, false);
                    String sAttachState = prop.getProperty("ATTACH_TYPE", "O");
                    String aAttachFileUrl = prop.getProperty("ATTACH_FILE");
                    String aAttachFileName = prop.getProperty("ATTACH_NAME");
                    String aAttachCharset = this.SCHEDULE_INFO.getProperty("CHAR_SET", eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
                    String aAttachContentType = prop.getProperty("CONTENT_TYPE", "B");
                    String aAttachContentEncode = prop.getProperty("CONTENT_ENCODE", "B");
                    BodyParser aBodyParser = (BodyParser)InstanceFactory.getInstance("ATTACH", sAttachState, (short)1);
                    aBodyParser.setContents(aAttachFileUrl);
                    Message mMessage = (Message)InstanceFactory.getInstance("ATTACH", sAttachState, (short)2);
                    mMessage.setContent(aBodyParser);
                    mMessage.setCharSet(aAttachCharset);
                    if (aAttachContentType.equalsIgnoreCase("T")) {
                        mMessage.setContentType(new Short(3));
                    } else if (aAttachContentType.equalsIgnoreCase("H")) {
                        mMessage.setContentType(new Short(4));
                    } else {
                        mMessage.setContentType(new Short(5));
                    }
                    if (aAttachContentEncode.equalsIgnoreCase("N")) {
                        mMessage.setContentEncoding(new Short(4));
                    } else if (aAttachContentEncode.equalsIgnoreCase("Q")) {
                        mMessage.setContentEncoding(new Short(2));
                    } else {
                        mMessage.setContentEncoding(new Short(1));
                    }
                    mMessage.setContentName(aAttachFileName);
                    __MAILBODY__.setMessage(mMessage);
                }
            }
            finally {
                this.EMS_CONNECTION.recycleStatement(stmt);
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        this.SEND_CONTENT_INFO = new ContentInfo();
        this.SEND_CONTENT_INFO.setID(this.POST_ID);
        this.SEND_CONTENT_INFO.setScheduleInfo(this.SCHEDULE_INFO);
        this.SEND_CONTENT_INFO.setMappingHeader(this.getMappingHeader());
        this.SEND_CONTENT_INFO.setMailBody(__MAILBODY__);
        this.SEND_CONTENT_INFO.setReturnPath(this.SCHEDULE_INFO.getProperty("RETURN_PATH"));
        this.SEND_CONTENT_INFO.setSendType(this.SCHEDULE_INFO.getProperty("SEND_TYPE"));
    }

    protected abstract String execute_ContentProcess(String var1) throws Exception;

    protected abstract String getMappingHeader() throws Exception;
}

