/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.message;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.util.convert.BASE64;
import pluto.util.convert.MimeConvertor;

public class SimpleMessage
implements Message {
    private static final Logger log = LoggerFactory.getLogger(SimpleMessage.class);
    public static String MESSAGE_ID_TAIL = "@eMsSMTPV6.0(PLUTO)";
    protected Short CONTENT_TYPE = new Short(2);
    protected Short CONTENT_ENCODING = new Short(4);
    protected String CHAR_SET = null;
    protected String MESSAGE_ID = null;
    protected String CONTENT_NAME = null;
    protected BodyParser PARSED_CONTENT = null;
    protected String MESSAGE_HEADER = null;
    private Date myDate = new Date();
    private int MAX_RANDOM_VALUE = 8999;
    private int MIN_RANDOM_VALUE = 1000;
    private Random rnd = new Random();

    public SimpleMessage() {
        int idx1;
        String localHost = eMsLocale.SMTP_LOCAL_HOST[0];
        if (localHost == null) {
            localHost = "TMS_SMTPV3.0";
        }
        if ((idx1 = localHost.indexOf("[")) > -1) {
            int idx2 = localHost.indexOf("]");
            localHost = localHost.substring(idx1 + 1, idx2 > -1 ? idx2 : localHost.length());
        }
        MESSAGE_ID_TAIL = "@" + localHost;
        this.MESSAGE_ID = String.valueOf(System.currentTimeMillis()).concat(MESSAGE_ID_TAIL);
    }

    @Override
    public void setContentType(Short type) {
        this.CONTENT_TYPE = type;
    }

    @Override
    public Short getContentType() {
        return this.CONTENT_TYPE;
    }

    @Override
    public void setCharSet(String charset) {
        this.CHAR_SET = charset;
    }

    @Override
    public String getCharSet() {
        return this.CHAR_SET;
    }

    @Override
    public void setContentEncoding(Short enc_type) {
        this.CONTENT_ENCODING = enc_type;
    }

    @Override
    public Short getContentEncoding() {
        return this.CONTENT_ENCODING;
    }

    @Override
    public void setContent(BodyParser content) {
        this.PARSED_CONTENT = content;
    }

    @Override
    public BodyParser getContent() {
        return this.PARSED_CONTENT;
    }

    @Override
    public String getStringMessage(Object info1, Object info2, Properties prop) throws Exception {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(512);
            this.putStringMessageToStream(info1, info2, prop, out);
            String string = new String(out.toByteArray(), eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        finally {
            out.close();
            out = null;
        }
    }

    @Override
    public void putStringMessageToStream(Object info1, Object info2, Properties prop, OutputStream out) throws Exception {
        String returnValue = this.PARSED_CONTENT.convert(info1, info2, prop);
        if (log.isDebugEnabled()) {
            log.debug("message original body", (Object)returnValue);
        }
        if (this.CONTENT_TYPE == 5) {
            out.write(returnValue.getBytes(eMsLocale.CHAR_SET));
            return;
        }
        short encType = this.CONTENT_ENCODING;
        switch (encType) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                MimeConvertor.putMimeToStream(out, returnValue, eMsLocale.MAIL_BASE_CHAR_SET, this.CHAR_SET, encType);
                break;
            }
            default: {
                out.write(returnValue.getBytes(eMsLocale.CHAR_SET));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("message convert body", (Object)out.toString());
        }
    }

    @Override
    public String getHeader() {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(512);
            this.putHeaderToStream(out);
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
            out = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putHeaderToStream(OutputStream out) throws Exception {
        StringBuffer buffer = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            this.myDate.setTime(System.currentTimeMillis());
            buffer = new StringBuffer(512);
            buffer.append("Message-ID: <");
            buffer.append(sdf.format(this.myDate));
            buffer.append(this.rnd.nextInt(this.MAX_RANDOM_VALUE) + this.MIN_RANDOM_VALUE);
            buffer.append("_TMS");
            buffer.append(MESSAGE_ID_TAIL);
            buffer.append(">\r\n");
            buffer.append("Content-Type: ");
            switch (this.CONTENT_TYPE) {
                case 1: 
                case 3: {
                    buffer.append("text/plain;\r\n");
                    break;
                }
                case 2: 
                case 4: {
                    buffer.append("text/html;\r\n");
                    break;
                }
                case 5: {
                    buffer.append("application/octet-stream;\r\n");
                    break;
                }
                case 6: {
                    buffer.append("image/jpeg;\r\n");
                    break;
                }
                default: {
                    buffer.append("text/html;\r\n");
                }
            }
            switch (this.CONTENT_TYPE) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    buffer.append("\tcharset=\"");
                    buffer.append(this.CHAR_SET);
                    buffer.append("\"\r\n");
                    break;
                }
                case 5: 
                case 6: {
                    buffer.append("\tname=\"=?");
                    buffer.append(this.CHAR_SET);
                    buffer.append("?B?");
                    buffer.append(BASE64.encode(this.getContentName()));
                    buffer.append("?=\"\r\n");
                }
            }
            buffer.append("Content-Transfer-Encoding: ");
            if (this.CONTENT_TYPE == 5 || this.CONTENT_TYPE == 6) {
                buffer.append("base64");
            } else {
                switch (this.CONTENT_ENCODING) {
                    case 1: {
                        buffer.append("base64");
                        break;
                    }
                    case 2: {
                        buffer.append("quoted-printable");
                        break;
                    }
                    case 3: {
                        buffer.append("uuencode");
                        break;
                    }
                    case 4: {
                        buffer.append("8bit");
                        break;
                    }
                    case 5: {
                        buffer.append("7bit");
                        break;
                    }
                    default: {
                        buffer.append("8bit");
                    }
                }
            }
            buffer.append("\r\n");
            if (this.CONTENT_TYPE == 5 || this.CONTENT_TYPE == 4) {
                buffer.append("Content-Disposition: attachment;\r\n");
                buffer.append("\tfilename=\"=?");
                buffer.append(this.CHAR_SET);
                buffer.append("?B?");
                buffer.append(BASE64.encode(this.getContentName()));
                buffer.append("?=\"\r\n");
            }
            if (this.CONTENT_TYPE == 6) {
                buffer.append("Content-ID: <");
                buffer.append(this.getMessageID());
                buffer.append(">\r\n");
            }
            this.MESSAGE_HEADER = buffer.toString();
            out.write(this.MESSAGE_HEADER.getBytes(eMsLocale.CHAR_SET));
        }
        finally {
            buffer = null;
        }
    }

    @Override
    public void setMessageID(String id) {
        this.MESSAGE_ID = id.endsWith(MESSAGE_ID_TAIL) ? id : id.concat(MESSAGE_ID_TAIL);
    }

    @Override
    public String getMessageID() {
        return this.MESSAGE_ID;
    }

    @Override
    public String getContentName() {
        return this.CONTENT_NAME == null ? this.PARSED_CONTENT.getName() : this.CONTENT_NAME;
    }

    @Override
    public void setContentName(String name) {
        this.CONTENT_NAME = name;
    }

    protected void finalize() {
    }
}

