/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator.sync;

import java.util.HashMap;
import java.util.Properties;
import jupiter.mass.log.updator.sync.EmsDbQuery;
import jupiter.mass.log.updator.sync.Mutex;
import jupiter.mass.log.updator.sync.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;

public class DbSynchroSwithing
extends Mutex {
    private static final Logger log = LoggerFactory.getLogger(DbSynchroSwithing.class);
    private Properties tableInfo;
    private static final String CODE_CODE = "CODE_CODE";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String RUN_STATE = "RUN_STATE";
    private static final String FREE_STATE = "FREE_STATE";
    private static final String FOR_UPATE = "FOR_UPATE";
    private static String SYNC_PUSH_TABLE_NOW_STATE = null;
    private static String SYNC_PUSH_TABLE_RUN_STATE = null;
    private static String SYNC_PUSH_TABLE_FREE_STATE = null;

    public DbSynchroSwithing(TableInfo table) {
        this.setTableInfo(table);
    }

    public DbSynchroSwithing(Properties tableInfo) {
        this.tableInfo = tableInfo;
    }

    public void setTableInfo(TableInfo t) {
        this.tableInfo = new Properties();
        this.tableInfo.setProperty(CODE_CODE, t.getCodeCode());
        this.tableInfo.setProperty(COLUMN_NAME, t.getColumnName());
        this.tableInfo.setProperty(RUN_STATE, t.getColumnRunStateValue());
        this.tableInfo.setProperty(FREE_STATE, t.getColumnFreeStateValue());
    }

    @Override
    public synchronized void doLock() throws Exception {
        while (this.STATE) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.error("Interrupted error", (Throwable)e);
            }
            while (!this.isRunningState()) {
                Thread.sleep(5000L);
            }
        }
        this.takingState();
        this.STATE = true;
    }

    @Override
    public synchronized void unLock() throws Exception {
        this.freeState();
        this.STATE = false;
        this.notifyAll();
    }

    public boolean isRunningState() {
        this.tableInfo.setProperty(FOR_UPATE, FOR_UPATE);
        HashMap result = new HashMap();
        EmsDbQuery.selectExecute(SYNC_PUSH_TABLE_NOW_STATE, this.tableInfo, result);
        return this.tableInfo.getProperty(FREE_STATE).equals(result.get("STATE").toString());
    }

    public void takingState() {
        EmsDbQuery.updateExecute(SYNC_PUSH_TABLE_RUN_STATE, this.tableInfo);
    }

    public void freeState() {
        EmsDbQuery.updateExecute(SYNC_PUSH_TABLE_FREE_STATE, this.tableInfo);
    }

    static {
        SYNC_PUSH_TABLE_NOW_STATE = SqlManager.getQuery("MASS_UPDATE", "SYNC_PUSH_TABLE_NOW_STATE");
        SYNC_PUSH_TABLE_RUN_STATE = SqlManager.getQuery("MASS_UPDATE", "SYNC_PUSH_TABLE_RUN_STATE");
        SYNC_PUSH_TABLE_FREE_STATE = SqlManager.getQuery("MASS_UPDATE", "SYNC_PUSH_TABLE_FREE_STATE");
    }
}

