/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jupiter.mass.log.updator.KakaoAutoUpdator;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.Tracer;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class KakaoUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(KakaoUpdator.class);
    private static final String _USE_OTHER_DB_ = "use.other.db";
    private static final String _MASS_ = "MASS";
    private static final String _AUTO_ = "AUTO";
    private static String QUERY_SELECT_TARGET_KAKAO_LIST_TABLE = null;
    private static String QUERY_TARGET_KAKAO_RESULT_QUERY = null;
    private static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
    private String threadId = null;
    private Map<String, ScheduleTblBean> campSummaryPpp = new HashMap<String, ScheduleTblBean>();
    private Map<String, ScheduleTblBean> autoSummaryPpp = new HashMap<String, ScheduleTblBean>();
    private eMsConnection SOURCE_CONNECTION = null;
    private eMsConnection moduleConnection = null;
    private eMsStatement MODULE_KAKAO_SELECT_STMT = null;
    private eMsStatement TMS_KAKAO_SELECT_STMT = null;
    private eMsStatement BASIC_KAKAO_UPDATE_STMT = null;
    private boolean isUseOtherDb = false;
    private static ConnectInfo moduleConnectionInformation = new ConnectInfo();

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.setName("KakaoUpdator");
        this.setTaskID("KakaoUpdator_" + this.TASK_PROPERTY.getProperty("THREAD_ID"));
        this.threadId = this.TASK_PROPERTY.getProperty("THREAD_ID");
        this.isUseOtherDb = Boolean.parseBoolean(this.TASK_PROPERTY.getProperty(_USE_OTHER_DB_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        log.debug("{}_{} CALL KakaoUpdator===> execute()", (Object)this.getName(), (Object)this.threadId);
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("KakaoUpdator", (Object)"CALL execute() ERROR", (Object)thw);
            thw.printStackTrace();
        }
        finally {
            this.releaseResource();
        }
    }

    protected String getMonthListTableName(String month, String type) {
        String string = month = month.length() == 1 ? "0" + month : month;
        if (type.equals(_AUTO_)) {
            return "TMS_AUTO_SEND_LIST_" + month;
        }
        return "TMS_CAMP_SEND_LIST_" + month;
    }

    protected void execute_init() throws Throwable {
        log.debug("{}_{} CALL KakaoUpdator===> execute_init()", (Object)this.getName(), (Object)this.threadId);
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        if (this.isUseOtherDb) {
            this.moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
        }
        this.TMS_KAKAO_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.BASIC_KAKAO_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
        this.MODULE_KAKAO_SELECT_STMT = this.isUseOtherDb ? this.moduleConnection.createStatement() : this.SOURCE_CONNECTION.createStatement();
    }

    protected void releaseResource() {
        log.debug("{}_{} CALL KAKAOUpdator===> releaseResource()", (Object)this.getName(), (Object)this.threadId);
        if (this.SOURCE_CONNECTION != null) {
            if (this.TMS_KAKAO_SELECT_STMT != null) {
                this.SOURCE_CONNECTION.recycleStatement(this.TMS_KAKAO_SELECT_STMT);
            }
            if (this.BASIC_KAKAO_UPDATE_STMT != null) {
                this.SOURCE_CONNECTION.recycleStatement(this.BASIC_KAKAO_UPDATE_STMT);
            }
            if (!this.isUseOtherDb && this.MODULE_KAKAO_SELECT_STMT != null) {
                this.SOURCE_CONNECTION.recycleStatement(this.MODULE_KAKAO_SELECT_STMT);
            }
            try {
                this.SOURCE_CONNECTION.commit();
                this.SOURCE_CONNECTION.setAutoCommit(true);
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.SOURCE_CONNECTION.recycle();
        }
        if (this.moduleConnection != null) {
            if (this.isUseOtherDb && this.MODULE_KAKAO_SELECT_STMT != null) {
                this.moduleConnection.recycleStatement(this.MODULE_KAKAO_SELECT_STMT);
            }
            try {
                this.moduleConnection.commit();
                this.moduleConnection.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.moduleConnection.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        log.debug("{}_{} CALL KAKAOUpdator===> execute_main()", (Object)this.getName(), (Object)this.threadId);
        Properties tValue = new Properties();
        try (eMsResultSet kakaoListTableResult = null;){
            kakaoListTableResult = this.TMS_KAKAO_SELECT_STMT.executeQuery(QUERY_SELECT_TARGET_KAKAO_LIST_TABLE);
            while (kakaoListTableResult.next()) {
                String listTable2;
                String listTable1 = kakaoListTableResult.getString("LIST_TABLE1");
                if (listTable1.equals(listTable2 = kakaoListTableResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", listTable1);
                    continue;
                }
                kakaoListTableResult.putToMap(tValue, false);
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String kakaoListTable = iter.next().toString();
                if (kakaoListTable != null && !"".equals(kakaoListTable)) {
                    this.updateProcess(kakaoListTable);
                    continue;
                }
                log.debug("{}_{}, TARGET TABLE is null.. Query: {}", new Object[]{this.getName(), this.threadId, QUERY_SELECT_TARGET_KAKAO_LIST_TABLE});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcess(String list_table) {
        Properties kakaoSendResultValue = new Properties();
        String maxId = "";
        String minId = "";
        KakaoAutoUpdator autoUpdator = new KakaoAutoUpdator();
        eMsResultSet moduleKakaoResult = null;
        try {
            this.SOURCE_CONNECTION.setAutoCommit(false);
            if (this.moduleConnection != null) {
                this.moduleConnection.setAutoCommit(false);
            }
            autoUpdator.init(this.isUseOtherDb);
            maxId = this.TASK_PROPERTY.getProperty("MAX_ID");
            minId = this.TASK_PROPERTY.getProperty("MIN_ID");
            kakaoSendResultValue.setProperty("LIST_TABLE", list_table);
            kakaoSendResultValue.setProperty("MAX_ID", maxId);
            kakaoSendResultValue.setProperty("MIN_ID", minId);
            log.debug("{}_{} update_process query setting property... {} ", new Object[]{this.getName(), this.threadId, kakaoSendResultValue});
            moduleKakaoResult = this.MODULE_KAKAO_SELECT_STMT.executeQuery(QUERY_TARGET_KAKAO_RESULT_QUERY, kakaoSendResultValue, "${", "}");
            while (moduleKakaoResult.next()) {
                int failCnt;
                Properties resultProp = new Properties();
                moduleKakaoResult.putToMap(resultProp, false);
                log.debug("Update Kakao Result Set is {}", (Object)resultProp);
                String channelType = resultProp.getProperty("CHANNEL_TYPE", _AUTO_);
                if (!channelType.equals(_AUTO_)) continue;
                String postId = resultProp.getProperty("POST_ID", "").trim();
                String workday = resultProp.getProperty("WORKDAY", "").trim();
                String seqno = resultProp.getProperty("SEQNO", "").trim();
                if ("".equals(postId) || "".equals(workday) || "".equals(seqno)) {
                    log.debug("Data is invalid skip... POST_ID: {}, WORKDAY: {}, SEQNO: {}", new Object[]{postId, workday, seqno});
                    continue;
                }
                autoUpdator.update(resultProp);
                ScheduleTblBean autoBean = this.autoSummaryPpp.get(postId);
                if (autoBean == null) {
                    autoBean = new ScheduleTblBean(postId);
                    this.autoSummaryPpp.put(postId, autoBean);
                }
                if ((failCnt = Integer.parseInt(resultProp.getProperty("FAIL_CNT", "0"))) > 0) {
                    autoBean.addFailCnt();
                    autoBean.addErrorCnt(resultProp.getProperty("ERROR_CODE", ""));
                }
                autoBean.addPush();
            }
            if (this.campSummaryPpp.size() > 0) {
                this.schdSummary(_MASS_, this.campSummaryPpp);
            }
            if (this.autoSummaryPpp.size() > 0) {
                this.schdSummary(_AUTO_, this.autoSummaryPpp);
            }
        }
        catch (Exception e) {
            try {
                this.SOURCE_CONNECTION.rollback();
            }
            catch (Exception ee1) {
                // empty catch block
            }
            if (this.moduleConnection != null) {
                try {
                    this.moduleConnection.rollback();
                }
                catch (Exception ee2) {
                    // empty catch block
                }
            }
            log.error("KAKAOUpdator execute_main()...", (Throwable)e);
        }
        finally {
            if (moduleKakaoResult != null) {
                moduleKakaoResult.close();
            }
            autoUpdator.release();
        }
    }

    private void schdSummary(String type, Map<String, ScheduleTblBean> schdMap) {
        StringBuffer buff = new StringBuffer(512);
        try {
            for (Map.Entry<String, ScheduleTblBean> target : schdMap.entrySet()) {
                buff.setLength(0);
                ScheduleTblBean stBean = target.getValue();
                log.debug("{}_{} summary stBean data: {}", new Object[]{this.getName(), this.threadId, stBean.toString()});
                String targetQuery = type.equals(_AUTO_) ? QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO : QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY;
                StringConvertUtil.ConvertString(buff, targetQuery, stBean.getElement(type), "${", "}", true, false);
                if (this.BASIC_KAKAO_UPDATE_STMT.executeUpdate(buff.toString()) >= 1) continue;
                log.debug("{}_{} schedule summary fail: {}", new Object[]{this.getName(), this.threadId, stBean.getName()});
            }
        }
        catch (Exception e) {
            log.error("ERROR schdSummary... ", (Throwable)e);
        }
    }

    protected String ppsParseSQL(String source, String mapping, String value, String start, String end) {
        if (mapping == null || source == null) {
            return source;
        }
        return KakaoUpdator.replace_target(source, start + mapping + end, value);
    }

    public static String replace_target(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("KAKAOUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        Tracer.error("KAKAOUpdator", "init error", thw);
    }

    static {
        QUERY_TARGET_KAKAO_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_KAKAO_RESULT_QUERY");
        QUERY_SELECT_TARGET_KAKAO_LIST_TABLE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_KAKAO_LIST_TABLE");
        QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
        moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

