/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import com.humuson.tms.common.util.StringUtils;
import java.sql.SQLException;
import java.util.Properties;
import jupiter.mass.log.updator.KakaoUpdator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

public class KakaoAutoUpdator
extends KakaoUpdator {
    private static final Logger log = LoggerFactory.getLogger(KakaoAutoUpdator.class);
    private static final String CHECK_FLAG = "CHECK_FLAG";
    private static final String FAIL = "F";
    private static final String OK = "Y";
    private static final String ING_MSG = "S";
    private static String queryUpdateSendList = null;
    private static String queryUpdateLog = null;
    private eMsConnection oriConnection = null;
    private eMsConnection moduleConnection = null;
    private eMsPreparedStatement oriPsSendList = null;
    private eMsPreparedStatement modulePsLog = null;
    private boolean useOthreDb = false;
    private static ConnectInfo moduleConnectionInformation = new ConnectInfo();

    public void init(boolean _useOthreDb) {
        this.useOthreDb = _useOthreDb;
        try {
            this.oriConnection = ConnectionPool.getConnection();
            if (this.useOthreDb) {
                this.moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
                this.modulePsLog = this.moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
            } else {
                this.modulePsLog = this.oriConnection.prepareStatement(queryUpdateLog, "${", "}");
            }
        }
        catch (Exception e) {
            log.error("ERROR init()... {}", (Throwable)e);
        }
    }

    public void update(Properties resultProp) throws Exception {
        block12: {
            try {
                String listTableName;
                this.oriConnection.setAutoCommit(false);
                if (this.moduleConnection != null) {
                    this.moduleConnection.setAutoCommit(false);
                }
                resultProp.setProperty(CHECK_FLAG, OK);
                if (!resultProp.getProperty("ERROR_CODE").equals("00") && StringUtils.hasText((String)resultProp.getProperty("SMS_TYPE", ""))) {
                    resultProp.setProperty(CHECK_FLAG, ING_MSG);
                }
                if ("".equals(listTableName = resultProp.getProperty("LIST_TABLE", ""))) {
                    log.debug("LIST_TABLE is null... update skip... {}", (Object)resultProp);
                    return;
                }
                queryUpdateSendList = this.ppsParseSQL(queryUpdateSendList, "LIST_TABLE", listTableName, "@{", "}");
                log.debug("Update Send List Query: {}", (Object)queryUpdateSendList);
                this.oriPsSendList = this.oriConnection.prepareStatement(queryUpdateSendList, "${", "}");
                this.oriPsSendList.executeUpdate(resultProp);
                this.modulePsLog.executeUpdate(resultProp);
            }
            catch (Exception e) {
                resultProp.setProperty(CHECK_FLAG, FAIL);
                try {
                    this.modulePsLog.executeUpdate(resultProp);
                }
                catch (Exception ee) {
                    try {
                        this.oriConnection.rollback();
                    }
                    catch (Exception ee1) {
                        // empty catch block
                    }
                    if (this.moduleConnection != null) {
                        try {
                            this.moduleConnection.rollback();
                        }
                        catch (Exception ee2) {
                            // empty catch block
                        }
                    }
                    throw ee;
                }
                log.error("ERROR update...", (Throwable)e);
                if (!(e instanceof SQLException)) break block12;
                throw e;
            }
        }
    }

    public void release() {
        if (this.oriPsSendList != null) {
            this.oriConnection.recycleStatement(this.oriPsSendList);
        }
        if (this.modulePsLog != null) {
            if (this.useOthreDb) {
                this.moduleConnection.recycleStatement(this.modulePsLog);
            } else {
                this.oriConnection.recycleStatement(this.modulePsLog);
            }
        }
        if (this.oriConnection != null) {
            try {
                this.oriConnection.commit();
                this.oriConnection.setAutoCommit(true);
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.oriConnection.recycle();
        }
        if (this.moduleConnection != null) {
            try {
                this.moduleConnection.commit();
                this.moduleConnection.setAutoCommit(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.moduleConnection.recycle();
        }
    }

    static {
        queryUpdateSendList = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_SEND_LIST_N");
        queryUpdateLog = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_KAKAO_LOG");
        moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
        moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
        moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
        moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
        moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
        moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
        moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
        moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
    }
}

