/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.task;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.AbstractNoDBMailSendTask;
import jupiter.mass.send.basic.SendStopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.io.HeadTailFilenameFilter;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.mx.LookupCacheManager;
import pluto.panopticon.filter.RejectFilter;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.util.Cal;
import pluto.util.StringUtil;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

public class SimpleQueRecycleMailSendTask
extends AbstractNoDBMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(SimpleQueRecycleMailSendTask.class);
    protected static String STORE_BASE_DIR = null;
    protected static String STORE_WAIT_FILE_HEADER = null;
    protected static String STORE_WAIT_FILE_EXT = null;
    protected static String PROCESS_FILE_HEADER = null;
    protected static String PROCESS_FILE_EXT = null;
    protected static String END_BASE_DIR = null;
    protected static String END_FILE_HEADER = null;
    protected static String END_FILE_EXT = null;
    protected FilenameFilter WORK_FILE_NAME_FILTER = null;
    protected String TARGET_WORK_FILENAME = null;
    protected String TARGET_SENDING_FILENAME = null;
    protected String TARGET_DONE_FILENAME = null;
    private static boolean QUE_SEND_INTERRUPT_FLAG = false;
    private static int DATE_FROM_DB = 0;
    private static String SELECT_GET_DATE_FROM_DB = SqlManager.getQuery("SIMPLE_QUEUE_SEND_INFO", "QUERY_SELECT_SIMPLEQUEUE_GET_DATE");

    public SimpleQueRecycleMailSendTask() throws Exception {
        super((short)2, 1L);
        this.setName("SimpleQueRecycleMailSendTask");
        this.setTaskID("SimpleQueRecycleMailSendTask");
        this.WORK_FILE_NAME_FILTER = new HeadTailFilenameFilter(STORE_WAIT_FILE_HEADER, STORE_WAIT_FILE_EXT);
        this.instance_STOP_CHECK_RECYCLE = 2;
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        STORE_BASE_DIR = prop.getProperty("work.dir");
        if (STORE_BASE_DIR == null) {
            throw new RuntimeException("work.dir param is not set... ");
        }
        STORE_WAIT_FILE_HEADER = prop.getProperty("wait.file.header", "Resending");
        STORE_WAIT_FILE_EXT = prop.getProperty("wait.file.ext", ".work");
        PROCESS_FILE_HEADER = prop.getProperty("send.file.header", "QueProcess");
        PROCESS_FILE_EXT = prop.getProperty("send.file.ext", ".sending");
        END_BASE_DIR = prop.getProperty("end.dir");
        END_FILE_HEADER = prop.getProperty("end.file.header", "ResendDone");
        END_FILE_EXT = prop.getProperty("end.file.ext", ".done");
        if (END_BASE_DIR == null) {
            throw new RuntimeException("end.dir param is not set... ");
        }
    }

    public static synchronized void interruptQueSending() {
        QUE_SEND_INTERRUPT_FLAG = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute_initiate() throws Exception {
        QUE_SEND_INTERRUPT_FLAG = false;
        eMsConnection EMS_CONNECTION = null;
        eMsStatement __EMS_EXEC_STMT__ = null;
        eMsResultSet __SELECT_RESULT__ = null;
        EMS_CONNECTION = ConnectionPool.getConnection();
        __EMS_EXEC_STMT__ = EMS_CONNECTION.createStatement();
        boolean conn_check = false;
        try {
            __SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(SELECT_GET_DATE_FROM_DB);
            while (__SELECT_RESULT__.next()) {
                DATE_FROM_DB = Integer.parseInt(__SELECT_RESULT__.getString("NOWDATE"));
            }
            conn_check = true;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            conn_check = false;
        }
        finally {
            if (!conn_check) {
                DATE_FROM_DB = 20000101;
            }
            if (__SELECT_RESULT__ != null) {
                __SELECT_RESULT__.close();
            }
            if (__EMS_EXEC_STMT__ != null) {
                EMS_CONNECTION.recycleStatement(__EMS_EXEC_STMT__);
            }
            if (EMS_CONNECTION != null) {
                EMS_CONNECTION.recycle();
            }
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
    }

    @Override
    protected void execute_ListLoad() throws Exception {
        File _TARGET_DIRECTORY_ = new File(STORE_BASE_DIR);
        String[] _TARGET_FILES_ = _TARGET_DIRECTORY_.list(this.WORK_FILE_NAME_FILTER);
        if (_TARGET_FILES_.length < 1) {
            this.SPOOL_POPPER = null;
            return;
        }
        LinkedList<String> _FILE_LIST_ = new LinkedList<String>();
        String _TARGET_WORK_FILE_ = null;
        for (int i = 0; i < _TARGET_FILES_.length; ++i) {
            _FILE_LIST_.add(_TARGET_FILES_[i]);
        }
        Collections.sort(_FILE_LIST_);
        _TARGET_WORK_FILE_ = (String)_FILE_LIST_.getFirst();
        this.TARGET_SENDING_FILENAME = STORE_BASE_DIR + File.separator + PROCESS_FILE_HEADER + Cal.getSerialDate() + PROCESS_FILE_EXT;
        if (log.isDebugEnabled()) {
            log.debug("TargetFile from=>" + this.TARGET_SENDING_FILENAME);
        }
        this.TARGET_WORK_FILENAME = STORE_BASE_DIR + File.separator + _TARGET_WORK_FILE_;
        File _ORIGINAL_SOURCE_FILE_ = new File(this.TARGET_WORK_FILENAME);
        File _CHANGE_TARGET_FILE_ = new File(this.TARGET_SENDING_FILENAME);
        if (_ORIGINAL_SOURCE_FILE_.renameTo(_CHANGE_TARGET_FILE_)) {
            log.debug("Transfer Work->Sending Success from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
        } else {
            log.error(this.getName(), (Object)("Transfer Work->Sending Fail from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath()));
        }
        this.SPOOL_POPPER = Popper.getInstance();
        this.SPOOL_POPPER.init(null, this.TARGET_SENDING_FILENAME);
    }

    protected void execute_InnerSend() throws Exception {
        if (this.execute_StopCheck()) {
            throw new SendStopException(this.getName() + " receive stop signal");
        }
        RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
        String nextSpool = null;
        String domain = null;
        int spoolPatchCount = 0;
        BufferedAgentPool pool = null;
        String email_str = null;
        String email_en = null;
        Object ori_Spool = null;
        StringBuffer strBuffer = new StringBuffer(1024);
        int email_en_len = 0;
        while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
            if (nextSpool == null || nextSpool.length() < 1) continue;
            if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            try {
                int limitDate = 0;
                this.SPOOL_ANALYZER.parse(nextSpool);
                try {
                    limitDate = Integer.parseInt(this.SPOOL_ANALYZER.getLimitDate());
                }
                catch (Exception e) {
                    limitDate = 20000101;
                }
                if (DATE_FROM_DB > limitDate) continue;
                email_en = this.getSecureEmail(nextSpool);
                email_str = this.getDecryptEmail(email_en);
                domain = StringUtil.getDomain(email_str);
                email_en_len = email_en.length();
                strBuffer.setLength(0);
                strBuffer.append(email_en).append("<TMS_DECRYPT>").append(email_str).append(nextSpool.substring(email_en_len));
                nextSpool = strBuffer.toString();
                if (domain == null) {
                    this.processSyntaxErrorSpool(nextSpool);
                    continue;
                }
                if (MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain)) {
                    this.passRejectDomain(nextSpool);
                    continue;
                }
                if (instanceRejectFilter != null) {
                    if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                    nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                }
                this.DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
                if (this.DOMAIN_NOT_FOUND_EXCEPTION == null) {
                    pool = this.getBufferedObjectPool(domain);
                    pool.registSpool(domain, nextSpool);
                    continue;
                }
                this.passDomainNotFound(nextSpool, this.DOMAIN_NOT_FOUND_EXCEPTION);
            }
            catch (OutOfMemoryError outError) {
                log.error("OOM error", (Throwable)outError);
                System.gc();
                try {
                    Thread.currentThread();
                    Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    SpoolingManager.registSpool(ori_Spool);
                }
                catch (Exception ignore) {
                }
            }
            catch (Throwable err) {
                log.error("error", err);
                ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("EXEC BufferedAgentPool.flushAll()");
        }
        BufferedAgentPool.flushAll();
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend [OK]");
        }
    }

    @Override
    protected void execute_ListSend() throws Exception {
        if (this.SPOOL_POPPER == null) {
            return;
        }
        try {
            this.execute_InnerSend();
        }
        catch (SendStopException se) {
            log.error("QUE SEND INTERRUPTED");
            File _TARGET_DIRECTORY_ = new File(STORE_BASE_DIR);
            String[] _TARGET_FILES_ = _TARGET_DIRECTORY_.list(this.WORK_FILE_NAME_FILTER);
            for (int i = 0; i < _TARGET_FILES_.length; ++i) {
                log.error("QUE SEND INTERRUPTED DELETE FILE", (Object)(STORE_BASE_DIR + File.separator + _TARGET_FILES_[i]));
                if (new File(STORE_BASE_DIR + File.separator + _TARGET_FILES_[i]).delete()) {
                    log.error("QUE SEND INTERRUPTED DELETE FILE", (Object)"SUCCESS");
                    continue;
                }
                log.error("QUE SEND INTERRUPTED DELETE FILE", (Object)"FAIL");
            }
        }
        this.SPOOL_POPPER.close();
        this.SPOOL_POPPER = null;
        String TARGET_DONE_FILENAME = FileElement.CheckSubDirectory(END_BASE_DIR, Cal.getDayDate()) + File.separator + END_FILE_HEADER + Cal.getSerialDate() + END_FILE_EXT;
        File _CHANGE_TARGET_FILE_ = new File(TARGET_DONE_FILENAME);
        File _ORIGINAL_SOURCE_FILE_ = new File(this.TARGET_SENDING_FILENAME);
        if (_ORIGINAL_SOURCE_FILE_.renameTo(_CHANGE_TARGET_FILE_)) {
            if (log.isDebugEnabled()) {
                log.debug("Transfer Sending -> Done Success from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
            }
        } else {
            log.error("Transfer Sending -> Done Fail from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
        }
    }

    @Override
    protected void execute_ListMake() throws Exception {
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
    }

    @Override
    protected void execute_Finish() throws Exception {
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    @Override
    protected boolean execute_StopCheck() {
        if (QUE_SEND_INTERRUPT_FLAG) {
            QUE_SEND_INTERRUPT_FLAG = false;
            return true;
        }
        return false;
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        BufferedAgentPool pool = BufferedAgentPool.getBufferedObjectPool("queue", domain);
        if (pool == null) {
            pool = BufferedAgentPool.getBufferedObjectPool("single", domain);
        }
        return pool;
    }

    @Override
    protected void processSyntaxErrorSpool(String spool) throws Exception {
        log.error("que syntax error?", (Object)spool);
    }

    @Override
    protected void passDomainNotFound(String spool, Throwable e) throws Exception {
        log.error("que dns error?", (Object)spool.concat("=>").concat(e.toString()));
    }

    @Override
    protected void passRejectDomain(String spool) throws Exception {
    }
}

