/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.communicator;

import java.util.Vector;
import jupiter.common.communicator.SmtpCommunicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;

public class StandAloneSmtpCommunicator
extends SmtpCommunicator {
    private static final Logger log = LoggerFactory.getLogger(StandAloneSmtpCommunicator.class);
    protected long time_interval = 0L;
    protected Vector<Object> resultVector = new Vector();
    protected String MAIL_FROM = null;
    protected String MAIL_DATA = null;
    protected Vector<Object> rcptVector = null;

    public StandAloneSmtpCommunicator() throws Exception {
        this("StandAloneSmtpCommunicator");
    }

    public StandAloneSmtpCommunicator(String n) throws Exception {
        this.setName(n);
        this.rcptVector = new Vector();
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setMailFrom(String mail) {
        this.MAIL_FROM = mail;
    }

    public void setData(String data) {
        this.MAIL_DATA = data;
    }

    public void setRcptTo(String email) {
        this.rcptVector.addElement(email);
    }

    public Vector<Object> execute() {
        this.resultVector.clear();
        if (this.rcptVector == null || this.rcptVector.isEmpty()) {
            return this.resultVector;
        }
        String[] returnValue = new String[3];
        this.time_interval = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("into connect");
        }
        try {
            this.inner_work();
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            returnValue[0] = "FATAL ERROR";
            returnValue[1] = "99";
            returnValue[2] = e.toString();
            this.resultVector.addElement(returnValue);
        }
        if (this.CURR_STEP > 3) {
            if (log.isDebugEnabled()) {
                log.debug("step QUIT");
            }
            this.step((short)8, null, this.domain, 0);
        }
        if (log.isDebugEnabled()) {
            log.debug("step CLOSE");
        }
        this.close();
        this.rcptVector.clear();
        return this.resultVector;
    }

    private void inner_work() throws Exception {
        this.CURR_STEP = 0;
        if (log.isDebugEnabled()) {
            log.debug("step connect DOMAIN");
        }
        this.connect(this.domain, "0");
        if (this.sendState.isError()) {
            this.allErrorProcess();
            return;
        }
        this.step((short)3, eMsLocale.SMTP_LOCAL_HOST[0], this.domain, 0);
        if (this.sendState.isError()) {
            this.allErrorProcess();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("step MAIL_FROM");
        }
        this.step((short)4, this.MAIL_FROM, this.domain, 0);
        if (this.sendState.isError()) {
            this.allErrorProcess();
            return;
        }
        this.CURR_STEP = (short)4;
        if (log.isDebugEnabled()) {
            log.debug("step RCPT_TO");
        }
        String tmp = null;
        for (int i = 0; i < this.rcptVector.size(); ++i) {
            tmp = (String)this.rcptVector.get(i);
            this.step((short)5, tmp, this.domain, 0);
            if (!this.sendState.isError()) continue;
            this.errorProcess(tmp);
            this.rcptVector.remove(i);
            --i;
        }
        if (this.rcptVector.isEmpty()) {
            return;
        }
        this.CURR_STEP = (short)5;
        if (log.isDebugEnabled()) {
            log.debug("step DATA");
        }
        this.step((short)6, null, this.domain, 0);
        if (this.sendState.isError()) {
            this.allErrorProcess();
            return;
        }
        this.CURR_STEP = (short)6;
        if (log.isDebugEnabled()) {
            log.debug("step DATA_BODY");
        }
        this.step((short)7, this.MAIL_DATA, this.domain, 0);
        if (this.sendState.isError()) {
            this.allErrorProcess();
            return;
        }
        this.successProcess();
    }

    private void allErrorProcess() {
        String tmp = null;
        while (!this.rcptVector.isEmpty()) {
            tmp = (String)this.rcptVector.remove(0);
            this.errorProcess(tmp);
        }
    }

    private void successProcess() {
        String tmp = null;
        String[] returnValue = new String[3];
        while (!this.rcptVector.isEmpty()) {
            returnValue[0] = tmp = (String)this.rcptVector.remove(0);
            returnValue[1] = this.sendState.getRETURN_CODE();
            returnValue[2] = this.sendState.getMESSAGE();
            this.resultVector.addElement(returnValue);
        }
    }

    private void errorProcess(String mId) {
        String[] returnValue = new String[]{mId, this.sendState.getRETURN_CODE(), this.sendState.getMESSAGE()};
        this.resultVector.addElement(returnValue);
    }

    @Override
    public void log(String log) {
    }
}

