/*
 * Decompiled with CFR 0.152.
 */
package jupiter.common.communicator;

import freemarker20.template.SimpleHash;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.CodeAnalizer;
import pluto.lang.eMsLocale;
import pluto.log.Composer;
import pluto.log.FailedMailLogger;
import pluto.log.Log;
import pluto.log.SmtpLogger;
import pluto.mail.SendState;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.LookupUtil;
import pluto.mail.mx.MXSearchResult;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.mgs.util.TimeBasedSequenceIdFactory;
import pluto.net.SocketReaderAgent;
import pluto.util.Cal;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.SpoolingManager;

public abstract class SmtpCommunicator
extends SocketReaderAgent
implements Log {
    private static final Logger log = LoggerFactory.getLogger(SmtpCommunicator.class);
    protected SendState sendState = new SendState();
    protected String domain = null;
    protected Object RCPT_TO = null;
    protected short CURR_STEP = (short)-1;
    protected Composer composer = null;
    protected int AGENT_IDX = 0;
    public int INSTANCE_TIMEOUT_CONNECT = eMsLocale.TIMEOUT_CONNECT;
    public int INSTANCE_TIMEOUT_INIT = eMsLocale.TIMEOUT_INIT;
    public int INSTANCE_TIMEOUT_HELO = eMsLocale.TIMEOUT_HELO;
    public int INSTANCE_TIMEOUT_MAILFROM = eMsLocale.TIMEOUT_MAILFROM;
    public int INSTANCE_TIMEOUT_RCPT = eMsLocale.TIMEOUT_RCPT;
    public int INSTANCE_TIMEOUT_DATAINIT = eMsLocale.TIMEOUT_DATAINIT;
    public int INSTANCE_TIMEOUT_DATABLOCK = eMsLocale.TIMEOUT_DATABLOCK;
    public int INSTANCE_TIMEOUT_RSET = eMsLocale.TIMEOUT_RSET;
    protected StringBuffer TMP_BUFFER = null;
    protected static final boolean STEP_DEBUG = false;
    protected SimpleHash _MEMBER_HASH_ = new SimpleHash();

    public SmtpCommunicator() throws Exception {
        this(false);
    }

    public SmtpCommunicator(boolean regist) throws Exception {
        super(regist);
        this.TMP_BUFFER = new StringBuffer(256);
        this.composer = Composer.getComposerInstance();
    }

    public void setTIMEOUT_CONNECT(int timeout) {
        this.INSTANCE_TIMEOUT_CONNECT = timeout;
    }

    public void setTIMEOUT_INIT(int timeout) {
        this.INSTANCE_TIMEOUT_INIT = timeout;
    }

    public void setTIMEOUT_HELO(int timeout) {
        this.INSTANCE_TIMEOUT_HELO = timeout;
    }

    public void setTIMEOUT_MAILFROM(int timeout) {
        this.INSTANCE_TIMEOUT_MAILFROM = timeout;
    }

    public void setTIMEOUT_RCPT(int timeout) {
        this.INSTANCE_TIMEOUT_RCPT = timeout;
    }

    public void setTIMEOUT_DATAINIT(int timeout) {
        this.INSTANCE_TIMEOUT_DATAINIT = timeout;
    }

    public void setTIMEOUT_DATABLOCK(int timeout) {
        this.INSTANCE_TIMEOUT_DATABLOCK = timeout;
    }

    public void setTIMEOUT_RSET(int timeout) {
        this.INSTANCE_TIMEOUT_RSET = timeout;
    }

    protected void step(short step, String extra, String domain, String que_step) {
        this.step(step, extra, domain, Integer.parseInt(que_step));
    }

    protected void step(short step, String extra, String domain, int que_step) {
        int amountTimeout;
        this.CURR_STEP = step;
        this.sendState.reset();
        String send_string = null;
        String initial = null;
        switch (step) {
            case 98: {
                initial = "INIT";
                amountTimeout = this.INSTANCE_TIMEOUT_INIT;
                send_string = domain + ":" + 25;
                break;
            }
            case 2: {
                initial = "INIT";
                amountTimeout = this.INSTANCE_TIMEOUT_INIT;
                break;
            }
            case 3: {
                initial = "HELO";
                amountTimeout = this.INSTANCE_TIMEOUT_HELO;
                send_string = "HELO " + extra;
                break;
            }
            case 97: {
                String seq = TimeBasedSequenceIdFactory.seq(this._MEMBER_HASH_.getAsString("POST_ID"));
                this.sendState.setMGS_SEQ(seq);
                initial = "SEQ";
                amountTimeout = this.INSTANCE_TIMEOUT_HELO;
                send_string = eMsLocale.MGS_SEQ_HEADER + seq;
                break;
            }
            case 4: {
                initial = "MAILFROM";
                amountTimeout = this.INSTANCE_TIMEOUT_MAILFROM;
                send_string = "MAIL FROM: <".concat(extra).concat(">");
                break;
            }
            case 5: {
                initial = "RCPT";
                amountTimeout = this.INSTANCE_TIMEOUT_RCPT;
                send_string = "RCPT TO: <".concat(extra).concat(">");
                break;
            }
            case 6: {
                initial = "DATAINIT";
                amountTimeout = this.INSTANCE_TIMEOUT_DATAINIT;
                send_string = "DATA";
                break;
            }
            case 7: {
                initial = "DATABODY";
                amountTimeout = this.INSTANCE_TIMEOUT_DATABLOCK;
                send_string = extra.concat("\r\n.");
                break;
            }
            case 99: {
                initial = "RSET";
                send_string = "RSET";
                amountTimeout = this.INSTANCE_TIMEOUT_RSET;
                break;
            }
            case 8: {
                initial = "QUIT";
                send_string = "QUIT";
                amountTimeout = this.INSTANCE_TIMEOUT_RSET;
                break;
            }
            default: {
                this.sendState.set("UNKNOWN COMMAND", "99");
                return;
            }
        }
        String returnCode = null;
        String receiveString = null;
        try {
            if (step != 2) {
                this.send(send_string.getBytes(this._MEMBER_HASH_.getAsString("MAIL_BASE_CHAR_SET", eMsLocale.MAIL_BASE_CHAR_SET)));
            }
            if (step == 97) {
                return;
            }
            this.CONNECTED_SOCKET.setSoTimeout(amountTimeout);
            do {
                if ((receiveString = this.receive()) != null) continue;
                receiveString = "000 SEND NULL";
            } while ((returnCode = CodeAnalizer.searchReturnCode(initial.toLowerCase(), receiveString, domain)) != null && returnCode.equals("continue"));
            if (returnCode == null) {
                this.sendState.set(initial + " Receive Unknown response => " + receiveString, "95");
                return;
            }
            if (!returnCode.equals("00")) {
                this.sendState.set(initial + " receive[" + returnCode + "]" + "=>" + receiveString, returnCode);
                return;
            }
        }
        catch (Exception ex) {
            FailedMailLogger.put(Thread.currentThread().getName() + ", " + this.getConnectHost() + ", step : " + step + ", time : " + this.getElapsedTime());
            if (ex instanceof IOException) {
                this.sendState.set(initial + " receive[" + ex.toString() + "]=>550  NetworkError", "90");
            } else {
                this.sendState.set(initial + " receive[" + ex.toString() + "]=>550  SystemError", "90");
            }
            return;
        }
        this.sendState.set(receiveString, "00");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(String domain, String step) {
        this.domain = domain;
        this.CURR_STEP = 1;
        this.sendState.reset();
        MXSearchResult __TARGET_DNS_LIST__ = LookupCacheManager.getMXSearchResult(domain);
        MXSearchResult RELAY_SERVER_LIST = null;
        if (eMsLocale.MGS_FLAG) {
            RELAY_SERVER_LIST = LookupCacheManager.getMXrelayInfo();
        }
        MXSearchResult mXSearchResult = __TARGET_DNS_LIST__;
        synchronized (mXSearchResult) {
            boolean isOverValidTime;
            if (log.isDebugEnabled()) {
                log.debug("[__TARGET_DNS_LIST__]" + __TARGET_DNS_LIST__.toString() + "/" + __TARGET_DNS_LIST__.isError() + "/" + (__TARGET_DNS_LIST__.mxDomain == null));
            }
            if (log.isDebugEnabled()) {
                log.debug("[CountErrorRaise]" + __TARGET_DNS_LIST__.getCountErrorRaise());
            }
            boolean isFirst = __TARGET_DNS_LIST__.getError_type() == Integer.MIN_VALUE && __TARGET_DNS_LIST__.mxDomain == null;
            boolean isNotOverErrCnt = __TARGET_DNS_LIST__.isError() && __TARGET_DNS_LIST__.getCountErrorRaise() < LookupCacheManager.SEARCH_ERROR_DIRECT_SEARCH_COUNT;
            boolean bl = isOverValidTime = !__TARGET_DNS_LIST__.isValidTime();
            if (isFirst || isNotOverErrCnt || isOverValidTime) {
                if (log.isDebugEnabled()) {
                    log.debug("[touch]" + __TARGET_DNS_LIST__.toString());
                }
                __TARGET_DNS_LIST__.touch();
            }
        }
        if (__TARGET_DNS_LIST__.isError()) {
            Throwable e = __TARGET_DNS_LIST__.getError();
            if (e instanceof NameNotKnownException || e instanceof EOFException) {
                this.CONNECT_HOST = domain;
                this.sendState.set("550 HostUnknown:" + e.toString(), "20");
                return;
            }
            this.CONNECT_HOST = domain;
            this.sendState.set("550 DNS Search Error:" + e.toString(), "90");
            return;
        }
        if (log.isDebugEnabled()) {
            this.log("try connect");
        }
        int TRY_CONNECT_COUNT = 0;
        int TRY_INIT_COUNT = 0;
        int iConnectIndex = -1;
        String __CONNECT_HOST__ = null;
        int __CONNECT_HOST_IP__ = -1;
        this.TMP_BUFFER.setLength(0);
        this.TMP_BUFFER.append("Connect Fail => ");
        while (TRY_CONNECT_COUNT <= eMsLocale.SMTP_CONNECT_TRY_LIMIT && TRY_INIT_COUNT <= eMsLocale.SMTP_INIT_TRY_LIMIT && (iConnectIndex = __TARGET_DNS_LIST__.getTargetIndex()) != -1) {
            __CONNECT_HOST__ = __TARGET_DNS_LIST__.getDomain(iConnectIndex);
            __CONNECT_HOST_IP__ = __TARGET_DNS_LIST__.getIP(iConnectIndex);
            if (LookupCacheManager.RELAY_HOST_AFTER_DNS != null) {
                __CONNECT_HOST__ = LookupCacheManager.RELAY_HOST_AFTER_DNS;
                __CONNECT_HOST_IP__ = LookupCacheManager.RELAY_HOST_AFTER_DNS_IP;
            }
            if (LookupCacheManager.RELAY_DNS_HOSTS_ACTIVE) {
                String sDomain = "";
                String sIP = "";
                sIP = LookupCacheManager.RELAY_DNS_HOSTS.getProperty(__CONNECT_HOST__, "");
                if (!"".equals(sIP)) {
                    try {
                        __CONNECT_HOST_IP__ = Integer.parseInt(sIP);
                    }
                    catch (Exception e) {}
                } else {
                    int idx = __CONNECT_HOST__.lastIndexOf(46);
                    try {
                        sDomain = __CONNECT_HOST__.substring(__CONNECT_HOST__.lastIndexOf(46, idx - 1) + 1);
                        sIP = LookupCacheManager.RELAY_DNS_HOSTS.getProperty(sDomain, "");
                    }
                    catch (Exception e) {
                        sIP = "";
                    }
                    if (!"".equals(sIP)) {
                        try {
                            __CONNECT_HOST_IP__ = Integer.parseInt(sIP);
                        }
                        catch (Exception e) {}
                    } else {
                        try {
                            idx = __CONNECT_HOST__.lastIndexOf(46);
                            idx = __CONNECT_HOST__.lastIndexOf(46, idx - 1);
                            sDomain = __CONNECT_HOST__.substring(__CONNECT_HOST__.lastIndexOf(46, idx - 1) + 1);
                            sIP = LookupCacheManager.RELAY_DNS_HOSTS.getProperty(sDomain, "");
                        }
                        catch (Exception e) {
                            sIP = "";
                        }
                        if (!"".equals(sIP)) {
                            try {
                                __CONNECT_HOST_IP__ = Integer.parseInt(sIP);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            long longConnectStartTime = System.currentTimeMillis();
            try {
                if (eMsLocale.MGS_FLAG) {
                    this.connect(__CONNECT_HOST__, RELAY_SERVER_LIST.getIP(0), Integer.parseInt(eMsLocale.MGS_PORT), eMsLocale.TIMEOUT_CONNECT);
                } else {
                    this.connect(__CONNECT_HOST__, __CONNECT_HOST_IP__, 25, eMsLocale.TIMEOUT_CONNECT);
                }
            }
            catch (Exception e) {
                __TARGET_DNS_LIST__.setMXError(iConnectIndex, System.currentTimeMillis());
                this.TMP_BUFFER.append(__CONNECT_HOST__);
                this.TMP_BUFFER.append(":");
                this.TMP_BUFFER.append(e.toString());
                this.TMP_BUFFER.append(",");
                StringBuilder buffer = new StringBuilder(256);
                buffer.setLength(0);
                buffer.append("550 Error:[");
                buffer.append(__CONNECT_HOST__);
                buffer.append("#");
                buffer.append(String.valueOf(TRY_CONNECT_COUNT));
                buffer.append("] [");
                buffer.append(String.valueOf(System.currentTimeMillis() - longConnectStartTime));
                buffer.append("] ");
                buffer.append(e.toString());
                this.log(buffer.toString());
                FailedMailLogger.put(Thread.currentThread().getName() + ", " + this.getConnectHost() + ", step : " + step + ", time : " + this.getElapsedTime());
                if (e instanceof ConnectException) {
                    this.processBlanListHost(__CONNECT_HOST__);
                }
                ++TRY_CONNECT_COUNT;
                continue;
            }
            if (eMsLocale.MGS_FLAG) {
                this.step((short)98, null, LookupUtil.getIntIPToString(__CONNECT_HOST_IP__), step);
            } else {
                this.step((short)2, null, domain, step);
            }
            if (!this.sendState.isError()) break;
            __TARGET_DNS_LIST__.setMXError(iConnectIndex, System.currentTimeMillis());
            ++TRY_INIT_COUNT;
        }
        if (!this.isConnect()) {
            this.TMP_BUFFER.setLength(this.TMP_BUFFER.length() - 1);
            this.sendState.set(this.TMP_BUFFER.toString(), "80");
            return;
        }
        if (this.sendState.isError()) {
            return;
        }
        __TARGET_DNS_LIST__.resetMXError(iConnectIndex);
        this.sendState.set(null, "00");
    }

    protected void processBlanListHost(String hostname) {
    }

    protected void closeConnection() {
        if (this.CURR_STEP > 2) {
            this.step((short)8, null, this.domain, 0);
        }
        this.close();
    }

    public short getErrorType() {
        return this.sendState.getLogLevel();
    }

    protected void resultLog(String[] agentArray, String type, String code, String msg, short logLevel) {
        this.resultLog(agentArray, type, code, msg, logLevel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resultLog(String[] agentArray, String type, String code, String msg, short logLevel, String mgsSeq) {
        Object object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", agentArray[0]);
            this.composer.setProperty("T_TYPE", type);
            this.composer.setProperty("T_CODE", code);
            this.composer.setProperty("POST_ID", agentArray[1]);
            this.TMP_BUFFER.setLength(0);
            DelimConvertor.encodeToBuffer(this.TMP_BUFFER, agentArray[2]);
            this.composer.setProperty("M_ID", this.TMP_BUFFER.toString());
            this.composer.setProperty("ROW_ID", agentArray[12]);
            this.composer.setProperty("OS", agentArray[13]);
            this.composer.setProperty("NOTI_FLAG", agentArray[14]);
            this.composer.setProperty("STEP", agentArray[9]);
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", this.getConnectHost());
            this.composer.setProperty("DELAY", String.valueOf(super.getElapsedTime()));
            this.composer.setProperty("TOKEN_ID", agentArray[11]);
            this.composer.setProperty("DOMAIN", agentArray[7]);
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("LIST_TABLE", agentArray[10]);
            if (this.CURR_STEP < 7 && logLevel == 4 && agentArray[5] != null && agentArray[5].length() > 1) {
                try {
                    SpoolingManager.registSpool(agentArray[5]);
                    this.composer.setProperty("ETC_LOG", msg.concat("=> Que"));
                }
                catch (Exception e) {
                    log.error(this.getName(), (Object)("SpoolRegistError:" + e.toString()));
                    this.composer.setProperty("ETC_LOG", msg.concat("=> Que err:").concat(e.toString()));
                }
            } else {
                this.composer.setProperty("ETC_LOG", msg);
            }
            if (eMsLocale.MGS_FLAG) {
                this.composer.setProperty("MGS_SEQ", mgsSeq);
            }
            SmtpLogger.put(this.composer);
        }
        if (logLevel == 5) {
            // empty if block
        }
    }

    @Override
    public abstract void log(String var1);
}

