/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.Properties;
import jupiter.auto.send.task.RealTimeSendTask;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

public class PushRealTimeSendTask
extends RealTimeSendTask {
    private static final Logger log = LoggerFactory.getLogger(PushRealTimeSendTask.class);

    @Override
    public void setTaskProperty(Properties sendInfo) {
        this.TASK_PROPERTY = sendInfo;
        LIST_MAKER_CLASS_NAME = this.TASK_PROPERTY.getProperty("LIST_MAKER", "");
        String task_seq = String.valueOf(System.nanoTime());
        String msg_type = this.TASK_PROPERTY.getProperty("MSG_TYPE");
        String msg_type_seq = this.TASK_PROPERTY.getProperty("MSG_TYPE_SEQ");
        this.setName("PushRealTimeSendTask_" + msg_type + "_" + msg_type_seq + "_" + task_seq);
        this.setTaskID("PushRealTimeSendTask_" + msg_type + "_" + msg_type_seq);
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        this.update_thread_status("E0");
        if (this.spoolInfoList == null) {
            log.debug(" No Real Data.... So Skip ");
        }
        if (log.isDebugEnabled()) {
            log.debug("EXEC execute_ListSend");
        }
        log.info("PushRealTimeSendTask Loading get spoolInfoList is " + this.spoolInfoList.toString());
        for (SpoolInfo this.mailSpoolInfo : this.spoolInfoList) {
            if (this.mailSpoolInfo != null) {
                this.SPOOL_POPPER = Popper.getInstance();
                if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
                    log.debug("No Real Data.... So Skip");
                    return;
                }
                try {
                    this.SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
                }
                catch (Exception ex) {
                    log.error(this.getName(), (Throwable)ex);
                }
            } else {
                log.debug("PUSH SPOOL INFO IS NULL SO SKIP..");
                return;
            }
            if (this.SPOOL_POPPER == null) {
                log.error("No Real Data.... So Skip");
                return;
            }
            if (this.execute_StopCheck()) {
                throw new SendStopException(this.getName() + " receive stop signal");
            }
            RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);
            String nextSpool = null;
            int spoolPatchCount = 0;
            BufferedAgentPool pool = null;
            String domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
            while ((nextSpool = (String)this.SPOOL_POPPER.next()) != null) {
                if (nextSpool == null || nextSpool.length() < 1) continue;
                if (spoolPatchCount++ % this.instance_STOP_CHECK_RECYCLE == 0 && this.execute_StopCheck()) {
                    throw new SendStopException(this.getName() + " receive stop signal");
                }
                try {
                    if (domain == null) {
                        this.processSyntaxErrorSpool(nextSpool);
                        continue;
                    }
                    if (instanceRejectFilter != null) {
                        this.SPOOL_ANALYZER.parse(nextSpool);
                        if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) continue;
                        nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
                    }
                    pool = this.getBufferedObjectPool(domain);
                    pool.registSpool(domain, nextSpool);
                }
                catch (OutOfMemoryError outError) {
                    log.error("OOM error", (Throwable)outError);
                    System.gc();
                    try {
                        Thread.sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        SpoolingManager.registSpool(nextSpool);
                    }
                    catch (Exception ignore) {
                    }
                }
                catch (Throwable err) {
                    log.error(this.getName(), err);
                    ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("EXEC BufferedAgentPool.flushAll()");
            }
            BufferedAgentPool.flushAll();
            if (log.isDebugEnabled()) {
                log.debug("EXEC execute_ListSend [OK]");
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex_sub) {}
        }
        BufferedAgentPool.flushAll();
    }
}

