/*
 * Decompiled with CFR 0.152.
 */
package jupiter.auto.send.task;

import java.util.Properties;
import jupiter.auto.send.task.AutoBaseSendTask;
import jupiter.common.pool.BufferedAgentPool;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.mail.MailSendingInstanceFactory;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.task.SpoolControlTask;

public class CampListMakeTask
extends AutoBaseSendTask {
    private static final Logger log = LoggerFactory.getLogger(CampListMakeTask.class);
    public static String QUERY_UPDATE_CONTENT_CONF = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_CampListMakeTask");
        this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_ContentLoad() throws Exception {
        ContentPD targetContentPD = (ContentPD)MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, (short)5);
        targetContentPD.process(this.TASK_PROPERTY);
        this.SEND_CONTENT_INFO = targetContentPD.getContentInfo();
        ContentInfoManager.registContentInfo(this.SEND_CONTENT_INFO);
        String content_conf = ContentInfoManager.getContentInfo(this.POST_ID).getContentInfoPath();
        eMsStatement stmt = null;
        eMsConnection emsConnection = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            stmt = emsConnection.createStatement();
            Properties prop = new Properties();
            prop.setProperty("CONTENT_CONF", content_conf);
            prop.setProperty("POST_ID", this.TASK_PROPERTY.getProperty("POST_ID"));
            prop.setProperty("MSG_TYPE", this.TASK_PROPERTY.getProperty("MSG_TYPE"));
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_CONTENT_CONF, prop, "${", "}", true, false);
            stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
        }
        finally {
            emsConnection.recycleStatement(stmt);
            emsConnection.recycle();
        }
    }

    @Override
    protected void execute_ListLoad() throws Exception {
        SpoolControlTask targetTask = (SpoolControlTask)InstanceFactory.getInstance(this.TASK_PROPERTY, (short)7);
        targetTask.setTaskProperty(this.TASK_PROPERTY);
        targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);
        targetTask.internal_execute();
        this.mailSpoolInfo = targetTask.getSpoolInfo();
    }

    @Override
    protected void execute_Startup() throws Exception {
        this.updateTaskState("41", "10");
    }

    @Override
    protected void execute_SendStartUpdate() throws Exception {
    }

    @Override
    protected void execute_Finish() throws Exception {
        this.updateTaskState("41", "20");
    }

    @Override
    protected boolean execute_StopCheck() {
        throw new RuntimeException("NOT IMPLEMENT METHOD");
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        throw new RuntimeException("NOT IMPLEMENT METHOD");
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
    }

    static {
        try {
            QUERY_UPDATE_CONTENT_CONF = SqlManager.getQuery("COMMON", "QUERY_UPDATE_CONTENT_CONF");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

