/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.mass.task;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;

public class PersonalResendSpoolTask
extends AbstractDbSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(PersonalResendSpoolTask.class);
    protected LinkedList TARGET_INFO_LIST = null;
    protected static String QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = null;
    protected static String QUERY_UPDATE_LIST_STATE_QUERY = null;
    protected static String QUERY_SELECT_LIST_LOAD_QUERY = null;
    protected static String QUERY_SELECT_RESEND_TABLE_INFO = null;
    protected String instance_QUERY_TARGET_TABLE_INFO = null;

    public PersonalResendSpoolTask() throws Exception {
        super((short)2, 1L);
        this.setName("PersonalResendSpoolTask");
        this.setTaskID("PersonalResendSpoolTask");
        this.TARGET_INFO_LIST = new LinkedList();
    }

    public static void init(Object tmp) throws Exception {
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        this.WORK_FILE_ID = "personal_resend_".concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    public void setTaskProperty(Properties sendInfo) {
        if (this.TASK_PROPERTY == null) {
            this.TASK_PROPERTY = new Properties();
        }
        if (sendInfo != null) {
            this.TASK_PROPERTY.putAll((Map<?, ?>)sendInfo);
        }
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_personal_resend_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_PersonalResendSpoolTask");
        this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_LIST_LOAD_QUERY;
        this.UPDATE_TARGET_LIST_QUERY = QUERY_UPDATE_LIST_STATE_QUERY;
        this.instance_QUERY_TARGET_TABLE_INFO = QUERY_SELECT_RESEND_TABLE_INFO;
        this.SPOOL_ANALYZER.setSendType("MASSRESEND");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("Y");
        this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    public void makeSpoolFile() throws Exception {
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
        LinkedList<Properties> TARGET_TABLE_LIST = new LinkedList<Properties>();
        if (log.isDebugEnabled()) {
            log.debug("CALL GET TARGET TABLE LIST SQL");
        }
        try {
            __EMS_EXEC_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery(this.instance_QUERY_TARGET_TABLE_INFO);
            while (RS_SELECTED_SCHEDULE_INFO.next()) {
                Properties prop = new Properties();
                RS_SELECTED_SCHEDULE_INFO.putToMap(prop, false);
                TARGET_TABLE_LIST.addLast(prop);
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                RS_SELECTED_SCHEDULE_INFO.close();
            }
            catch (Exception ex) {}
            this.EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
        }
        String this_day = Cal.getDayDate();
        String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".spool";
        this.SPOOL_FILE_LIST.clear();
        this.LIST_APPEND_FLAG = false;
        try {
            this.openSpooler(__SPOOL_FILE_NAME__);
            for (Properties prop : TARGET_TABLE_LIST) {
                prop.setProperty("POST_ID", this.TASK_PROPERTY.getProperty("POST_ID"));
                this.execute_ListLoad(prop);
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            this.closeSpooler();
            if (!this.LIST_APPEND_FLAG) {
                this.deleteSpooler();
                if (log.isDebugEnabled()) {
                    log.debug("NO APPEND LIST FILE");
                }
            }
        }
    }

    @Override
    protected void makeSpoolInfo() throws Exception {
        String mapheader;
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.POST_ID);
        this.mailSpoolInfo.setSendState("PERSONAL_RESEND");
        String string = mapheader = this.MAPPING_HEADER_INFO == null ? this.TASK_PROPERTY.getProperty("MAPPINGHEADER") : this.MAPPING_HEADER_INFO.getProperty(this.POST_ID);
        if (mapheader == null) {
            mapheader = "map_";
        }
        this.mailSpoolInfo.setMappingHeader(mapheader == null ? this.getMappingHeader() : mapheader);
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_LIST);
        SpoolInfo oldSpInfo = SpoolInfoManager.getSpoolInfo(this.POST_ID);
        this.mailSpoolInfo.setDefaultMapping(oldSpInfo.getDefaultMapping());
        this.mailSpoolInfo.setDefaultHashMapping(oldSpInfo.getDefaultHashMapping());
        SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, true);
        if (this.SPOOL_FILE_LIST != null && this.SPOOL_FILE_LIST.size() > 0) {
            this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_LIST);
        }
    }

    @Override
    protected void addSpool(Properties prop) throws Exception {
        this.SPOOL_ANALYZER.setPostID(prop.getProperty("POST_ID"));
        this.SPOOL_ANALYZER.setListTable(prop.getProperty("LIST_TABLE"));
        this.SPOOL_ANALYZER.setTokenID(prop.getProperty("TMS_M_TOKEN"));
        this.SPOOL_ANALYZER.setMemberID(prop.getProperty("TMS_M_ID"));
        this.SPOOL_ANALYZER.setMemberName(prop.getProperty("TMS_M_NAME"));
        this.SPOOL_ANALYZER.setSecureFlag(prop.getProperty("SECURE_FLAG"));
        this.SPOOL_ANALYZER.setAdditionalValue(prop.getProperty("ADDITIONAL_INFO"));
        this.SPOOL_ANALYZER.setMapping(prop.getProperty("MAPPING"));
        this.appendSpooler(this.SPOOL_ANALYZER.composeSingleRcptSend());
    }

    protected boolean execute_StopCheck() {
        log.info("CHECK STOP SIGNAL");
        return false;
    }

    protected void processSyntaxErrorSpool(String spool) throws Exception {
    }

    static {
        try {
            QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_PERSONAL_RESEND_WORK_INFO");
            QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_LIST_STATE_QUERY");
            QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_LIST_LOAD_QUERY");
            QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_RESEND_TABLE_INFO");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

