/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.task;

import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import venus.spool.common.task.SpoolControlTask;

public abstract class AbstractDbSpoolTask
extends SpoolControlTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbSpoolTask.class);
    protected String LIST_TABLE = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected StringBuffer TMP_STRING_BUFFER = null;
    protected String SELECT_TARGET_LIST_QUERY = null;
    protected String SELECT_DIVIDE_TARGET_LIST_QUERY = null;
    protected String UPDATE_MKT_N_FILTER = null;
    protected String UPDATE_SCHD_FILTERED_TARGET = null;
    protected String UPDATE_TARGET_LIST_QUERY = null;

    public AbstractDbSpoolTask() throws Exception {
        super((short)1, 60000L);
    }

    public AbstractDbSpoolTask(short type) throws Exception {
        super(type, 60000L);
    }

    public AbstractDbSpoolTask(short type, long interval) throws Exception {
        super(type, interval);
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        if (log.isDebugEnabled()) {
            log.debug(" Request Connection");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        if (log.isDebugEnabled()) {
            log.debug(" Get-Connetion " + this.EMS_CONNECTION.getName());
        }
        this.TMP_STRING_BUFFER = new StringBuffer(1024);
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
        }
        this.TMP_STRING_BUFFER = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_ListLoad(Properties TARGET_PROPERTIES) throws Exception {
        block27: {
            log.info("spool make start [postId:{}" + TARGET_PROPERTIES.getProperty("POST_ID") + "]");
            eMsStatement __SELECT_STATEMENT__ = null;
            eMsStatement __UPDATE_STATEMENT__ = null;
            eMsResultSet rs = null;
            Exception ex = null;
            eMsPreparedStatement PS_SELECT_SEND_LIMIT_VALUE = null;
            eMsPreparedStatement PS_UPDATE_SEND_RESULT = null;
            eMsPreparedStatement PS_INSERT_SEND_LIMIT_VALUE = null;
            eMsPreparedStatement PS_UPDATE_SEND_LIMIT_VALUE = null;
            try {
                String pkIndexName;
                __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                __UPDATE_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                int spoolLimit = Integer.parseInt(TARGET_PROPERTIES.getProperty("DIVIDE_CNT", "-1"));
                if (spoolLimit == -1 || "N".equals(TARGET_PROPERTIES.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
                    spoolLimit = SPOOL_LIMIT;
                }
                this.TMP_STRING_BUFFER.setLength(0);
                if ("Y".equals(TARGET_PROPERTIES.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
                    pkIndexName = "PK_" + TARGET_PROPERTIES.getProperty("LIST_TABLE").substring(4);
                    TARGET_PROPERTIES.setProperty("PK_INDEX", pkIndexName);
                    TARGET_PROPERTIES.setProperty("SPOOL_LIMIT", String.valueOf(spoolLimit));
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_DIVIDE_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
                } else {
                    pkIndexName = "PK_" + TARGET_PROPERTIES.getProperty("LIST_TABLE").substring(4);
                    TARGET_PROPERTIES.setProperty("PK_INDEX", pkIndexName);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
                }
                log.info("SELECT_TARGET_LIST_QUERY : {} ", (Object)this.TMP_STRING_BUFFER.toString());
                rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
                Properties TARGET_INFO = new Properties();
                boolean isCamp = false;
                isCamp = "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("CAMP_YN", "N"));
                ArrayList<String> filteredMemberId = new ArrayList<String>();
                while (rs.next()) {
                    if (isCamp && "N".equalsIgnoreCase(rs.getString("MKT_FLAG")) && "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("MKT_YN"))) {
                        filteredMemberId.add(rs.getString("TMS_M_ID"));
                        continue;
                    }
                    TARGET_INFO.clear();
                    rs.putToMap(TARGET_INFO, this.APPEND_TOTAL_SPOOL);
                    if (this.UPDATE_TARGET_LIST_QUERY != null) {
                        this.TMP_STRING_BUFFER.setLength(0);
                        StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_TARGET_LIST_QUERY, TARGET_INFO, "${", "}", true, false);
                        if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                            log.error("list update fail");
                            continue;
                        }
                    }
                    ++this.addSpoolCount;
                    if (this.SPOOL_ATTACH_COUNT++ > spoolLimit) {
                        this.SPOOL_ATTACH_COUNT = 0;
                        String nextSpoolFileName = this.openNextSpooler();
                        log.debug("SWITCH SPOOL", (Object)nextSpoolFileName);
                    }
                    this.addSpool(TARGET_INFO);
                    this.LIST_APPEND_FLAG = true;
                }
                if (TARGET_INFO != null) {
                    this.lastSpoolMemberId = TARGET_INFO.getProperty("TMS_M_ID", "0");
                }
                log.info("make spool end [lastMemberId:" + this.lastSpoolMemberId + ", addSpoolCount:" + this.addSpoolCount + "]");
                if (!filteredMemberId.isEmpty()) {
                    Properties UPDATE_INFO = new Properties();
                    UPDATE_INFO.setProperty("LIST_TABLE", this.LIST_TABLE);
                    UPDATE_INFO.setProperty("POST_ID", this.POST_ID);
                    for (String memberId : filteredMemberId) {
                        UPDATE_INFO.setProperty("MEMBER_ID", memberId);
                        this.TMP_STRING_BUFFER.setLength(0);
                        StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_MKT_N_FILTER, UPDATE_INFO, "${", "}", true, false);
                        if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) >= 1) continue;
                        log.error("MKT_FLAG Y=>N Changed Target User Filter Update Fail / MemberId : " + memberId);
                    }
                    UPDATE_INFO.setProperty("FILTER_CNT", filteredMemberId.size() + "");
                    this.TMP_STRING_BUFFER.setLength(0);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_SCHD_FILTERED_TARGET, UPDATE_INFO, "${", "}", true, false);
                    if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                        log.error("CAMP SCHD FILTER CNT UPDATE FAIL / FILTER_CNT :  " + filteredMemberId.size());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(e.toString());
                ex = e;
            }
            finally {
                log.info("spool make end [postId:{}" + TARGET_PROPERTIES.getProperty("POST_ID") + "]");
                try {
                    rs.close();
                }
                catch (Exception e) {}
                if (PS_SELECT_SEND_LIMIT_VALUE != null) {
                    PS_SELECT_SEND_LIMIT_VALUE.close();
                    PS_SELECT_SEND_LIMIT_VALUE = null;
                }
                if (PS_UPDATE_SEND_RESULT != null) {
                    PS_UPDATE_SEND_RESULT.close();
                    PS_UPDATE_SEND_RESULT = null;
                }
                if (PS_INSERT_SEND_LIMIT_VALUE != null) {
                    PS_INSERT_SEND_LIMIT_VALUE.close();
                    PS_INSERT_SEND_LIMIT_VALUE = null;
                }
                if (PS_UPDATE_SEND_LIMIT_VALUE != null) {
                    PS_UPDATE_SEND_LIMIT_VALUE.close();
                    PS_UPDATE_SEND_LIMIT_VALUE = null;
                }
                this.EMS_CONNECTION.recycleStatement(__UPDATE_STATEMENT__);
                this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
                if (ex == null) break block27;
                throw ex;
            }
        }
    }
}

