/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.popper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.compress.ZipFileManager;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.io.eMsFileReader;
import pluto.util.StringUtil;
import venus.spool.common.popper.NoSpoolFileException;

public abstract class Popper {
    private static final Logger log = LoggerFactory.getLogger(Popper.class);
    private static String class_name = null;
    private Properties task_prop = null;
    private static String db_driver = "";
    private static String db_url = "";
    private static String db_id = "";
    private static String db_pw = "";
    private static String filter_backup_path = "";
    private static String spool_filter_path = "";
    private static String server_id = "";
    private static String R_STATE = "20";
    private static int MEMBER_ID_POINT = 11;
    private int total_deny_cnt = 0;
    protected eMsFileReader innerReader = null;
    protected String dir = null;
    protected String[] files = null;
    protected int file_index = 0;

    public static final void ConvertString(StringBuffer tmpBuffer, String src, Properties map, String start, String end, boolean query, boolean empty) {
        if (src == null) {
            return;
        }
        if (map == null) {
            tmpBuffer.append(src);
            return;
        }
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        String value = null;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            key = src.substring(idx1 + start.length(), idx2);
            value = map.getProperty(key);
            tmpBuffer.append(src.substring(idx3, idx1));
            if (value == null) {
                if (empty) {
                    tmpBuffer.append(start);
                    tmpBuffer.append(key);
                    tmpBuffer.append(end);
                }
            } else if (query) {
                Popper.ConvertString(tmpBuffer, value.toString(), "'", "''");
            } else {
                tmpBuffer.append(value.toString());
            }
            idx3 = idx2 + end.length();
        }
        tmpBuffer.append(src.substring(idx3));
    }

    public static final void ConvertString(StringBuffer tmpBuffer, String source, String target, String dest) {
        if (source == null) {
            return;
        }
        int idx1 = 0;
        int idx2 = 0;
        while ((idx1 = source.indexOf(target, idx2)) >= 0) {
            tmpBuffer.append(source.substring(idx2, idx1));
            tmpBuffer.append(dest);
            idx2 = idx1 + target.length();
        }
        tmpBuffer.append(source.substring(idx2));
    }

    public void setTaskProp(Properties prop) {
        this.task_prop = prop;
    }

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        class_name = tmp.getProperty("target.class");
        Class.forName(class_name).newInstance();
        db_driver = tmp.getProperty("db.driver");
        db_url = tmp.getProperty("db.url");
        db_id = tmp.getProperty("db.id");
        db_pw = tmp.getProperty("db.pw");
        filter_backup_path = tmp.getProperty("back.spool.path");
        spool_filter_path = tmp.getProperty("spool.filter.path");
        server_id = tmp.getProperty("server.id");
    }

    public static synchronized Popper getInstance() {
        try {
            return (Popper)Class.forName(class_name).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Popper() {
    }

    public void init(String base, String file) throws Exception {
        String[] files = new String[]{file};
        this.init(base, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remakeSpoolFile(Connection conn, eMsConnection EMS_CONNECTION, String base_path, String spool_name, String spool_path, String spool_back_path, String query) throws SQLException {
        FileReader fr = null;
        try {
            fr = new FileReader(spool_back_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            log.error(" [ File not found Exception ] " + e.toString());
        }
        BufferedReader br = new BufferedReader(fr);
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        FileOutputStream filter_fos = null;
        OutputStreamWriter filter_osw = null;
        String filter_full_path = base_path + "/" + spool_filter_path + "/" + spool_name;
        try {
            fos = new FileOutputStream(spool_path);
            osw = new OutputStreamWriter(fos);
            filter_fos = new FileOutputStream(filter_full_path);
            filter_osw = new OutputStreamWriter(filter_fos);
        }
        catch (FileNotFoundException e1) {
            log.error("file not found error", (Throwable)e1);
        }
        String line = "";
        ResultSet rs = null;
        String checkDeny = "";
        String[] spool_info = null;
        String member_id = "";
        PreparedStatement pstmt = null;
        eMsPreparedStatement listtable_update = null;
        String updateListQuery = SqlManager.getQuery("ReFilter", "QUERY_UPDATE_ERRORCODE_LISTTABLE");
        Properties prop = new Properties();
        String post_id = this.task_prop.getProperty("POST_ID").trim();
        String list_table = "";
        if (this.task_prop.getProperty("CHANNEL_TYPE").equals("EM")) {
            list_table = "TMS_EMAIL_LIST_" + post_id.substring(4, 6);
        } else if (this.task_prop.getProperty("CHANNEL_TYPE").equals("SM")) {
            list_table = "TMS_SMS_LIST_" + post_id.substring(4, 6);
        }
        prop.setProperty("LIST_TABLE", list_table);
        StringBuffer buffer = new StringBuffer(512);
        buffer.setLength(0);
        Popper.ConvertString(buffer, updateListQuery, prop, "@{", "}", false, false);
        updateListQuery = buffer.toString();
        log.debug("[DENY_UPDATE_QUERY]" + updateListQuery);
        boolean updateCnt = false;
        int total_cnt = 0;
        int send_cnt = 0;
        int deny_cnt = 0;
        int result_update = 0;
        try {
            while ((line = br.readLine()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("kdy0831 ==>" + line);
                }
                spool_info = line.split("\\|");
                member_id = spool_info[MEMBER_ID_POINT];
                if (pstmt == null) {
                    pstmt = conn.prepareStatement(query);
                }
                pstmt.clearParameters();
                pstmt.setString(1, member_id);
                rs = pstmt.executeQuery();
                rs.next();
                checkDeny = rs.getString(1);
                if (log.isDebugEnabled()) {
                    log.debug("[member_id]" + member_id + "[checkDeny]" + checkDeny);
                }
                if (!"0".equals(checkDeny)) {
                    osw.write(line + "\r\n");
                    osw.flush();
                    ++send_cnt;
                    continue;
                }
                prop.clear();
                prop.setProperty("MEMBER_ID", member_id);
                prop.setProperty("POST_ID", post_id);
                if (listtable_update == null) {
                    try {
                        listtable_update = EMS_CONNECTION.prepareStatement(updateListQuery, "${", "}");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(e.getMessage());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("member_id ==>" + member_id);
                }
                result_update = listtable_update.executeUpdate(prop);
                filter_osw.write(line + "\r\n");
                filter_osw.flush();
                if (updateCnt < true) {
                    // empty if block
                }
                ++deny_cnt;
            }
            ++total_cnt;
            this.total_deny_cnt += deny_cnt;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(" [ File Read Fail _io] " + e.toString());
        }
        catch (SQLException se) {
            se.printStackTrace();
            log.error(" [ File Read Fail _sql] " + se.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(" [ Exception] " + e.toString());
        }
        finally {
            if (filter_fos != null) {
                try {
                    filter_fos.close();
                }
                catch (IOException e1) {
                    log.error("error", (Throwable)e1);
                }
            }
            if (filter_osw != null) {
                try {
                    filter_osw.close();
                }
                catch (IOException e1) {
                    log.error("error", (Throwable)e1);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    log.error("error", (Throwable)e1);
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e1) {
                    log.error("error", (Throwable)e1);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e1) {
                    log.error("error", (Throwable)e1);
                }
            }
            if (fr != null) {
                try {
                    br.close();
                }
                catch (IOException e1) {
                    log.error("error", (Throwable)e1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (SQLException e) {}
            }
            if (listtable_update != null) {
                listtable_update.close();
                listtable_update = null;
            }
        }
        log.debug("[spool_path]" + spool_path + "[total_cnt]" + total_cnt + "[send_cnt]" + send_cnt + "[deny_cnt]" + deny_cnt);
    }

    public void init(String base, String[] files) throws Exception {
        boolean queue_yn = false;
        if (files.length < 1) {
            throw new NoSpoolFileException("NO Files");
        }
        if (this.innerReader != null) {
            this.close();
        }
        int files_cnt = files.length;
        String[] convert_files = new String[files_cnt];
        for (int i = 0; i < files_cnt; ++i) {
            if (ZipFileManager.isCompressed(files[i])) {
                try {
                    convert_files[i] = ZipFileManager.unZip(files[i], base, true);
                }
                catch (Exception ex) {
                    log.error(" Unzip Error " + ex.toString());
                    convert_files[i] = files[i];
                }
            } else {
                convert_files[i] = files[i];
            }
            if (convert_files[i].indexOf("mqueue") <= 0) continue;
            queue_yn = true;
        }
        String rstate = "";
        String redeny = "";
        if (queue_yn) {
            rstate = "";
            redeny = "N";
        } else if (this.task_prop != null) {
            rstate = this.task_prop.getProperty("SEND_STATE", "").trim();
            redeny = this.task_prop.getProperty("REDENY_FLAG", "").trim();
            if (R_STATE.equals(rstate) && "Y".equals(redeny)) {
                String mail_kind = this.task_prop.getProperty("MAIL_KIND", "").trim();
                if ("A".equals(mail_kind) || "B".equals(mail_kind)) {
                    Connection deny_conn = null;
                    eMsConnection EMS_CONNECTION = null;
                    File ori_spool = null;
                    File rename_spool = null;
                    String query = "";
                    String spool_path = "";
                    String spool_name = "";
                    eMsPreparedStatement UPDATE_TYPE_97_SCHD_INFO = null;
                    try {
                        String sql = "";
                        Class.forName(db_driver).newInstance();
                        deny_conn = DriverManager.getConnection(db_url, db_id, db_pw);
                        EMS_CONNECTION = ConnectionPool.getConnection();
                        if ("A".equals(mail_kind)) {
                            query = SqlManager.getQuery("ReFilter", "QUERY_SELECT_DENY_COUNT_PERIOD");
                        } else if ("B".equals(mail_kind)) {
                            query = SqlManager.getQuery("ReFilter", "QUERY_SELECT_DENY_COUNT_ADVERTISE");
                        }
                        for (int i = 0; i < convert_files.length; ++i) {
                            ori_spool = new File(convert_files[i]);
                            spool_path = convert_files[i].substring(0, convert_files[i].toString().lastIndexOf("spool/") + 5);
                            spool_name = convert_files[i].substring(convert_files[i].toString().lastIndexOf("/") + 1, convert_files[i].toString().length());
                            if (StringUtil.isNull(base)) {
                                base = spool_path;
                            }
                            rename_spool = new File(base + "/" + filter_backup_path + "/" + spool_name);
                            ori_spool.renameTo(rename_spool);
                            if (ori_spool.exists()) {
                                throw new Exception("[ERROR][RENAME][FILE EXIST]" + convert_files[i]);
                            }
                            this.remakeSpoolFile(deny_conn, EMS_CONNECTION, base, spool_name, convert_files[i], base + "/" + filter_backup_path + "/" + spool_name, query);
                        }
                        String QUERY_UPDATE_FILTER_CNT_SCHD_INFO = SqlManager.getQuery("ReFilter", "QUERY_UPDATE_FILTER_CNT_SCHD_INFO");
                        UPDATE_TYPE_97_SCHD_INFO = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_FILTER_CNT_SCHD_INFO, "${", "}");
                        Properties prop = new Properties();
                        String postId = this.task_prop.getProperty("POST_ID");
                        if (postId.length() >= 13) {
                            postId = postId.substring(0, 13);
                        }
                        prop.setProperty("POST_ID", this.task_prop.getProperty("POST_ID"));
                        prop.setProperty("TYPE_97_ERROR", String.valueOf(this.total_deny_cnt));
                        prop.setProperty("SERVER_ID", server_id);
                        this.total_deny_cnt = 0;
                        UPDATE_TYPE_97_SCHD_INFO.executeUpdate(prop);
                    }
                    catch (Exception e) {
                        log.error("[ERROR][reDenyFilter]", (Throwable)e);
                        throw e;
                    }
                    finally {
                        if (deny_conn != null) {
                            try {
                                deny_conn.close();
                                deny_conn = null;
                            }
                            catch (Exception ee) {}
                        }
                        if (EMS_CONNECTION != null) {
                            try {
                                EMS_CONNECTION.recycle();
                                EMS_CONNECTION = null;
                            }
                            catch (Exception ee) {}
                        }
                        if (UPDATE_TYPE_97_SCHD_INFO != null) {
                            UPDATE_TYPE_97_SCHD_INFO.close();
                            UPDATE_TYPE_97_SCHD_INFO = null;
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("[SKIP reDenyFilter][POST_ID]" + this.task_prop.getProperty("POST_ID") + "[mail_kind]:" + mail_kind);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("[SKIP reDenyFilter][POST_ID]" + this.task_prop.getProperty("POST_ID") + "[rstate]:" + rstate + "[rstate]:" + redeny);
            }
        }
        this.files = convert_files;
        if (!queue_yn && this.task_prop != null) {
            if (log.isDebugEnabled()) {
                log.debug("[convert_files][POST_ID]" + this.task_prop.getProperty("POST_ID") + "[convert_files]:" + convert_files.toString());
            }
            if (log.isDebugEnabled()) {
                for (int i = 0; i < this.files.length; ++i) {
                    log.debug("[POST_ID]" + this.task_prop.getProperty("POST_ID") + "[this.files]" + i + ":" + this.files[i]);
                }
            }
        }
        this.dir = base;
        this.file_index = 0;
        this.innerReader = new eMsFileReader(this.files[0]);
    }

    public void init(String base, List file) throws Exception {
        String[] files = new String[file.size()];
        for (int i = 0; i < file.size(); ++i) {
            files[i] = (String)file.get(i);
        }
        this.init(base, files);
    }

    protected boolean check_next() throws Exception {
        if (this.file_index++ > this.files.length - 2) {
            return false;
        }
        this.innerReader.close();
        if (log.isDebugEnabled()) {
            log.debug("dir=[" + this.dir + "] // file=[" + this.files[this.file_index] + "]");
            log.debug("dir=[" + this.dir + "] // file=[" + this.files[this.file_index] + "]");
        }
        this.innerReader = new eMsFileReader(this.files[this.file_index]);
        return true;
    }

    public void close() {
        try {
            this.innerReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.innerReader = null;
    }

    public String[] getFiles() {
        return this.files;
    }

    public abstract Object next() throws Exception;

    public abstract boolean check();
}

