/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.basic;

import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InstanceFactory {
    private static final Logger log = LoggerFactory.getLogger(InstanceFactory.class);
    public static final String __UNDER_BAR__ = "_";
    private static final String name = "InstanceFactory";
    private static Hashtable InstanceMap = new Hashtable();

    public static String getName() {
        return name;
    }

    public static void init(Object tmp) throws Exception {
        Element TargetNode = (Element)tmp;
        Element SubNode = null;
        String SendTypeName = null;
        String SendStateName = null;
        String InstanceName = null;
        String InstanceClassName = null;
        NodeList TargetNodeList = TargetNode.getElementsByTagName("type");
        int TargetNodeCount = TargetNodeList.getLength();
        for (int i = 0; i < TargetNodeCount; ++i) {
            TargetNode = (Element)TargetNodeList.item(i);
            SendTypeName = TargetNode.getAttribute("value");
            SendStateName = TargetNode.getAttribute("state");
            NodeList TargetInstanceNodeList = TargetNode.getElementsByTagName("Instance");
            for (int j = 0; j < TargetInstanceNodeList.getLength(); ++j) {
                SubNode = (Element)TargetInstanceNodeList.item(j);
                InstanceName = SubNode.getAttribute("name");
                InstanceClassName = SubNode.getAttribute("class");
                Class<?> targetClass = Class.forName(InstanceClassName);
                InstanceMap.put(SendStateName.concat(__UNDER_BAR__).concat(SendTypeName).concat(__UNDER_BAR__).concat(InstanceName), targetClass);
            }
        }
    }

    public static Object getInstance(Properties info, short instance_type) throws Exception {
        Object returnValue = InstanceFactory.getInstance(info.getProperty("SEND_TYPE"), info.getProperty("SEND_STATE"), instance_type);
        if (log.isDebugEnabled()) {
            log.debug(info.toString(), (Object)returnValue.getClass().getName());
        }
        return returnValue;
    }

    public static Object getInstance(String type, String state, short instance_type) throws Exception {
        String TargetKey = null;
        switch (instance_type) {
            case 7: {
                TargetKey = state.concat(__UNDER_BAR__).concat(type).concat("_SpoolTask");
                break;
            }
            default: {
                throw new RuntimeException("Invalid Instance Type");
            }
        }
        Class classes = (Class)InstanceMap.get(TargetKey);
        if (classes == null) {
            throw new RuntimeException("Unregist Instance Type=>" + TargetKey);
        }
        return classes.newInstance();
    }
}

