/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.auto.task;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import venus.spool.auto.basic.TestDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;

public class AutoTestSpoolTask
extends SpoolControlTask {
    private static final Logger log = LoggerFactory.getLogger(AutoTestSpoolTask.class);
    protected String targetfile = null;

    @Override
    public void setTaskProperty(Properties prop) {
        if (this.TASK_PROPERTY == null) {
            this.TASK_PROPERTY = new Properties();
        }
        if (prop != null) {
            this.TASK_PROPERTY.putAll((Map<?, ?>)prop);
        }
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.WORK_FILE_ID = this.POST_ID.concat("_test_one_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_AutoTestSpoolTask");
        this.targetfile = this.TASK_PROPERTY.getProperty("TARGET_LIST_FILE");
    }

    @Override
    public void makeSpoolFile() throws Exception {
        String this_day = Cal.getDayDate();
        String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".spool";
        try {
            this.openSpooler(__SPOOL_FILE_NAME__);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.targetfile), eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
            while (br.ready()) {
                this.appendSpooler(br.readLine());
            }
            br.close();
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            this.closeSpooler();
            if (!this.LIST_APPEND_FLAG) {
                this.deleteSpooler();
            }
        }
    }

    public void makeSpoolFile_TEST() throws Exception {
        String this_day = Cal.getDayDate();
        String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".spool";
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            this.openSpooler(__SPOOL_FILE_NAME__);
            in = new FileInputStream(this.targetfile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Object)e.toString());
            throw e;
        }
        finally {
            in.close();
            out.close();
        }
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void addSpool(Properties prop) {
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    protected void makeSpoolInfo() throws Exception {
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.TASK_PROPERTY.getProperty("POST_ID"));
        this.mailSpoolInfo.setSendState(this.TASK_PROPERTY.getProperty("SEND_STATE"));
        this.mailSpoolInfo.setMappingHeader(this.getMappingHeader());
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_LIST);
        TestDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new TestDefaultMappingGenerator();
        __DEFAULT_MAPPING_GENERATOR__.process(this.TASK_PROPERTY);
        this.mailSpoolInfo.setDefaultMapping(__DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping());
        this.mailSpoolInfo.setDefaultHashMapping(__DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping());
        SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, false);
    }
}

