/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.recycle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.DebugLogChannel;
import pluto.util.recycle.Bufferable;
import pluto.util.recycle.BufferedObjectPool;
import pluto.util.recycle.SampleBufferable;

public class SampleBufferedPool
extends BufferedObjectPool {
    private static final Logger log = LoggerFactory.getLogger(SampleBufferedPool.class);

    public SampleBufferedPool() throws Exception {
        this.LOG_CHANNEL_INSTANCE = new DebugLogChannel("c:/work/out.log", false);
    }

    @Override
    protected Bufferable create(int seq, int level) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("INTO CREATE METHOD");
        }
        SampleBufferable returnValue = new SampleBufferable(level);
        if (log.isDebugEnabled()) {
            log.debug("CREATE INSTANCE");
        }
        returnValue.setBufferBin(this);
        if (log.isDebugEnabled()) {
            log.debug("CREATE SUCCESS AND RETURN => " + returnValue.getName());
        }
        return returnValue;
    }

    public static void main(String[] arg) throws Exception {
        SampleBufferedPool pool = new SampleBufferedPool();
        pool.resetWorkerSize(10);
        for (int i = 0; i < 500; ++i) {
            pool.push("DRAGON#".concat(String.valueOf(i)));
        }
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        pool.flush();
        System.exit(1);
    }

    @Override
    protected void check() throws Exception {
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public void log(String log) {
    }
}

