/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.recycle;

import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.util.recycle.BufferBin;
import pluto.util.recycle.Bufferable;

public class SampleBufferable
implements Bufferable,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(SampleBufferable.class);
    BufferBin INNER_BUFFERED_BIN = null;
    String name = null;
    boolean alive = false;
    Stack RCPT_TO = new Stack();

    public SampleBufferable(int level) {
        this.name = "W#".concat(String.valueOf(level));
    }

    @Override
    public void clean() {
        this.RCPT_TO.clear();
    }

    @Override
    public void destroy() {
        log.error(" Call destroy Method... from : " + Thread.currentThread().getName());
        this.clean();
        this.INNER_BUFFERED_BIN.destroy(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setBufferBin(BufferBin bin) {
        this.INNER_BUFFERED_BIN = bin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnd() {
        log.error(" Call setEnd Method... from : " + Thread.currentThread().getName());
        this.alive = false;
        SampleBufferable sampleBufferable = this;
        synchronized (sampleBufferable) {
            this.notifyAll();
        }
    }

    @Override
    public void execute() {
        Thread a = new Thread((Runnable)this, this.getName());
        a.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.alive = true;
        SampleBufferable sampleBufferable = this;
        synchronized (sampleBufferable) {
            this.notifyAll();
        }
        while (this.alive) {
            this.RCPT_TO.clear();
            Object rcpt = null;
            while (rcpt == null && this.alive) {
                this.INNER_BUFFERED_BIN.log(this.getName() + "==> into bins popup ");
                rcpt = this.INNER_BUFFERED_BIN.popup();
                if (rcpt == null) continue;
                this.INNER_BUFFERED_BIN.log(this.getName() + "==> out bins popup ");
                this.RCPT_TO.push(rcpt);
            }
            if (rcpt == null && this.RCPT_TO.size() == 0) continue;
            while ((rcpt = this.INNER_BUFFERED_BIN.popupNoWait()) != null) {
                this.INNER_BUFFERED_BIN.log(" add rcpt....");
                this.RCPT_TO.push(rcpt);
            }
            try {
                this.toDo();
            }
            catch (Throwable error) {
                this.INNER_BUFFERED_BIN.log(this.getName() + "==> is catch Throwable : " + error.toString());
                log.error("error", error);
                if (!(error instanceof ThreadDeath)) continue;
                this.alive = false;
            }
        }
        this.INNER_BUFFERED_BIN.log(this.getName() + "==> is die....");
        this.destroy();
    }

    protected void toDo() {
        while (this.RCPT_TO.size() > 0) {
            this.INNER_BUFFERED_BIN.log("RESULT|".concat(this.getName()).concat("|").concat(this.RCPT_TO.pop().toString()));
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

