/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.recycle;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.LogChannel;
import pluto.schedule.ScheduledMonitor;
import pluto.util.FIFOBuffer;
import pluto.util.recycle.BufferBin;
import pluto.util.recycle.Bufferable;

public abstract class BufferedObjectPool
extends ScheduledMonitor
implements BufferBin {
    private static final Logger log = LoggerFactory.getLogger(BufferedObjectPool.class);
    protected static final boolean POOL_DEBUG = false;
    protected static final boolean INOUT_DEBUG = false;
    protected volatile boolean FLUSH_LOCKING_FLAG = false;
    protected Object LOCK_OF_INPUT = new Object();
    protected Object LOCK_OF_OUTPUT = new Object();
    protected LogChannel LOG_CHANNEL_INSTANCE = null;
    protected FIFOBuffer STACK_OF_BUFFERED_OBJECT = null;
    protected LinkedList WORKER_LIST = null;
    protected int CAPACITY = 0;
    protected int RESET_SIZE = 0;
    protected int LEVEL_OF_BUFFERABLE = 0;
    protected int INDEX_OF_BUFFERABLE = 0;
    protected int NAME_INDEX_OF_CREATE_BUFFERABLE = 0;
    protected long LAST_TOUCH_TIME = -1L;
    protected long LAST_FLUSH_TIME = -1L;
    protected boolean NEXT_FLUSH_FLAG = false;
    protected boolean BUFFER_IS_MODIFIED = false;

    public BufferedObjectPool() {
        throw new RuntimeException("NOT IMPLEMENT CONSTRUCTOR");
    }

    protected BufferedObjectPool(long flush_check_interval, String name) {
        super(flush_check_interval, name);
        this.CAPACITY = 0;
        this.LEVEL_OF_BUFFERABLE = 0;
        this.STACK_OF_BUFFERED_OBJECT = new FIFOBuffer(10);
        this.WORKER_LIST = new LinkedList();
    }

    @Override
    protected void check() throws Exception {
        if (this.NEXT_FLUSH_FLAG || System.currentTimeMillis() > this.LAST_FLUSH_TIME + 300000L) {
            this.flush();
            this.LAST_FLUSH_TIME = System.currentTimeMillis();
            this.NEXT_FLUSH_FLAG = false;
        }
    }

    public synchronized void registFlush() {
        this.log("CALL registFlush() method");
        this.NEXT_FLUSH_FLAG = true;
        this.interruptInnerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(Bufferable src) {
        this.log(src.getName() + " is remove");
        LinkedList linkedList = this.WORKER_LIST;
        synchronized (linkedList) {
            this.WORKER_LIST.remove(src);
        }
        try {
            this.resetWorkerSize(this.CAPACITY);
        }
        catch (Exception e) {
            this.log("destroy reSize Error:" + e.toString());
        }
    }

    @Override
    public int getWorkerSize() {
        return this.CAPACITY;
    }

    @Override
    public int getBufferSize() {
        return this.STACK_OF_BUFFERED_OBJECT.size();
    }

    @Override
    public synchronized void resetBufferSize(int size) {
        this.STACK_OF_BUFFERED_OBJECT.reSize(size);
    }

    protected synchronized void setWorkerSize(int size) throws Exception {
        this.log("CALL setWorkerSize()");
        this.CAPACITY = size;
        Bufferable target = null;
        while (this.CAPACITY > this.WORKER_LIST.size()) {
            target = this.create(this.LEVEL_OF_BUFFERABLE++, this.INDEX_OF_BUFFERABLE++);
            this.WORKER_LIST.addLast(target);
            target.execute();
        }
    }

    protected synchronized void setWorkerSize(int size, int rsize) throws Exception {
        this.RESET_SIZE = rsize;
        this.setWorkerSize(size);
    }

    @Override
    public synchronized void resetWorkerSize(int size) throws Exception {
        this.log("CALL resetWorkerSize()");
        this.CAPACITY = size;
        if (this.CAPACITY == this.WORKER_LIST.size()) {
            return;
        }
        this.flush();
        if (this.CAPACITY < this.WORKER_LIST.size()) {
            Bufferable target = null;
            while (this.CAPACITY < this.WORKER_LIST.size()) {
                target = (Bufferable)this.WORKER_LIST.removeLast();
                target.setEnd();
            }
            this.notifyAll();
            return;
        }
        if (this.CAPACITY > this.WORKER_LIST.size()) {
            Bufferable target = null;
            while (this.CAPACITY > this.WORKER_LIST.size()) {
                target = this.create(this.LEVEL_OF_BUFFERABLE++, this.INDEX_OF_BUFFERABLE++);
                this.WORKER_LIST.addLast(target);
                target.execute();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object popup() {
        Object returnValue = null;
        int wait_count = 0;
        while (true) {
            returnValue = this.STACK_OF_BUFFERED_OBJECT.pop();
            Object object = this.LOCK_OF_INPUT;
            synchronized (object) {
                this.LOCK_OF_INPUT.notify();
            }
            if (returnValue != null) {
                this.LAST_TOUCH_TIME = System.currentTimeMillis();
                return returnValue;
            }
            object = this.LOCK_OF_OUTPUT;
            synchronized (object) {
                if (wait_count < 10) {
                    ++wait_count;
                    try {
                        this.LOCK_OF_OUTPUT.wait(5000L);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        this.LOCK_OF_OUTPUT.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object popupNoWait() {
        Object returnValue = null;
        returnValue = this.STACK_OF_BUFFERED_OBJECT.pop();
        if (returnValue != null) {
            this.LAST_TOUCH_TIME = System.currentTimeMillis();
        }
        Object object = this.LOCK_OF_INPUT;
        synchronized (object) {
            this.LOCK_OF_INPUT.notify();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Object src) {
        if (src == null) {
            return;
        }
        int wait_count = 0;
        while (true) {
            this.LAST_TOUCH_TIME = System.currentTimeMillis();
            boolean success_flag = this.STACK_OF_BUFFERED_OBJECT.push(src);
            Object object = this.LOCK_OF_OUTPUT;
            synchronized (object) {
                try {
                    this.LOCK_OF_OUTPUT.notify();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (success_flag) {
                this.BUFFER_IS_MODIFIED = true;
                return;
            }
            object = this.LOCK_OF_INPUT;
            synchronized (object) {
                if (wait_count < 10) {
                    ++wait_count;
                    try {
                        this.LOCK_OF_INPUT.wait(5000L);
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        this.LOCK_OF_INPUT.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void log(String logStr) {
        if (log.isDebugEnabled()) {
            log.debug(logStr);
        }
    }

    protected abstract void flush() throws Exception;

    protected abstract Bufferable create(int var1, int var2) throws Exception;
}

