/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.util.NoSuchElementException;

public class StringLinkedList {
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private Entry lastReturned = null;

    public StringLinkedList() {
        this.header.next = this.header.previous = this.header;
    }

    public void clear() {
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public synchronized void rewind() {
        this.lastReturned = this.header;
    }

    public boolean hasNext() {
        return this.lastReturned.next != this.header;
    }

    public String next() {
        this.lastReturned = this.lastReturned.next;
        return this.lastReturned.element;
    }

    public void remove() {
        this.remove(this.lastReturned);
    }

    public boolean add(String obj) {
        this.addBefore(obj, this.header);
        return true;
    }

    public void addLast(String o) {
        this.addBefore(o, this.header);
    }

    public void addFirst(String o) {
        this.addBefore(o, this.header.next);
    }

    private void addBefore(String o, Entry e) {
        Entry newEntry;
        if (o == null) {
            return;
        }
        newEntry.previous.next = newEntry = new Entry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
    }

    public String removeFirst() {
        String first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    public String removeLast() {
        String last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    private void remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
    }

    public synchronized String toString() {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(512);
            buffer.setLength(0);
            buffer.append("[");
            this.rewind();
            while (this.hasNext()) {
                buffer.append(this.next());
                buffer.append(",");
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
            String string = buffer.toString();
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    private static class Entry {
        String element;
        Entry next;
        Entry previous;

        Entry(String element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }
}

