/*
 * Decompiled with CFR 0.152.
 */
package pluto.reporter;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.ReportMessageManager;
import pluto.util.StringConvertUtil;

public abstract class Reporter {
    private static final Logger log = LoggerFactory.getLogger(Reporter.class);
    protected static Reporter inter_reporter = null;

    protected Reporter() {
    }

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        String class_name = tmp.getProperty("report.class");
        inter_reporter = (Reporter)Class.forName(class_name).newInstance();
        inter_reporter.inner_init(tmp);
    }

    public static void report(String POST_ID, String Agent, String key, Throwable message) {
        String report_string = ReportMessageManager.getProperty(key);
        String report_result = inter_reporter.push(POST_ID, Agent, report_string, message);
        log.info(report_string + " report => " + report_result);
    }

    public static void report(String POST_ID, String Agent, String key, String message) {
        String report_string = ReportMessageManager.getProperty(key);
        String report_result = inter_reporter.push(POST_ID, Agent, report_string, message);
        log.info(report_string + " report => " + report_result);
    }

    public static void report(Properties prop, String message) {
        String report_result = inter_reporter.push(prop, message);
        log.info(message + " report => " + report_result);
    }

    public String push(String POST_ID, String Agent, String CODE, Throwable message) {
        return this.push(POST_ID, Agent, CODE, StringConvertUtil.exToString(message));
    }

    public abstract void inner_init(Properties var1) throws Exception;

    public abstract String push(String var1, String var2, String var3, String var4);

    public abstract String push(Properties var1, String var2);
}

