/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import com.humuson.tms.common.util.PushResponseConverToCodeUtil;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.mq.model.MgsPush;

public class MqResponseParseBean {
    private long deviceId;
    private String reqUid;
    private String custId;
    private CommonType sendType;
    private String listTableName;
    private String postId;
    private String returnCode;
    private String serverId;
    private boolean isSuccess = false;
    private boolean isDeliver = false;
    private final String AUTO_TABLE_PREFIX = "TMS_AUTO_SEND_LIST_";
    private final String CAMP_TABLE_PREFIX = "TMS_CAMP_SEND_LIST_";

    public MqResponseParseBean() {
    }

    public MqResponseParseBean(MgsPush.Response.ResponsePayload payload) throws Exception {
        this.parse(payload);
    }

    public void parse(MgsPush.Response.ResponsePayload payload) throws Exception {
        String[] splitId = payload.getId().split("&&");
        if (splitId.length <= 2 || splitId.length >= 5) {
            throw new Exception("MqResponseParseBean ResponsePayload.getId parse ERROR! length range out(splitId.length <= 2 || splitId.length >= 5) payload.getId() :" + payload.getId());
        }
        this.deviceId = Long.parseLong(splitId[1]);
        this.reqUid = splitId[2];
        if (this.reqUid.startsWith("AA")) {
            this.sendType = CommonType.AUTO;
            this.listTableName = "TMS_AUTO_SEND_LIST_" + this.reqUid.split("\\|")[1];
            this.postId = this.reqUid.split("\\^")[0].replace("AA", "");
            this.custId = this.reqUid.split("\\^")[1].split("\\|")[0];
        } else if (this.reqUid.startsWith("CC")) {
            this.sendType = CommonType.CAMP;
            this.listTableName = "TMS_CAMP_SEND_LIST_" + this.reqUid.substring(6, 8);
            this.postId = this.reqUid.substring(2, 15);
            if (splitId.length == 4) {
                this.custId = splitId[3];
            }
        } else if (this.reqUid.startsWith("CT") || this.reqUid.startsWith("AT")) {
            this.sendType = CommonType.TEST;
        }
        this.serverId = payload.getServerId();
        this.returnCode = PushResponseConverToCodeUtil.responseToResponseCode((String)String.valueOf(payload.getReturnCode().getNumber()));
        if (MgsPush.Response.ReturnCode.SUCCESSFUL.equals((Object)payload.getReturnCode()) || MgsPush.Response.ReturnCode.SENDING.equals((Object)payload.getReturnCode()) || MgsPush.Response.ReturnCode.SENDING_CCS.equals((Object)payload.getReturnCode())) {
            this.isSuccess = true;
        } else if (MgsPush.Response.ReturnCode.XMPP_DELIVER.equals((Object)payload.getReturnCode())) {
            this.isDeliver = true;
        }
    }

    public void clear() {
        this.deviceId = -1L;
        this.reqUid = null;
        this.custId = null;
        this.sendType = null;
        this.listTableName = null;
        this.postId = null;
        this.returnCode = null;
        this.isSuccess = false;
        this.isDeliver = false;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public String getReqUid() {
        return this.reqUid;
    }

    public String getCustId() {
        return this.custId;
    }

    public CommonType getSendType() {
        return this.sendType;
    }

    public String getListTableName() {
        return this.listTableName;
    }

    public String getPostId() {
        return this.postId;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getServerId() {
        return this.serverId;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public boolean isDeliver() {
        return this.isDeliver;
    }

    public String getAUTO_TABLE_PREFIX() {
        return this.AUTO_TABLE_PREFIX;
    }

    public String getCAMP_TABLE_PREFIX() {
        return this.CAMP_TABLE_PREFIX;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    public void setReqUid(String reqUid) {
        this.reqUid = reqUid;
    }

    public void setCustId(String custId) {
        this.custId = custId;
    }

    public void setSendType(CommonType sendType) {
        this.sendType = sendType;
    }

    public void setListTableName(String listTableName) {
        this.listTableName = listTableName;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public void setDeliver(boolean isDeliver) {
        this.isDeliver = isDeliver;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqResponseParseBean)) {
            return false;
        }
        MqResponseParseBean other = (MqResponseParseBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDeviceId() != other.getDeviceId()) {
            return false;
        }
        String this$reqUid = this.getReqUid();
        String other$reqUid = other.getReqUid();
        if (this$reqUid == null ? other$reqUid != null : !this$reqUid.equals(other$reqUid)) {
            return false;
        }
        String this$custId = this.getCustId();
        String other$custId = other.getCustId();
        if (this$custId == null ? other$custId != null : !this$custId.equals(other$custId)) {
            return false;
        }
        CommonType this$sendType = this.getSendType();
        CommonType other$sendType = other.getSendType();
        if (this$sendType == null ? other$sendType != null : !this$sendType.equals(other$sendType)) {
            return false;
        }
        String this$listTableName = this.getListTableName();
        String other$listTableName = other.getListTableName();
        if (this$listTableName == null ? other$listTableName != null : !this$listTableName.equals(other$listTableName)) {
            return false;
        }
        String this$postId = this.getPostId();
        String other$postId = other.getPostId();
        if (this$postId == null ? other$postId != null : !this$postId.equals(other$postId)) {
            return false;
        }
        String this$returnCode = this.getReturnCode();
        String other$returnCode = other.getReturnCode();
        if (this$returnCode == null ? other$returnCode != null : !this$returnCode.equals(other$returnCode)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.isDeliver() != other.isDeliver()) {
            return false;
        }
        String this$AUTO_TABLE_PREFIX = this.getAUTO_TABLE_PREFIX();
        String other$AUTO_TABLE_PREFIX = other.getAUTO_TABLE_PREFIX();
        if (this$AUTO_TABLE_PREFIX == null ? other$AUTO_TABLE_PREFIX != null : !this$AUTO_TABLE_PREFIX.equals(other$AUTO_TABLE_PREFIX)) {
            return false;
        }
        String this$CAMP_TABLE_PREFIX = this.getCAMP_TABLE_PREFIX();
        String other$CAMP_TABLE_PREFIX = other.getCAMP_TABLE_PREFIX();
        return !(this$CAMP_TABLE_PREFIX == null ? other$CAMP_TABLE_PREFIX != null : !this$CAMP_TABLE_PREFIX.equals(other$CAMP_TABLE_PREFIX));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqResponseParseBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $deviceId = this.getDeviceId();
        result = result * 59 + (int)($deviceId >>> 32 ^ $deviceId);
        String $reqUid = this.getReqUid();
        result = result * 59 + ($reqUid == null ? 0 : $reqUid.hashCode());
        String $custId = this.getCustId();
        result = result * 59 + ($custId == null ? 0 : $custId.hashCode());
        CommonType $sendType = this.getSendType();
        result = result * 59 + ($sendType == null ? 0 : $sendType.hashCode());
        String $listTableName = this.getListTableName();
        result = result * 59 + ($listTableName == null ? 0 : $listTableName.hashCode());
        String $postId = this.getPostId();
        result = result * 59 + ($postId == null ? 0 : $postId.hashCode());
        String $returnCode = this.getReturnCode();
        result = result * 59 + ($returnCode == null ? 0 : $returnCode.hashCode());
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 0 : $serverId.hashCode());
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isDeliver() ? 79 : 97);
        String $AUTO_TABLE_PREFIX = this.getAUTO_TABLE_PREFIX();
        result = result * 59 + ($AUTO_TABLE_PREFIX == null ? 0 : $AUTO_TABLE_PREFIX.hashCode());
        String $CAMP_TABLE_PREFIX = this.getCAMP_TABLE_PREFIX();
        result = result * 59 + ($CAMP_TABLE_PREFIX == null ? 0 : $CAMP_TABLE_PREFIX.hashCode());
        return result;
    }

    public String toString() {
        return "MqResponseParseBean(deviceId=" + this.getDeviceId() + ", reqUid=" + this.getReqUid() + ", custId=" + this.getCustId() + ", sendType=" + this.getSendType() + ", listTableName=" + this.getListTableName() + ", postId=" + this.getPostId() + ", returnCode=" + this.getReturnCode() + ", serverId=" + this.getServerId() + ", isSuccess=" + this.isSuccess() + ", isDeliver=" + this.isDeliver() + ", AUTO_TABLE_PREFIX=" + this.getAUTO_TABLE_PREFIX() + ", CAMP_TABLE_PREFIX=" + this.getCAMP_TABLE_PREFIX() + ")";
    }
}

