/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import com.google.protobuf.InvalidProtocolBufferException;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.mq.model.MgsPush;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.Composer;
import pluto.log.SmtpLogger;
import pluto.net.communicator.MqResponseParseBean;
import pluto.util.Cal;
import pluto.util.convert.DelimConvertor;

public class MQConsumer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MQConsumer.class);
    private ConnectionFactory factory = null;
    private Connection connection = null;
    private Session session = null;
    private Destination destination = null;
    private MessageConsumer consumer = null;
    private String brokerUrl = "";
    private String sendQueName = "";
    private String responseMQname = "";
    private String msgType = "";
    private Properties PROP = new Properties();
    protected Composer composer = null;
    protected StringBuffer TMP_BUFFER = new StringBuffer(256);
    private String engType;

    public MQConsumer(Properties prop) {
        this.composer = Composer.getComposerInstance();
        if (prop != null) {
            this.PROP = prop;
            this.brokerUrl = prop.getProperty("BROKER_URL");
            this.responseMQname = prop.getProperty("RESPONSE_MQ_NAME");
            this.engType = prop.getProperty("ENG_TYPE");
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            try {
                this.consumer = this.session.createConsumer(this.destination);
                message = null;
                resParseBean = new MqResponseParseBean();
                data = null;
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        block10: while (true) {
                            resParseBean.clear();
                            message = this.consumer.receive();
                            if (!(message instanceof BytesMessage)) continue;
                            byteMessage = (BytesMessage)message;
                            data = new byte[(int)byteMessage.getBodyLength()];
                            byteMessage.readBytes(data);
                            response = this.parseByteMessage(data);
                            i$ = response.getResPayloadList().iterator();
                            while (true) {
                                if (i$.hasNext()) ** break;
                                continue block10;
                                payload = (MgsPush.Response.ResponsePayload)i$.next();
                                try {
                                    resParseBean.parse(payload);
                                    this.loggingResponse(resParseBean);
                                }
                                catch (Exception e) {
                                    MQConsumer.log.error("ResponsePayload parse Error : {}", (Throwable)e);
                                }
                            }
                            break;
                        }
                    }
                    catch (InvalidProtocolBufferException parseException) {
                        MQConsumer.log.error("MgsPush parse error! Pass this data : {}, Error : {} ", data, (Object)parseException);
                    }
                    catch (JMSException jmsException) {
                        MQConsumer.log.error("JMSException consume receive error {}", (Throwable)jmsException);
                        continue;
                    }
                    break;
                }
            }
            catch (JMSException e) {
                MQConsumer.log.error("JMSException createConsumer Error  : {}", (Throwable)e);
                this.release();
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var9_12) {
            this.release();
            throw var9_12;
        }
    }

    public void init() {
        try {
            this.factory = new ActiveMQConnectionFactory(this.brokerUrl);
            this.connection = this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.destination = this.session.createQueue(this.responseMQname);
            log.debug("[MQ CONN SUCCESS] : " + this.responseMQname);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[MQ CONN fail] : {}", (Object)(this.responseMQname + " error " + e));
        }
    }

    public void release() {
        try {
            if (this.connection != null) {
                log.debug("connetion close ..." + this.responseMQname);
                this.connection.close();
            }
            if (this.session != null) {
                this.session.close();
                log.debug("session close ..." + this.responseMQname);
            }
        }
        catch (Exception e) {
            log.error("consumer resource close Error : {}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loggingResponse(MqResponseParseBean resParseBean) throws Exception {
        if (CommonType.TEST.equals((Object)resParseBean.getSendType())) {
            return;
        }
        Object object = this.composer.getLock();
        synchronized (object) {
            this.composer.setProperty("STYPE", resParseBean.getSendType().toString());
            this.composer.setProperty("SERVER_ID", resParseBean.getServerId());
            if (resParseBean.isSuccess()) {
                this.composer.setProperty("T_TYPE", "54");
                this.composer.setProperty("ETC_LOG", "Receive MQ PushResponse ACK");
            } else if (resParseBean.isDeliver()) {
                this.composer.setProperty("T_TYPE", "56");
                this.composer.setProperty("ETC_LOG", "Receive MQ Push UpStream");
            } else {
                this.composer.setProperty("T_TYPE", "55");
                this.composer.setProperty("ETC_LOG", "Receive MQ PushResponse NACK");
            }
            this.composer.setProperty("T_CODE", resParseBean.getReturnCode());
            this.composer.setProperty("POST_ID", resParseBean.getPostId());
            this.TMP_BUFFER.setLength(0);
            DelimConvertor.encodeToBuffer(this.TMP_BUFFER, resParseBean.getCustId());
            this.composer.setProperty("M_ID", this.TMP_BUFFER.toString());
            this.composer.setProperty("ROW_ID", "");
            this.composer.setProperty("STEP", "0");
            this.composer.setProperty("T_DATE", Cal.getDate());
            this.composer.setProperty("MX_RECORD", "");
            this.composer.setProperty("DELAY", String.valueOf("0"));
            this.composer.setProperty("TOKEN_ID", "");
            this.composer.setProperty("DOMAIN", "");
            this.composer.setProperty("WORKER", this.getName());
            this.composer.setProperty("LIST_TABLE", resParseBean.getListTableName());
            SmtpLogger.put(this.composer);
        }
    }

    public MgsPush.Response parseByteMessage(byte[] bytes) throws InvalidProtocolBufferException {
        return MgsPush.Response.parseFrom((byte[])bytes);
    }

    public static void main(String[] args) {
        Properties prop = new Properties();
        long reqtm = Long.parseLong("2016-07-21 17:19:39");
        long restm = Long.parseLong("2016-07-21 17:19:41");
    }
}

