/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.Name;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.util.Cal;

public class DomainFilterActor
extends Name
implements InfoActor {
    private static final Logger log = LoggerFactory.getLogger(DomainFilterActor.class);

    public DomainFilterActor() {
        this.setName("DomainFilterActor" + Cal.getSerialDate());
    }

    @Override
    public void execute(InfoBeans arg) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("[execute]...[start]");
        }
        Properties prop = arg.getArgs();
        String actFlag = prop.getProperty("ACTFLAG");
        String act_time = prop.getProperty("ACTTIME");
        String domain = prop.getProperty("DOMAIN");
        if (log.isDebugEnabled()) {
            log.debug("[ACTFLAG] :" + actFlag);
            log.debug("[ACTTIME]:" + act_time);
            log.debug("[DOMAIN]  :" + domain);
        }
        if (actFlag.equals("ADD")) {
            if (log.isDebugEnabled()) {
                log.debug("[ADD]");
            }
            this.addList(act_time, domain);
        } else if (actFlag.equals("DEL")) {
            if (log.isDebugEnabled()) {
                log.debug("[DELETE]");
            }
            this.delList(domain);
        } else if (actFlag.equals("USE")) {
            if (log.isDebugEnabled()) {
                log.debug("[USE DOMAIN FILTER]");
            }
            this.useList();
        } else if (actFlag.equals("NOUSE")) {
            if (log.isDebugEnabled()) {
                log.debug("[NO USE DOMAIN FILTER]");
            }
            this.noUseList();
        }
        prop.setProperty("RESULT", "act_end");
        if (log.isDebugEnabled()) {
            log.debug("[execute]...[end]");
        }
    }

    public void addList(String act_time, String domain) {
        MailSendDomainFilter.registeFilteringDomain(act_time, domain);
        String list_String = MailSendDomainFilter.getInfo();
        if (log.isDebugEnabled()) {
            log.debug("[FILTER_DOMAIN_LIST]...\n" + list_String);
            log.debug(MailSendDomainFilter.isFilterPresent() ? "[INIT_FLAG]:true" : "[INIT_FLAG]:false");
        }
    }

    public void delList(String domain) {
        MailSendDomainFilter.deRegisterFilteringDomain(domain);
        String list_String = MailSendDomainFilter.getInfo();
        if (log.isDebugEnabled()) {
            log.debug("[FILTER_DOMAIN_LIST]...\n" + list_String);
            log.debug(MailSendDomainFilter.isFilterPresent() ? "[INIT_FLAG]:true" : "[INIT_FLAG]:false");
        }
    }

    public void useList() {
        MailSendDomainFilter.setINIT_FLAG(true);
        String list_String = MailSendDomainFilter.getInfo();
        if (log.isDebugEnabled()) {
            log.debug("[FILTER_DOMAIN_LIST]...\n" + list_String);
            log.debug(MailSendDomainFilter.isFilterPresent() ? "[INIT_FLAG]:true" : "[INIT_FLAG]:false");
        }
    }

    public void noUseList() {
        MailSendDomainFilter.setINIT_FLAG(false);
        String list_String = MailSendDomainFilter.getInfo();
        if (log.isDebugEnabled()) {
            log.debug("[FILTER_DOMAIN_LIST]...\n" + list_String);
            log.debug(MailSendDomainFilter.isFilterPresent() ? "[INIT_FLAG]:true" : "[INIT_FLAG]:false");
        }
    }
}

