/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.BASE64DecodeOutputStream;
import pluto.io.BASE64EncodeOutputStream;
import pluto.lang.eMsLocale;
import pluto.net.SocketReaderAgent;
import pluto.net.communicator.CommandActor;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.net.communicator.SendLogFindActor;

public class CommunicationWorker
extends SocketReaderAgent
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CommunicationWorker.class);
    private static final int __CONNECTION_DELAY__ = 360000;
    private static byte[] KEY_HEADER = null;
    private static String KEY_HEADER_STRING = null;
    private static byte[] KEY_ENDING_POINT = null;
    private static byte[] KEY_NEWLINE = null;
    protected static Object __LOCK_OF_BUFFER__ = new Object();
    protected ByteArrayOutputStream __OUT_BUFFER__ = null;
    protected BASE64EncodeOutputStream __ENCODED_OUT_BUFFER__ = null;
    protected BASE64DecodeOutputStream __DECODED_OUT_BUFFER__ = null;
    ThreadGroup __REGIST_THREAD_GROUP__ = null;
    Socket __SOURCE_SOCKET__ = null;
    public static final String MESSAGE_OK = "OK";

    public CommunicationWorker(ThreadGroup group, String name, Socket mySocket) {
        super(true);
        this.setName(name);
        this.__REGIST_THREAD_GROUP__ = group;
        this.__SOURCE_SOCKET__ = mySocket;
        this.__OUT_BUFFER__ = new ByteArrayOutputStream(1024);
        this.__ENCODED_OUT_BUFFER__ = new BASE64EncodeOutputStream(this.__OUT_BUFFER__, 1024);
        this.__DECODED_OUT_BUFFER__ = new BASE64DecodeOutputStream(this.__OUT_BUFFER__, 1024);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void start() throws Exception {
        this.connect(this.__SOURCE_SOCKET__);
        this.setConnectionTimeout(360000);
        Thread inner_thread = new Thread(this.__REGIST_THREAD_GROUP__, this, this.getName());
        inner_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.work();
        }
        catch (Exception e) {
            log.error("CommunicationError", (Throwable)e);
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {}
            try {
                super.unregist();
            }
            catch (Exception exception) {}
        }
    }

    public void work() throws Exception {
        log.debug("Connection in...");
        super.send(MESSAGE_OK);
        String message = null;
        message = super.receive();
        log.debug("receive=>".concat(message));
        if (message.startsWith("exec ")) {
            log.info("COMMAND TYPE");
            this.exec_external(message.substring(5));
            return;
        }
        log.debug("INFO TYPE");
        InfoBeans target = new InfoBeans();
        while (true) {
            if ((message = super.receive()) == null) {
                log.debug("receive null break....");
                break;
            }
            if (message.length() < 1) continue;
            if (message.equals(".")) break;
            if (!message.startsWith(KEY_HEADER_STRING)) continue;
            String key = message.substring(KEY_HEADER_STRING.length());
            this.__DECODED_OUT_BUFFER__.flush();
            this.__OUT_BUFFER__.reset();
            while ((message = super.receive()) != null && message.length() >= 1) {
                this.__DECODED_OUT_BUFFER__.write(message.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
            }
            this.__DECODED_OUT_BUFFER__.flush();
            this.__OUT_BUFFER__.flush();
            target.setProperty(key, this.__OUT_BUFFER__.toString(eMsLocale.CHAR_SET));
        }
        if (target.getHandler() == null) {
            log.error("INPUT HANDLER IS NULL");
            target.setProperty("ERROR", "INPUT HANDLER IS NULL");
        } else {
            log.debug("create Actor Instance => ".concat(target.getHandler()));
            InfoActor actor = null;
            try {
                actor = (InfoActor)Class.forName(target.getHandler()).newInstance();
                log.debug("execute Actor's execute method");
                if (target.getHandler().equals("pluto.net.communicator.SendLogFindActor")) {
                    SendLogFindActor logGreper = (SendLogFindActor)actor;
                    logGreper.setThreadName(this.getName());
                    super.send("@@" + this.getName());
                    ++SendLogFindActor.NOW_ACT_CNT;
                    logGreper.execute(target, this.SMTP_BINARY_OUTSTREAM);
                    --SendLogFindActor.NOW_ACT_CNT;
                } else {
                    actor.execute(target);
                }
                log.debug("execute Actor's execute method end...");
            }
            catch (ClassNotFoundException e) {
                log.error("UNKNOWN HANDLER ", (Object)target.getHandler());
                target.setProperty("ERROR", "UNKNOWN HANDLER=>" + target.getHandler());
            }
        }
        String body = null;
        this.__ENCODED_OUT_BUFFER__.flush();
        this.__OUT_BUFFER__.reset();
        Enumeration<?> eNum = target.propertyNames();
        while (eNum.hasMoreElements()) {
            String key = (String)eNum.nextElement();
            this.__OUT_BUFFER__.write(KEY_HEADER);
            this.__OUT_BUFFER__.write(key.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
            this.__OUT_BUFFER__.write(KEY_NEWLINE);
            this.__ENCODED_OUT_BUFFER__.write(target.getProperty(key).getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
            this.__ENCODED_OUT_BUFFER__.flush();
            this.__OUT_BUFFER__.write(KEY_NEWLINE);
            this.__OUT_BUFFER__.write(KEY_NEWLINE);
            this.__OUT_BUFFER__.flush();
        }
        this.__OUT_BUFFER__.write(KEY_NEWLINE);
        this.__OUT_BUFFER__.write(KEY_ENDING_POINT);
        this.__OUT_BUFFER__.flush();
        body = this.__OUT_BUFFER__.toString();
        super.send(body);
    }

    protected void exec_external(String classname) throws Exception {
        CommandActor actor = (CommandActor)Class.forName(classname).newInstance();
        String message = actor.exec();
        super.send(message);
        super.send(".");
    }

    static {
        KEY_HEADER_STRING = "##";
        KEY_HEADER = KEY_HEADER_STRING.getBytes();
        KEY_NEWLINE = "\r\n".getBytes();
        KEY_ENDING_POINT = ".".getBytes();
    }
}

