/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.mail.mx.DNS;
import pluto.mail.mx.DNSInputStream;
import pluto.mail.mx.DiskCacheController;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.LookupUtil;
import pluto.mail.mx.MXResultSorter;
import pluto.mail.mx.MXSearchResult;
import pluto.mail.mx.UDPMXLookup;
import pluto.mail.mx.exception.CanonicalNameFoundException;
import pluto.mail.mx.exception.FormatErrorException;
import pluto.mail.mx.exception.LookupUnknownException;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.mail.mx.exception.NotImplementedException;
import pluto.mail.mx.exception.ResultArrayContainEOFException;
import pluto.mail.mx.exception.ServerFailureException;
import pluto.mail.mx.exception.ServerRefusedException;
import pluto.mail.mx.exception.TooManyMissMatchQueryIDException;
import pluto.net.NetworkMonitorable;
import pluto.net.SocketAgentMonitor;
import pluto.util.FIFOBuffer;
import pluto.util.eMsStringTokenizer;

public abstract class MXLookup
implements NetworkMonitorable {
    private static final Logger log = LoggerFactory.getLogger(MXLookup.class);
    protected String CONNECT_HOST = null;
    protected boolean IN_COMM = false;
    protected int TIME_OUT = 0;
    protected long COMM_START_TIME = 0L;
    public static final int DEFAULT_TIME_OUT = 10000;
    private static int globalID = 0;
    static ByteArrayOutputStream byteArrayOut = null;
    static DataOutputStream dataOut = null;
    static eMsStringTokenizer token = null;
    private static final int MAX_CONTAIN_SIZE = 10;
    private static FIFOBuffer INNER_CONTAINER = null;
    String domain = null;
    public MXResultSorter sorter = new MXResultSorter();

    static final synchronized byte[] getQuery(String queryHost, int queryID, int type) throws IOException {
        dataOut.flush();
        byteArrayOut.flush();
        byteArrayOut.reset();
        try {
            dataOut.writeShort(queryID);
            dataOut.writeShort(256);
            dataOut.writeShort(1);
            dataOut.writeShort(0);
            dataOut.writeShort(0);
            dataOut.writeShort(0);
            token.parse(queryHost, ".");
            while (token.hasMoreTokens()) {
                String label = token.nextToken();
                dataOut.writeByte(label.length());
                dataOut.writeBytes(label);
            }
            dataOut.writeByte(0);
            dataOut.writeShort(type);
            dataOut.writeShort(255);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        byte[] query = byteArrayOut.toByteArray();
        return query;
    }

    static final MXLookup getInstance() {
        Object tmpValue = INNER_CONTAINER.pop();
        MXLookup returnValue = null;
        if (tmpValue == null) {
            MXLookup.log("create new MXLookup");
            returnValue = new UDPMXLookup();
        } else {
            MXLookup.log("pop up old MXLookup");
            returnValue = (MXLookup)tmpValue;
        }
        return returnValue;
    }

    public static void recycleInstance(MXLookup tmp) {
        if (tmp == null) {
            return;
        }
        if (INNER_CONTAINER.push(tmp)) {
            tmp.reset();
        } else {
            tmp.destroy();
        }
    }

    public static void log(String log) {
        LookupCacheManager.log(log);
    }

    public static void log(Throwable log) {
        LookupCacheManager.log(log);
    }

    MXLookup() {
        SocketAgentMonitor.registSocketAgent(this);
        this.sorter = new MXResultSorter();
    }

    void set(String d) {
        this.domain = d;
    }

    final void reset() {
        this.domain = null;
        this.sorter.clear();
    }

    final void destroy() {
        this.domain = null;
        this.sorter.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refesh(MXSearchResult result) throws Exception {
        String sDomain = result.TARGET_DOMAIN;
        switch (DiskCacheController.checkCacheResult(result)) {
            case 1: {
                if (log.isDebugEnabled()) {
                    MXLookup.log(sDomain + " is read from cache");
                }
                return;
            }
            case 0: 
            case 2: {
                if (!log.isDebugEnabled()) break;
                MXLookup.log(sDomain + " is not in cache or expire");
                break;
            }
        }
        eMsByteArrayOutputStream buffer = null;
        try {
            buffer = eMsByteArrayOutputStream.getInstance();
            Throwable ex = null;
            for (int i = 0; i < LookupCacheManager.DNS_RESOLVER_LIST.length; ++i) {
                try {
                    this.refreshToTargetDNS(buffer, LookupCacheManager.DNS_RESOLVER_LIST[i], result);
                    ex = null;
                    break;
                }
                catch (Throwable thw) {
                    ex = thw;
                    continue;
                }
            }
            if (ex != null) {
                result.setError(-1, ex);
            }
        }
        finally {
            eMsByteArrayOutputStream.recycleInstance(buffer);
            buffer = null;
        }
    }

    public abstract void close();

    protected abstract int getDNSResult(InetAddress var1, byte[] var2, eMsByteArrayOutputStream var3) throws Throwable;

    final void refreshQueryTargetType(eMsByteArrayOutputStream buffer, InetAddress address, String domain, int type, MXSearchResult result) throws Throwable {
        int responseLength = -1;
        boolean bSearchResult = false;
        int iTryCount = 0;
        do {
            int query_id = ++globalID % 65536;
            byte[] queryNS = MXLookup.getQuery(domain, query_id, type);
            responseLength = this.getDNSResult(address, queryNS, buffer);
            bSearchResult = MXLookup.receiveResponse(query_id, this.sorter, buffer, responseLength, result);
            if (++iTryCount <= 3) continue;
            throw new TooManyMissMatchQueryIDException(domain + ":Too Many Miss QueryID");
        } while (bSearchResult);
    }

    final void refreshToTargetDNS(eMsByteArrayOutputStream buffer, InetAddress address, MXSearchResult result) throws Throwable {
        int responseLength = -1;
        try {
            this.refreshQueryTargetType(buffer, address, result.TARGET_DOMAIN, 15, result);
            if (this.sorter.getMXDomainCount() == 0) {
                this.sorter.addMailExchanger(result.TARGET_DOMAIN, 10);
            }
            do {
                this.sorter.clearCanonical();
                this.refreshARecords(buffer, address, result);
            } while (this.sorter.hasCanonical());
            this.sorter.calculateMxCounts();
        }
        catch (Throwable thw) {
            throw thw;
        }
        finally {
            this.close();
        }
        result.init(this.sorter.minMxCount + this.sorter.etcMxCount);
        this.sorter.setResult(result);
        DiskCacheController.storeResultToCache(result);
    }

    final void refreshARecords(eMsByteArrayOutputStream buffer, InetAddress address, MXSearchResult result) throws Throwable {
        MXResultSorter.Entry header = this.sorter.header;
        MXResultSorter.Entry nextEntry = header.next;
        while (nextEntry != header) {
            String domain = nextEntry.domain;
            if (nextEntry.preference >= 0) {
                try {
                    int iIP = LookupUtil.getPureDigitIP(domain);
                    if (iIP != 0) {
                        this.sorter.addAddress(domain, iIP);
                    } else {
                        this.refreshQueryTargetType(buffer, address, domain, 1, result);
                    }
                }
                catch (CanonicalNameFoundException e) {
                    nextEntry = this.sorter.header.next;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            nextEntry = nextEntry.next;
        }
    }

    static boolean receiveResponse(int query_id, MXResultSorter sorter, eMsByteArrayOutputStream buffer, int length, MXSearchResult result) throws Throwable {
        byte[] rawBuffer = buffer.getRawByteArray();
        DNSInputStream dnsIn = new DNSInputStream(rawBuffer, 0, length);
        int id = dnsIn.readShort();
        if (id != query_id) {
            return true;
        }
        int flags = dnsIn.readShort();
        MXLookup.decodeFlags(flags, result);
        int numQueries = dnsIn.readShort();
        int numAnswers = dnsIn.readShort();
        int numAuthorities = dnsIn.readShort();
        int numAdditional = dnsIn.readShort();
        while (numQueries-- > 0) {
            String queryName = dnsIn.readDomainName();
            int queryType = dnsIn.readShort();
            int queryClass = dnsIn.readShort();
        }
        try {
            while (numAnswers-- > 0) {
                MXLookup.readRR(sorter, dnsIn);
            }
            while (numAuthorities-- > 0) {
                MXLookup.readRR(sorter, dnsIn);
            }
            while (numAdditional-- > 0) {
                MXLookup.readRR(sorter, dnsIn);
            }
        }
        catch (EOFException ex) {
            if (log.isDebugEnabled()) {
                MXLookup.log(ex);
            }
            throw new ResultArrayContainEOFException(result.TARGET_DOMAIN);
        }
        return false;
    }

    static void readRR(MXResultSorter sorter, DNSInputStream dnsIn) throws IOException {
        String rrName = dnsIn.readDomainName();
        int rrType = dnsIn.readShort();
        int rrClass = dnsIn.readShort();
        long rrTTL = dnsIn.readInt();
        int rrDataLen = dnsIn.readShort();
        int iMaxDataRange = dnsIn.getPosition() + rrDataLen;
        switch (rrType) {
            case 1: {
                sorter.putAddress(rrName, dnsIn);
                break;
            }
            case 2: {
                String domain = dnsIn.readDomainName();
                sorter.addNameServer(domain);
                break;
            }
            case 5: {
                String domain = dnsIn.readDomainName();
                sorter.addCanonicalName(rrName, domain);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                String domain = dnsIn.readDomainName();
                break;
            }
            case 6: {
                sorter.putStartOfAuth(dnsIn);
                break;
            }
            case 10: {
                byte[] data = new byte[rrDataLen];
                dnsIn.read(data);
                String text = new String(data, "latin1");
                break;
            }
            case 11: {
                int[] ipAddress = new int[4];
                for (int i = 0; i < 4; ++i) {
                    ipAddress[i] = dnsIn.readByte();
                }
                int protocol = dnsIn.readByte();
                byte[] data = new byte[rrDataLen - 5];
                dnsIn.read(data);
                break;
            }
            case 13: {
                String cpu = dnsIn.readString();
                String os = dnsIn.readString();
                break;
            }
            case 14: {
                String rBox = dnsIn.readDomainName();
                String eBox = dnsIn.readDomainName();
                break;
            }
            case 15: {
                sorter.putMailExchanger(dnsIn);
                break;
            }
            case 16: {
                do {
                    String s = dnsIn.readString();
                } while (iMaxDataRange > dnsIn.getPosition());
                break;
            }
            default: {
                MXLookup.log(rrName + " receive unknown:" + rrType);
                dnsIn.plusPosition(rrDataLen);
            }
        }
    }

    static void decodeFlags(int flags, MXSearchResult result) throws Exception {
        boolean isResponse;
        boolean bl = isResponse = (flags >> 15 & 1) != 0;
        if (!isResponse) {
            throw new IOException("Response flag not set");
        }
        int opcode = flags >> 11 & 0xF;
        boolean authoritative = (flags >> 10 & 1) != 0;
        boolean truncated = (flags >> 9 & 1) != 0;
        boolean recurseRequest = (flags >> 8 & 1) != 0;
        boolean recursive = (flags >> 7 & 1) != 0;
        int code = flags >> 0 & 0xF;
        if (code != 0) {
            switch (code) {
                case 1: {
                    throw new FormatErrorException(result.TARGET_DOMAIN + ":" + DNS.codeName(code));
                }
                case 2: {
                    throw new ServerFailureException(result.TARGET_DOMAIN + ":" + DNS.codeName(code));
                }
                case 3: {
                    throw new NameNotKnownException(result.TARGET_DOMAIN + ":" + DNS.codeName(code));
                }
                case 4: {
                    throw new NotImplementedException(result.TARGET_DOMAIN + ":" + DNS.codeName(code));
                }
                case 5: {
                    throw new ServerRefusedException(result.TARGET_DOMAIN + ":" + DNS.codeName(code));
                }
            }
            throw new LookupUnknownException(result.TARGET_DOMAIN + ":" + DNS.codeName(code));
        }
    }

    @Override
    public String getConnectHost() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isIdle() {
        return this.IN_COMM && System.currentTimeMillis() - this.COMM_START_TIME > (long)this.TIME_OUT;
    }

    @Override
    public abstract void killSession();

    protected abstract void setConnectionTimeout(int var1);

    static {
        byteArrayOut = new ByteArrayOutputStream();
        dataOut = new DataOutputStream(byteArrayOut);
        token = new eMsStringTokenizer();
        INNER_CONTAINER = new FIFOBuffer(10);
    }
}

