/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupUtil {
    private static final Logger log = LoggerFactory.getLogger(LookupUtil.class);
    private static final char CHAR_0 = '0';
    private static final char CHAR_9 = '9';
    private static final char CHAR_DOT = '.';

    public static int getPureDigitIP(String ip) {
        int dotCnt = 0;
        for (int i = 0; i < ip.length(); ++i) {
            char tmpChar = ip.charAt(i);
            if (tmpChar == '.') {
                ++dotCnt;
                continue;
            }
            if (tmpChar >= '0' && tmpChar <= '9') continue;
            return 0;
        }
        if (dotCnt != 3) {
            return 0;
        }
        return LookupUtil.getIntArray(ip);
    }

    public static int getIntIPToInetInt(int i1, int i2, int i3, int i4) {
        int iIP = 0;
        iIP += (i4 & 0xFF) << 24;
        iIP += (i3 & 0xFF) << 16;
        iIP += (i2 & 0xFF) << 8;
        return iIP += (i1 & 0xFF) << 0;
    }

    public static byte[] getIntToInetByteArray(int iIP) {
        byte[] returnValue = new byte[]{(byte)(iIP >>> 0), (byte)(iIP >>> 8), (byte)(iIP >>> 16), (byte)(iIP >>> 24)};
        return returnValue;
    }

    public static String getIntIPToString(int iIP) {
        return (iIP >>> 0 & 0xFF) + "." + (iIP >>> 8 & 0xFF) + "." + (iIP >>> 16 & 0xFF) + "." + (iIP >>> 24 & 0xFF);
    }

    public static final InetAddress getInetAddress(int iIP) throws UnknownHostException {
        byte[] returnValue = LookupUtil.getIntToInetByteArray(iIP);
        return returnValue == null ? null : InetAddress.getByAddress(returnValue);
    }

    public static long getLong(byte[] b, boolean high) {
        long returnValue = 0L;
        if (high) {
            returnValue += ((long)b[3] & 0xFFL) << 0;
            returnValue += ((long)b[2] & 0xFFL) << 8;
            returnValue += ((long)b[1] & 0xFFL) << 16;
            returnValue += ((long)b[0] & 0xFFL) << 24;
        } else {
            returnValue += ((long)b[3] & 0xFFL) << 32;
            returnValue += ((long)b[2] & 0xFFL) << 40;
            returnValue += ((long)b[1] & 0xFFL) << 48;
            returnValue += ((long)b[0] & 0xFFL) << 56;
        }
        return returnValue;
    }

    public static void putLong(long val, byte[] b, boolean high) {
        if (high) {
            b[3] = (byte)(val >>> 0);
            b[2] = (byte)(val >>> 8);
            b[1] = (byte)(val >>> 16);
            b[0] = (byte)(val >>> 24);
        } else {
            b[3] = (byte)(val >>> 32);
            b[2] = (byte)(val >>> 40);
            b[1] = (byte)(val >>> 48);
            b[0] = (byte)(val >>> 56);
        }
    }

    public static final InetAddress getInetAddress(String addr) throws UnknownHostException {
        byte[] returnValue = LookupUtil.getByteArray(addr);
        return returnValue == null ? null : InetAddress.getByAddress(returnValue);
    }

    public static final byte[] getByteArray(String addr) {
        int idx2;
        byte[] returnValue = new byte[4];
        int idx1 = addr.indexOf(".");
        if (idx1 < 0) {
            log.info("getRawAddr() FIND FIRST INDEX FAIL : {}", (Object)addr);
            return null;
        }
        returnValue[0] = (byte)(Integer.parseInt(addr.substring(0, idx1)) & 0xFF);
        if ((idx2 = addr.indexOf(".", ++idx1)) < 0) {
            log.info("getRawAddr() FIND SECOND INDEX FAIL :{}", (Object)addr);
            return null;
        }
        returnValue[1] = (byte)(Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);
        idx1 = idx2 + 1;
        if ((idx2 = addr.indexOf(46, idx1)) < 0) {
            log.info("NetAddress", (Object)"getRawAddr() FIND THIRD INDEX FAIL", (Object)addr);
            return null;
        }
        returnValue[2] = (byte)(Integer.parseInt(addr.substring(idx1, idx2)) & 0xFF);
        returnValue[3] = (byte)(Integer.parseInt(addr.substring(idx2 + 1)) & 0xFF);
        return returnValue;
    }

    private static final int getIntArray(String addr) {
        int idx1 = addr.indexOf(".");
        int i1 = Integer.parseInt(addr.substring(0, idx1));
        int idx2 = addr.indexOf(".", ++idx1);
        int i2 = Integer.parseInt(addr.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = addr.indexOf(".", idx1);
        int i3 = Integer.parseInt(addr.substring(idx1, idx2));
        int i4 = Integer.parseInt(addr.substring(idx2 + 1));
        return LookupUtil.getIntIPToInetInt(i1, i2, i3, i4);
    }

    public static String toDottedQuad(byte[] addr) {
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF);
    }

    public static void main(String[] args) throws Exception {
        int a = 0;
        log.debug(LookupUtil.toDottedQuad(LookupUtil.getIntToInetByteArray(a)));
    }
}

