/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.mail.DomainFullException;
import pluto.mail.MultiRcptInfo;

public class MultiRcptDomainGroupingManager
extends Hashtable {
    private static final Logger log = LoggerFactory.getLogger(MultiRcptDomainGroupingManager.class);
    private static Hashtable __INNER_SINGLE_INFORM__ = null;
    private static Hashtable __INNER_MULTI_INFORM__ = null;
    private static int __CONTAIN_LIMIT_SIZE__ = 1000;
    private static int __SINGLE_DEFAULT_SIZE__ = 10;
    private static int __MULTI_DEFAULT_SIZE__ = 20;

    public static synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        __INNER_SINGLE_INFORM__ = new Hashtable();
        __INNER_MULTI_INFORM__ = new Hashtable();
        Enumeration<?> a = prop.propertyNames();
        while (a.hasMoreElements()) {
            String key = a.nextElement().toString();
            String value = prop.getProperty(key);
            try {
                if (key.startsWith("s.")) {
                    __INNER_SINGLE_INFORM__.put(key.substring(2), Integer.valueOf(value));
                    continue;
                }
                if (!key.startsWith("m.")) continue;
                __INNER_MULTI_INFORM__.put(key.substring(2), Integer.valueOf(value));
            }
            catch (Exception e) {
                log.error("DOMAIN KEY SETTING ERROR", (Throwable)e);
            }
        }
        __CONTAIN_LIMIT_SIZE__ = Integer.parseInt(prop.getProperty("contain.limit", "100"));
        __SINGLE_DEFAULT_SIZE__ = Integer.parseInt(prop.getProperty("s.default", "10"));
        __MULTI_DEFAULT_SIZE__ = Integer.parseInt(prop.getProperty("m.default", "10"));
        log.error("SINGLE SETTING", (Object)__INNER_SINGLE_INFORM__.toString());
        log.error("MULTI SETTING", (Object)__INNER_MULTI_INFORM__.toString());
    }

    public static final int getSingleSize(String domain) {
        if (domain == null) {
            return -1;
        }
        Integer ReturnValue = (Integer)__INNER_SINGLE_INFORM__.get(domain);
        if (ReturnValue != null) {
            return ReturnValue;
        }
        return __SINGLE_DEFAULT_SIZE__;
    }

    public static final int getMultipleSize(String domain) {
        if (domain == null) {
            return -1;
        }
        Integer ReturnValue = (Integer)__INNER_MULTI_INFORM__.get(domain);
        if (ReturnValue != null) {
            return ReturnValue;
        }
        return __MULTI_DEFAULT_SIZE__;
    }

    public MultiRcptDomainGroupingManager() {
        super(__CONTAIN_LIMIT_SIZE__);
    }

    public synchronized MultiRcptInfo addSingleRcptElement(String __RCPT_INFO__, String __TARGET_DOMAIN__) throws DomainFullException {
        int size = MultiRcptDomainGroupingManager.getSingleSize(__TARGET_DOMAIN__);
        if (size < -1) {
            return null;
        }
        return this.addElement(__RCPT_INFO__, __TARGET_DOMAIN__, size);
    }

    public synchronized MultiRcptInfo addSingleRcptElement(String __RCPT_INFO__, String __TARGET_DOMAIN__, int size) throws DomainFullException {
        if (size < -1) {
            return null;
        }
        return this.addElement(__RCPT_INFO__, __TARGET_DOMAIN__, size);
    }

    public synchronized MultiRcptInfo addMultipleRcptElement(String __RCPT_INFO__, String __TARGET_DOMAIN__) throws DomainFullException {
        int size = MultiRcptDomainGroupingManager.getMultipleSize(__TARGET_DOMAIN__);
        if (size < -1) {
            return null;
        }
        return this.addElement(__RCPT_INFO__, __TARGET_DOMAIN__, size);
    }

    private MultiRcptInfo addElement(String __RCPT_INFO__, String __TARGET_DOMAIN__, int size) throws DomainFullException {
        MultiRcptInfo __TARGET_EMAIL_LIST__ = (MultiRcptInfo)this.get(__TARGET_DOMAIN__);
        if (__TARGET_EMAIL_LIST__ == null) {
            if (super.size() > __CONTAIN_LIMIT_SIZE__) {
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                MultiRcptInfo dummy = null;
                if (log.isDebugEnabled()) {
                    log.debug("EMPTY INFO SEARCH START");
                }
                Enumeration myEnum = super.elements();
                while (myEnum.hasMoreElements()) {
                    dummy = (MultiRcptInfo)myEnum.nextElement();
                    if (dummy.getSize() != 0) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("BINGO:" + dummy.getDomain());
                    }
                    this.remove(dummy.getDomain());
                    dummy.reset(__TARGET_DOMAIN__, size);
                    dummy.addElement(__RCPT_INFO__);
                    this.put(dummy.getDomain(), dummy);
                    if (log.isDebugEnabled()) {
                        log.debug("CHANGE TO:" + dummy.getDomain());
                    }
                    return null;
                }
                throw new DomainFullException();
            }
            __TARGET_EMAIL_LIST__ = new MultiRcptInfo(__TARGET_DOMAIN__, size);
            __TARGET_EMAIL_LIST__.addElement(__RCPT_INFO__);
            this.put(__TARGET_EMAIL_LIST__.getDomain(), __TARGET_EMAIL_LIST__);
        } else if (__TARGET_EMAIL_LIST__.addElement(__RCPT_INFO__)) {
            return __TARGET_EMAIL_LIST__;
        }
        return null;
    }
}

