/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.DNS.Lookup;
import pluto.DNS.Name;
import pluto.DNS.TextParseException;
import pluto.lang.eMsLocale;
import pluto.mail.DNSGroupResolver;
import pluto.mail.DNSSearchFailException;
import pluto.mail.DNSSearchResult;
import pluto.mail.DNSSerarchResultZeroException;
import pluto.mail.DomainNotFoundException;
import pluto.mail.LookupContainer;
import pluto.mail.ResolverCreationException;
import pluto.util.Cal;
import pluto.util.PlutoLinkedList;

public class DNSList
extends pluto.lang.Name {
    private static final Logger log = LoggerFactory.getLogger(DNSList.class);
    private String TARGET_DOMAIN = null;
    public static final int MX_REFERENCE_MAX_SIZE = 4;
    private boolean PERMANENT_ERROR_FLAG = false;
    private boolean error = false;
    private Throwable error_msg = null;
    private int INDEX_OF_FIRST_REFERENCE_SEQUENCE = 0;
    private DNSSearchResult SERVER_LIST = null;
    private long MX_REFRESH_TIME = 0L;
    private long A_REFRESH_TIME = 0L;
    private LinkedList MX_LIST = null;
    private Lookup SEARCH_LOOKUP = null;

    protected DNSList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSList(String domain) {
        super.setName("DNSList-" + domain);
        this.log(super.getName() + " create");
        if (log.isDebugEnabled()) {
            log.debug("DNSList", (Object)"Start create Instance");
        }
        this.MX_REFRESH_TIME = -1L;
        this.A_REFRESH_TIME = -1L;
        this.MX_LIST = new LinkedList();
        this.TARGET_DOMAIN = domain;
        try {
            this.SEARCH_LOOKUP = new Lookup(Name.fromString(domain), 15, 1);
            this.PERMANENT_ERROR_FLAG = false;
        }
        catch (TextParseException te) {
            this.PERMANENT_ERROR_FLAG = true;
            this.error_msg = new DomainNotFoundException(te);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("DNSList", (Object)"pass Create Lookup Instance");
        }
        StringBuffer tmpBuffer = null;
        try {
            tmpBuffer = new StringBuffer(128);
            this.refreshMXRecored(tmpBuffer);
        }
        finally {
            tmpBuffer = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("DNSList", (Object)"Start create Instance ... [OK]");
        }
    }

    public synchronized String getList(int AGENT_INDEX, int SERVER_INDEX) {
        if (this.SERVER_LIST.size() < SERVER_INDEX) {
            return null;
        }
        int TARGET_INDEX = 0;
        if (SERVER_INDEX > this.INDEX_OF_FIRST_REFERENCE_SEQUENCE) {
            if (log.isDebugEnabled()) {
                log.debug("DNSList", (Object)("TARGET direct IDX:" + String.valueOf(SERVER_INDEX - 1)));
            }
            TARGET_INDEX = SERVER_INDEX - 1;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("DNSList", (Object)("TARGET rotate IDX:" + String.valueOf((AGENT_INDEX + SERVER_INDEX) % this.INDEX_OF_FIRST_REFERENCE_SEQUENCE)));
            }
            TARGET_INDEX = (AGENT_INDEX + SERVER_INDEX) % this.INDEX_OF_FIRST_REFERENCE_SEQUENCE;
        }
        TARGET_INDEX = TARGET_INDEX < this.SERVER_LIST.size() ? TARGET_INDEX : this.SERVER_LIST.size() - 1;
        TARGET_INDEX = TARGET_INDEX < 0 ? 0 : TARGET_INDEX;
        return this.SERVER_LIST.get(TARGET_INDEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshMXRecored(StringBuffer TMP_BUFFER) {
        if (log.isDebugEnabled()) {
            log.debug("DNSList", (Object)("MX REFESH TIME:" + Cal.getDate(this.MX_REFRESH_TIME)));
        }
        if (this.MX_REFRESH_TIME + LookupContainer.MX_REFRESH_CYCLE > System.currentTimeMillis()) {
            if (log.isDebugEnabled()) {
                log.debug("DNSList", (Object)"REFESH SKIP");
            }
            return;
        }
        DNSGroupResolver __RESOLVE_SERVERS = null;
        PlutoLinkedList answers = null;
        int answer_result = -1;
        String answer_msg = null;
        try {
            __RESOLVE_SERVERS = LookupContainer.getInstance();
            if (__RESOLVE_SERVERS == null) {
                log.error("DNSList", (Object)"getting DNS Resolver error");
                this.setMXList(new ResolverCreationException("Resover Creation error"));
                return;
            }
            TMP_BUFFER.setLength(0);
            answer_result = __RESOLVE_SERVERS.process(this.SEARCH_LOOKUP, TMP_BUFFER);
            if (answer_result == 0) {
                answers = this.SEARCH_LOOKUP.getResultMxList();
            } else {
                answer_msg = this.SEARCH_LOOKUP.getErrorString();
            }
        }
        catch (Throwable thw) {
            this.log(thw);
            if (this.MX_REFRESH_TIME > 0L) {
                this.MX_REFRESH_TIME = System.currentTimeMillis();
            } else {
                this.setMXList(new DNSSearchFailException(thw));
            }
            return;
        }
        finally {
            LookupContainer.recycleInstance(__RESOLVE_SERVERS);
        }
        switch (answer_result) {
            case 0: {
                this.setMXList(answers);
                break;
            }
            case 3: {
                if (log.isDebugEnabled()) {
                    log.info("LokupContainer", (Object)("HOST_NOT_FOUND:" + answer_msg));
                }
                this.setMXList(new DomainNotFoundException(this.TARGET_DOMAIN + ":" + answer_msg));
                break;
            }
            case 4: {
                if (log.isDebugEnabled()) {
                    log.info("LookupContainer", (Object)("TYPE_NOT_FOUND:" + answer_msg));
                }
                if (eMsLocale.NO_MX_RECORED_REJECT_FLAG) {
                    this.setMXList(new DomainNotFoundException(this.TARGET_DOMAIN + ":HAS NO MX RECORD"));
                    break;
                }
                answers = new PlutoLinkedList();
                answers.add("10 " + this.TARGET_DOMAIN);
                this.setMXList(answers);
                break;
            }
            default: {
                if (this.MX_REFRESH_TIME > 0L) {
                    this.MX_REFRESH_TIME = System.currentTimeMillis();
                } else {
                    this.setMXList(new DNSSearchFailException(this.TARGET_DOMAIN + ":" + answer_msg));
                }
                return;
            }
        }
        this.MX_REFRESH_TIME = System.currentTimeMillis();
        this.A_REFRESH_TIME = -1L;
        this.refreshARecord(TMP_BUFFER);
    }

    void refreshARecord(StringBuffer TMP_BUFFER) {
        if (log.isDebugEnabled()) {
            log.debug("DNSList", (Object)("A REFESH TIME:" + Cal.getDate(this.A_REFRESH_TIME)));
        }
        if (this.A_REFRESH_TIME + LookupContainer.A_REFRESH_CYCLE > System.currentTimeMillis()) {
            if (log.isDebugEnabled()) {
                log.debug("DNSList", (Object)"A RECORD REFESH SKIP");
            }
            return;
        }
        this.setAList(TMP_BUFFER);
        this.A_REFRESH_TIME = System.currentTimeMillis();
    }

    void setMXList(Object __SERVER_LIST) {
        PlutoLinkedList listServers = null;
        String sServer = null;
        if (__SERVER_LIST instanceof Throwable) {
            this.error = true;
            this.error_msg = (Throwable)__SERVER_LIST;
            return;
        }
        listServers = (PlutoLinkedList)__SERVER_LIST;
        this.error = false;
        this.MX_LIST.clear();
        Iterator iter = listServers.iterator();
        while (iter.hasNext()) {
            sServer = iter.next().toString();
            int idx = sServer.indexOf(" ");
            if (idx < 0) {
                log.info("DNSList", (Object)("Search Result Domain Invalid:" + sServer));
                continue;
            }
            for (int plus = 4 - idx; plus > 0; --plus) {
                sServer = "0".concat(sServer);
            }
            if (sServer.endsWith(".")) {
                this.MX_LIST.add(sServer.substring(0, sServer.length() - 1));
                continue;
            }
            this.MX_LIST.add(sServer);
        }
        if (this.MX_LIST.size() < 1) {
            this.error = true;
            this.error_msg = new DNSSerarchResultZeroException("VALID DOMAIN IS NOT PRESENT");
            return;
        }
        Collections.sort(this.MX_LIST);
    }

    void setAList(StringBuffer TMP_BUFFER) {
        if (this.MX_LIST.size() < 1) {
            this.error = true;
            return;
        }
        String sServer2 = this.MX_LIST.get(0).toString();
        String ID = sServer2.substring(0, sServer2.indexOf(" "));
        if (log.isDebugEnabled()) {
            log.debug("DNSList", (Object)("MX LIST:" + this.MX_LIST.toString()));
        }
        this.SERVER_LIST = new DNSSearchResult(this.MX_LIST.size() + 1);
        DNSGroupResolver __RESOLVE_SERVERS = LookupContainer.getInstance();
        for (String sServer2 : this.MX_LIST) {
            String __TMP_ID__ = sServer2.substring(0, sServer2.indexOf(" "));
            String sServerDomain = sServer2.substring(sServer2.indexOf(" ") + 1).trim();
            List answers = this.getArecoredList(__RESOLVE_SERVERS, sServerDomain, TMP_BUFFER);
            if (answers == null) {
                if (log.isDebugEnabled()) {
                    log.debug("DNSList", (Object)("lookup error:" + TMP_BUFFER.toString()));
                }
                LookupContainer.log(TMP_BUFFER.toString());
                continue;
            }
            Iterator iter2 = answers.iterator();
            while (iter2.hasNext()) {
                String sIP = iter2.next().toString();
                this.SERVER_LIST.add(sIP + "=" + sServerDomain);
                if (!__TMP_ID__.equals(ID)) continue;
                ++this.INDEX_OF_FIRST_REFERENCE_SEQUENCE;
            }
        }
        this.SERVER_LIST.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getArecoredList(DNSGroupResolver __RESOLVE_SERVERS, String sServerDomain, StringBuffer TMP_BUFFER) {
        TMP_BUFFER.setLength(0);
        Lookup SEARCH_LOOKUP = null;
        try {
            SEARCH_LOOKUP = new Lookup(Name.fromString(sServerDomain), 1, 1);
        }
        catch (Throwable e) {
            TMP_BUFFER.append("[");
            TMP_BUFFER.append(sServerDomain);
            TMP_BUFFER.append("]LookupCreationError-");
            TMP_BUFFER.append(e.toString());
            return null;
        }
        Lookup lookup = SEARCH_LOOKUP;
        synchronized (lookup) {
            int answer_result = __RESOLVE_SERVERS.process(SEARCH_LOOKUP, TMP_BUFFER);
            if (answer_result == 0) {
                return SEARCH_LOOKUP.getResultMxList();
            }
            TMP_BUFFER.append("[");
            TMP_BUFFER.append(sServerDomain);
            TMP_BUFFER.append("]error-");
            TMP_BUFFER.append(SEARCH_LOOKUP.getErrorString());
            return null;
        }
    }

    public boolean isError() {
        return this.error || this.PERMANENT_ERROR_FLAG;
    }

    public Throwable getErrorMsg() {
        return this.error_msg;
    }

    public String toString() {
        return this.SERVER_LIST.toString();
    }

    public void log(String log) {
        LookupContainer.log(log);
    }

    public void log(Throwable thw) {
        LookupContainer.log(thw);
    }
}

