/*
 * Decompiled with CFR 0.152.
 */
package pluto.lang;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsFileWriter;
import pluto.util.Cal;

public class ProcessWrapper {
    private static final Logger log = LoggerFactory.getLogger(ProcessWrapper.class);
    static final Runtime runtime = Runtime.getRuntime();

    private static final void log(eMsFileWriter out, String logStr) {
        try {
            out.print(Cal.getDate());
            out.print("\t");
            out.println(logStr);
            out.flush();
        }
        catch (Exception e) {
            log.error("log error", (Throwable)e);
        }
    }

    public static final int process(String command, eMsFileWriter out, long timelimit) throws Throwable {
        Process proc = runtime.exec(command);
        return ProcessWrapper.process(proc, out, timelimit);
    }

    public static final int process(Process proc, eMsFileWriter out, long timelimit) throws Throwable {
        int result = -1;
        InputStream in = proc.getInputStream();
        InputStream err = proc.getErrorStream();
        ProcessWrapper.log(out, "START PROCESS LOGGING");
        byte[] buffer = new byte[256];
        while (true) {
            int size;
            if ((size = in.read(buffer)) < 1) {
                try {
                    result = proc.exitValue();
                    out.println();
                    ProcessWrapper.log(out, proc.toString() + " is terminated =>" + String.valueOf(result));
                    return result;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            } else {
                out.print(new String(buffer, 0, size));
            }
            if (err.available() > 0 && (size = err.read(buffer)) > 0) {
                out.print(new String(buffer, 0, size));
            }
            if (timelimit <= 0L || timelimit >= System.currentTimeMillis()) continue;
            proc.destroy();
        }
    }
}

