/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.IOException;
import pluto.io.eMsFileReader;
import pluto.util.FIFOBuffer;

public class eMsStreamTokenizer {
    public static final boolean DEBUG = false;
    private static final int MAX_CONTAIN_SIZE = 10;
    private static FIFOBuffer INNER_CONTAINER = null;
    private eMsFileReader _SOURCE_ = null;
    private String _DELIM_ = null;
    private StringBuffer STRING_BUFFER = null;
    private int _INDEX_ = 0;
    private boolean _REACH_END_ = false;

    public static eMsStreamTokenizer getInstance() {
        Object returnValue = INNER_CONTAINER.pop();
        if (returnValue == null) {
            return new eMsStreamTokenizer();
        }
        return (eMsStreamTokenizer)returnValue;
    }

    public static void recycleInstance(eMsStreamTokenizer tmp) {
        if (tmp == null) {
            return;
        }
        INNER_CONTAINER.push(tmp);
    }

    public eMsStreamTokenizer() {
    }

    public eMsStreamTokenizer(eMsFileReader file, String delimit) {
        this();
        this.parse(file, delimit);
    }

    public void close() {
        this.STRING_BUFFER = null;
    }

    public void parse(eMsFileReader src, String delimit) {
        if (this.STRING_BUFFER == null) {
            this.STRING_BUFFER = new StringBuffer(256);
        }
        this._SOURCE_ = src;
        this._DELIM_ = delimit;
        this._REACH_END_ = false;
        if (this._DELIM_ == null || this._DELIM_.length() < 1) {
            throw new RuntimeException("DELIM IS NULL OR ZERO LENGTH");
        }
    }

    public boolean hasMoreTokens() {
        return !this._REACH_END_;
    }

    public String nextToken() throws IOException {
        return this.nextToken(this._DELIM_);
    }

    public String nextToken(String delim) throws IOException {
        if (this._REACH_END_) {
            return null;
        }
        String tmp = null;
        while (this._SOURCE_.ready() && (tmp = this._SOURCE_.readLine()) != null) {
            int idx = tmp.indexOf(delim, this._INDEX_);
            if (idx > 0) {
                this.STRING_BUFFER.append(tmp.substring(0, idx));
                String returnValue = this.STRING_BUFFER.toString();
                this.STRING_BUFFER.setLength(0);
                this.STRING_BUFFER.append(tmp.substring(idx + delim.length()));
                return returnValue;
            }
            this.STRING_BUFFER.append(tmp);
            this.STRING_BUFFER.append("\r\n");
        }
        this._REACH_END_ = true;
        String returnValue = this.STRING_BUFFER.toString();
        this.STRING_BUFFER.setLength(0);
        return returnValue;
    }

    static {
        INNER_CONTAINER = new FIFOBuffer(10);
    }
}

