/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;

public class eMsSizeIndexedOutputStream
extends FileOutputStream {
    private static final Logger log = LoggerFactory.getLogger(eMsSizeIndexedOutputStream.class);

    public eMsSizeIndexedOutputStream(String filename) throws FileNotFoundException {
        super(filename, false);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public eMsSizeIndexedOutputStream(String filename, boolean append) throws FileNotFoundException {
        super(filename, append);
    }

    public synchronized void writeString(String src) throws Exception {
        byte[] value = src.getBytes(eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
        this.writeNumericType(value.length);
        this.write(value);
        super.flush();
    }

    protected void writeNumericType(int val) throws IOException {
        this.write(val >>> 24);
        this.write(val >>> 16);
        this.write(val >>> 8);
        this.write(val >>> 0);
    }
}

