/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsResultSet;
import pluto.io.eMsResultSetStream;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;
import pluto.util.convert.BASE64;

public class eMsResultSetOutputStream
extends FilterOutputStream
implements eMsResultSetStream {
    private static final Logger log = LoggerFactory.getLogger(eMsResultSetOutputStream.class);
    protected byte[] buf;
    protected int count;
    protected byte[] ENC_INT_SOURCE = new byte[3];
    protected byte[] ENC_INT_TARGET = new byte[4];

    public eMsResultSetOutputStream(OutputStream o) {
        super(o);
        this.buf = ByteArrayContainer.getInstance();
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.write(48);
        super.close();
        ByteArrayContainer.recycleInstance(this.buf);
    }

    public synchronized void writeResultSet(eMsResultSet rs, boolean header_print) throws Exception {
        if (header_print) {
            this.appendHeader(rs);
        }
        int count = rs.getColumnCount();
        while (rs.next()) {
            this.write(50);
            this.writeNumericType(count);
            for (int i = 1; i <= count; ++i) {
                byte[] value = rs.getStringAsByteArray(i);
                this.writeNumericType(value.length);
                this.write(value);
            }
        }
    }

    protected void appendHeader(eMsResultSet rs) throws Exception {
        this.write(49);
        int count = rs.getColumnCount();
        if (count > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TOO MANY COLUMNS:" + String.valueOf(count));
        }
        this.writeNumericType(count);
        if (log.isDebugEnabled()) {
            log.debug("HEADER LENGTH : " + count);
        }
        String charset = rs.getOUT_CHARSET();
        ResultSetMetaData rsmt = rs.getMetaData();
        for (int i = 1; i <= count; ++i) {
            byte[] colname = null;
            colname = eMsLocale.DB_TYPE.equals("mysql") ? rsmt.getColumnLabel(i).getBytes(charset) : rsmt.getColumnName(i).getBytes(charset);
            this.writeNumericType(colname.length);
            if (log.isDebugEnabled()) {
                log.debug("WRITE HEADER LENGTH : " + colname.length);
            }
            this.write(colname);
        }
    }

    protected void writeNumericType(int val) throws IOException {
        this.ENC_INT_SOURCE[0] = (byte)(val >>> 16);
        this.ENC_INT_SOURCE[1] = (byte)(val >>> 8);
        this.ENC_INT_SOURCE[2] = (byte)(val >>> 0);
        BASE64.encode_sep(this.ENC_INT_SOURCE, 3, this.ENC_INT_TARGET);
        this.write(this.ENC_INT_TARGET[0]);
        this.write(this.ENC_INT_TARGET[1]);
        this.write(this.ENC_INT_TARGET[2]);
        this.write(this.ENC_INT_TARGET[3]);
    }
}

