/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsResultSetStream;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;
import pluto.util.PlutoLinkedList;
import pluto.util.convert.BASE64;

public class eMsResultSetInputStream
extends FilterInputStream
implements eMsResultSetStream {
    private static final Logger log = LoggerFactory.getLogger(eMsResultSetInputStream.class);
    protected byte[] __READ_BUFFER__ = null;
    protected int __BUFFER_SIZE__ = 0;
    protected int __BUFFER_INDEX__ = 0;
    protected eMsByteArrayOutputStream __INNER_WORK_BYTE_STREAM__ = null;
    protected byte[] DEC_INT_SOURCE = new byte[4];
    protected byte[] DEC_INT_TARGET = new byte[3];
    protected PlutoLinkedList HEADER_LIST = new PlutoLinkedList();

    public eMsResultSetInputStream(InputStream in) {
        super(in);
        this.__READ_BUFFER__ = ByteArrayContainer.getInstance();
        this.__INNER_WORK_BYTE_STREAM__ = eMsByteArrayOutputStream.getInstance();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    protected void inner_read() throws IOException {
        this.__BUFFER_SIZE__ = super.read(this.__READ_BUFFER__);
        this.__BUFFER_INDEX__ = 0;
    }

    protected synchronized boolean ready() throws IOException {
        if (this.__BUFFER_INDEX__ >= this.__BUFFER_SIZE__) {
            if (super.available() > 0) {
                this.inner_read();
                if (this.__BUFFER_SIZE__ < 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected synchronized String readString(int size) throws IOException {
        this.__INNER_WORK_BYTE_STREAM__.reset();
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        if (size < this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__) {
            String returnValue = new String(this.__READ_BUFFER__, this.__BUFFER_INDEX__, size, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
            this.__BUFFER_INDEX__ += size;
            return returnValue;
        }
        this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, this.__BUFFER_INDEX__, this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
        int __REMAIN_SIZE__ = size - (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
        do {
            this.inner_read();
            if (this.__BUFFER_SIZE__ < 0) break;
            if (__REMAIN_SIZE__ > this.__BUFFER_SIZE__) {
                this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, 0, this.__BUFFER_SIZE__);
                __REMAIN_SIZE__ -= this.__BUFFER_SIZE__;
                continue;
            }
            this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, 0, __REMAIN_SIZE__);
            this.__BUFFER_INDEX__ = __REMAIN_SIZE__;
            __REMAIN_SIZE__ = -1;
        } while (__REMAIN_SIZE__ > 0);
        return this.__INNER_WORK_BYTE_STREAM__.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    protected synchronized int readNumericType() throws IOException {
        int returnValue = -1;
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        this.DEC_INT_SOURCE[0] = this.__READ_BUFFER__[this.__BUFFER_INDEX__++];
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        this.DEC_INT_SOURCE[1] = this.__READ_BUFFER__[this.__BUFFER_INDEX__++];
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        this.DEC_INT_SOURCE[2] = this.__READ_BUFFER__[this.__BUFFER_INDEX__++];
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        this.DEC_INT_SOURCE[3] = this.__READ_BUFFER__[this.__BUFFER_INDEX__++];
        BASE64.decode_sep(this.DEC_INT_SOURCE, this.DEC_INT_TARGET);
        returnValue = (this.DEC_INT_TARGET[0] & 0xFF) << 16;
        returnValue += (this.DEC_INT_TARGET[1] & 0xFF) << 8;
        return returnValue += (this.DEC_INT_TARGET[2] & 0xFF) << 0;
    }

    @Override
    public int read() throws IOException {
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        return this.__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            eMsByteArrayOutputStream.recycleInstance(this.__INNER_WORK_BYTE_STREAM__);
            ByteArrayContainer.recycleInstance(this.__READ_BUFFER__);
        }
    }

    public boolean next(Properties prop) throws Exception {
        block5: while (true) {
            int type = this.read();
            switch (type) {
                case 48: {
                    return false;
                }
                case 49: {
                    String col_value;
                    int col_length;
                    int colcount;
                    this.HEADER_LIST.clear();
                    int i = colcount = this.readNumericType();
                    while (true) {
                        if (i <= 0) continue block5;
                        col_length = this.readNumericType();
                        col_value = this.readString(col_length);
                        this.HEADER_LIST.addLast(col_value);
                        --i;
                    }
                }
                case 50: {
                    String col_value;
                    int col_length;
                    int colcount = this.readNumericType();
                    if (colcount != this.HEADER_LIST.size()) {
                        throw new RuntimeException("INVALID COL COUNT HEADER: " + this.HEADER_LIST.size() + " DATA: " + colcount);
                    }
                    Iterator iter = this.HEADER_LIST.iterator();
                    while (iter.hasNext()) {
                        col_length = this.readNumericType();
                        col_value = this.readString(col_length);
                        prop.setProperty(iter.next().toString(), col_value);
                    }
                    return true;
                }
                default: {
                    throw new RuntimeException("INVALID TYPE:" + type);
                }
            }
            break;
        }
    }
}

