/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import pluto.lang.eMsLocale;
import pluto.lang.eMsStringBuffer;

public class eMsFileReader
extends BufferedReader {
    public eMsFileReader(String file) throws IOException {
        this(file, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    public eMsFileReader(String file, String char_set) throws IOException {
        this(new File(file), char_set);
    }

    public eMsFileReader(File file) throws IOException {
        this(file, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    public eMsFileReader(File file, String char_set) throws IOException {
        this(new FileInputStream(file), char_set);
    }

    public eMsFileReader(InputStream stream) throws IOException {
        this(stream, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    public eMsFileReader(InputStream stream, String char_set) throws IOException {
        super(new InputStreamReader(stream, char_set));
    }

    public static String getLastLine(String filename) throws IOException {
        eMsFileReader myReader = new eMsFileReader(filename);
        String tmp = null;
        String lastline = null;
        while (myReader.ready() && (tmp = myReader.readLine()) != null) {
            lastline = tmp;
        }
        myReader.close();
        return lastline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileBody(String filename, String charset) throws IOException {
        eMsFileReader myReader = new eMsFileReader(filename, charset);
        String tmp = null;
        Object lastline = null;
        eMsStringBuffer buffer = null;
        try {
            buffer = eMsStringBuffer.getInstance();
            while (myReader.ready() && (tmp = myReader.readLine()) != null) {
                buffer.append(tmp);
                buffer.append("\r\n");
            }
            myReader.close();
            String string = buffer.toString();
            return string;
        }
        finally {
            eMsStringBuffer.recycleInstance(buffer);
        }
    }
}

