/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import pluto.util.convert.BASE64;

public class BASE64DecodeOutputStream
extends BufferedOutputStream {
    private static final int BLANK = 32;
    private static final int TAB = 9;
    private static final int CR = 13;
    private static final int LF = 10;
    private byte[] ENC_SRC_BUFFER = new byte[4];
    private byte[] ENC_TARGET_BUFFER = new byte[3];
    private int ENC_SRC_BUFFER_SIZE;

    public BASE64DecodeOutputStream(OutputStream out) {
        this(out, 1024);
    }

    public BASE64DecodeOutputStream(OutputStream out, int size) {
        super(out, size);
    }

    @Override
    public void write(byte[] source, int i, int j) throws IOException {
        for (int k = 0; k < j; ++k) {
            this.write(source[i + k]);
        }
    }

    @Override
    public void write(byte[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    @Override
    public void write(int i) throws IOException {
        if (i == 32 || i == 9 || i == 13 || i == 10) {
            return;
        }
        this.ENC_SRC_BUFFER[this.ENC_SRC_BUFFER_SIZE++] = (byte)i;
        if (this.ENC_SRC_BUFFER_SIZE == 4) {
            this.decode();
            this.ENC_SRC_BUFFER_SIZE = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.ENC_SRC_BUFFER_SIZE > 0) {
            this.decode();
            this.ENC_SRC_BUFFER_SIZE = 0;
        }
        super.flush();
    }

    private void decode() throws IOException {
        int count = BASE64.decode_sep(this.ENC_SRC_BUFFER, this.ENC_TARGET_BUFFER);
        for (int i = 0; i < count; ++i) {
            super.write(this.ENC_TARGET_BUFFER[i]);
        }
    }
}

