/*
 * Decompiled with CFR 0.152.
 */
package pluto.dbutil;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.dbutil.CharConvertor;
import pluto.dbutil.ResultSetControlConstant;
import pluto.lang.eMsLocale;
import pluto.util.convert.BASE64;

public class ResultSetFileStore {
    private static final Logger log = LoggerFactory.getLogger(ResultSetFileStore.class);
    public static final long DEFAULT_LIMIT_SIZE = 0x40000000L;
    String sBaseFileName = null;
    int iMakeSeq = 0;
    protected String WRITE_CHARSET = null;
    protected byte[] ENC_INT_SOURCE = new byte[3];
    protected byte[] ENC_INT_TARGET = new byte[4];
    protected BufferedOutputStream stream = null;
    protected long lTotalWriteCount = 0L;

    public ResultSetFileStore(String base_name, String charset) throws Exception {
        this.sBaseFileName = base_name;
        this.iMakeSeq = 0;
        this.WRITE_CHARSET = charset;
        "test".getBytes(this.WRITE_CHARSET);
        this.makeNextFile();
    }

    private final void makeNextFile() throws Exception {
        this.close();
        FileOutputStream fos = new FileOutputStream(this.sBaseFileName + "." + String.valueOf(this.iMakeSeq));
        GZIPOutputStream gos = new GZIPOutputStream(fos);
        this.stream = new BufferedOutputStream(gos);
        ++this.iMakeSeq;
        this.lTotalWriteCount = 0L;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void writeResultSet(ResultSet rs, CharConvertor convertor) throws Exception {
        byte[] byteArrayLineDelim = ResultSetControlConstant.LINE_DELIM;
        int byteArrayLineDelimSize = ResultSetControlConstant.LINE_DELIM_LENGTH;
        ResultSetMetaData rsmt = rs.getMetaData();
        this.appendHeader(rsmt);
        int count = rsmt.getColumnCount();
        while (rs.next()) {
            if (this.lTotalWriteCount > 0x40000000L) {
                this.makeNextFile();
            }
            this.stream.write(50);
            ++this.lTotalWriteCount;
            this.writeNumericType(count);
            for (int i = 1; i <= count; ++i) {
                String sValue = convertor.decode(rs.getString(i));
                byte[] value = sValue.getBytes(this.WRITE_CHARSET);
                this.writeNumericType(value.length);
                this.stream.write(value);
                this.lTotalWriteCount += (long)value.length;
            }
            this.stream.write(byteArrayLineDelim);
            this.lTotalWriteCount += (long)byteArrayLineDelimSize;
        }
        this.stream.write(48);
    }

    protected void appendHeader(ResultSetMetaData rsmt) throws Exception {
        byte[] byteArrayLineDelim = ResultSetControlConstant.LINE_DELIM;
        int byteArrayLineDelimSize = ResultSetControlConstant.LINE_DELIM_LENGTH;
        this.stream.write(49);
        ++this.lTotalWriteCount;
        int count = rsmt.getColumnCount();
        if (count > Short.MAX_VALUE) {
            throw new IllegalArgumentException("TOO MANY COLUMNS:" + String.valueOf(count));
        }
        this.writeNumericType(count);
        if (log.isDebugEnabled()) {
            log.debug("HEADER LENGTH : " + count);
        }
        for (int i = 1; i <= count; ++i) {
            byte[] colname = null;
            colname = eMsLocale.DB_TYPE.equals("mysql") ? rsmt.getColumnLabel(i).getBytes(eMsLocale.DB_IN_CHAR_SET) : rsmt.getColumnName(i).getBytes(eMsLocale.DB_IN_CHAR_SET);
            this.writeNumericType(colname.length);
            if (log.isDebugEnabled()) {
                log.debug("WRITE HEADER LENGTH : " + colname.length);
            }
            this.stream.write(colname);
            this.lTotalWriteCount += (long)colname.length;
        }
        this.stream.write(byteArrayLineDelim);
        this.lTotalWriteCount += (long)byteArrayLineDelimSize;
    }

    protected void writeNumericType(int val) throws IOException {
        this.ENC_INT_SOURCE[0] = (byte)(val >>> 16);
        this.ENC_INT_SOURCE[1] = (byte)(val >>> 8);
        this.ENC_INT_SOURCE[2] = (byte)(val >>> 0);
        BASE64.encode_sep(this.ENC_INT_SOURCE, 3, this.ENC_INT_TARGET);
        this.stream.write(this.ENC_INT_TARGET[0]);
        this.stream.write(this.ENC_INT_TARGET[1]);
        this.stream.write(this.ENC_INT_TARGET[2]);
        this.stream.write(this.ENC_INT_TARGET[3]);
        this.lTotalWriteCount += 4L;
    }
}

