/*
 * Decompiled with CFR 0.152.
 */
package pluto.dbutil;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.dbutil.ResultSetControlConstant;
import pluto.io.eMsByteArrayOutputStream;
import pluto.util.PlutoLinkedList;
import pluto.util.convert.BASE64;

public class ResultSetFileReader {
    private static final Logger log = LoggerFactory.getLogger(ResultSetFileReader.class);
    private String sBaseFileName = null;
    private int iMakeSeq = 0;
    protected String READ_CHAR_SET = null;
    protected BufferedInputStream stream = null;
    protected byte[] DEC_INT_SOURCE = new byte[4];
    protected byte[] DEC_INT_TARGET = new byte[3];
    protected byte[] LINE_SKIP_DUMMY = null;
    protected PlutoLinkedList HEADER_LIST = null;
    protected eMsByteArrayOutputStream bufferByteStream = null;
    protected byte[] readByteArray = new byte[256];

    public ResultSetFileReader(String base_name, String charset) throws Exception {
        this.sBaseFileName = base_name;
        this.iMakeSeq = 0;
        this.READ_CHAR_SET = charset;
        this.HEADER_LIST = new PlutoLinkedList();
        this.LINE_SKIP_DUMMY = new byte[ResultSetControlConstant.LINE_DELIM_LENGTH];
        "test".getBytes(this.READ_CHAR_SET);
        if (!this.openNextFile()) {
            throw new RuntimeException("MISSING FILE");
        }
    }

    public void close() {
        eMsByteArrayOutputStream.recycleInstance(this.bufferByteStream);
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final boolean openNextFile() throws Exception {
        this.close();
        File f = new File(this.sBaseFileName + "." + String.valueOf(this.iMakeSeq));
        if (f.exists() && f.isFile()) {
            FileInputStream fis = new FileInputStream(f);
            GZIPInputStream gis = new GZIPInputStream(fis);
            this.stream = new BufferedInputStream(gis);
            ++this.iMakeSeq;
            this.bufferByteStream = eMsByteArrayOutputStream.getInstance();
            return true;
        }
        return false;
    }

    private final void skipLine() throws Exception {
        this.stream.read(this.LINE_SKIP_DUMMY);
    }

    public boolean next(Properties prop) throws Exception {
        block6: while (true) {
            int type = this.stream.read();
            switch (type) {
                case -1: {
                    if (this.openNextFile()) continue block6;
                    throw new RuntimeException("MISSING NEXT FILE");
                }
                case 48: {
                    if (log.isDebugEnabled()) {
                        log.debug("#END");
                    }
                    return false;
                }
                case 49: {
                    int i;
                    if (log.isDebugEnabled()) {
                        log.debug("#HEADER");
                    }
                    this.HEADER_LIST.clear();
                    int colcount = this.readNumericType();
                    if (log.isDebugEnabled()) {
                        log.debug("#HEADER COLUMN COUNT : " + colcount);
                    }
                    for (i = colcount; i > 0; --i) {
                        int col_length = this.readNumericType();
                        if (log.isDebugEnabled()) {
                            log.debug("#READ byte: " + col_length);
                        }
                        String col_value = this.readString(col_length);
                        if (log.isDebugEnabled()) {
                            log.debug("#PRINT : " + col_value);
                        }
                        this.HEADER_LIST.addLast(col_value);
                    }
                    this.skipLine();
                    break;
                }
                case 50: {
                    if (log.isDebugEnabled()) {
                        log.debug("#BODY");
                    }
                    int colcount = this.readNumericType();
                    if (log.isDebugEnabled()) {
                        log.debug("#COLUMN COUNT : " + colcount);
                    }
                    if (colcount != this.HEADER_LIST.size()) {
                        throw new RuntimeException("INVALID COL COUNT HEADER: " + this.HEADER_LIST.size() + " DATA: " + colcount);
                    }
                    int i = 0;
                    Iterator iter = this.HEADER_LIST.iterator();
                    while (iter.hasNext()) {
                        String col_value;
                        int col_length = this.readNumericType();
                        if (log.isDebugEnabled()) {
                            System.out.print(String.valueOf(col_length) + "/");
                        }
                        String string = col_value = col_length > 0 ? this.readString(col_length) : "";
                        if (log.isDebugEnabled()) {
                            System.out.print("\\");
                        }
                        prop.setProperty(iter.next().toString(), col_value);
                        if (!log.isDebugEnabled()) continue;
                        log.debug(String.valueOf(++i) + ".");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("#SET RESULT : " + prop.toString());
                    }
                    this.skipLine();
                    return true;
                }
                default: {
                    throw new RuntimeException("INVALID TYPE:" + type);
                }
            }
        }
    }

    protected synchronized String readString(int size) throws IOException {
        int i;
        byte[] buffer = this.readByteArray;
        if (size < 256) {
            if (this.stream.read(buffer, 0, size) != size) {
                throw new RuntimeException("INVALID LENGTH");
            }
            if (log.isDebugEnabled()) {
                System.out.print("-");
            }
            return new String(buffer, 0, size, this.READ_CHAR_SET);
        }
        this.bufferByteStream.reset();
        if (size > 10000) {
            log.debug("KEK");
        }
        while (size > 0 && (i = this.stream.read(buffer, 0, size > 256 ? 256 : size)) > 0) {
            if (log.isDebugEnabled()) {
                String a = new String(buffer, 0, i, this.READ_CHAR_SET);
                log.debug(a);
            }
            this.bufferByteStream.write(buffer, 0, i);
            if (log.isDebugEnabled()) {
                System.out.print("=");
            }
            size -= i;
        }
        if (log.isDebugEnabled()) {
            System.out.print("*:" + String.valueOf(this.bufferByteStream.size()));
        }
        return this.bufferByteStream.toString(this.READ_CHAR_SET);
    }

    protected synchronized int readNumericType() throws IOException {
        int returnValue = -1;
        if (this.stream.read(this.DEC_INT_SOURCE) != 4) {
            throw new RuntimeException("INVALID FORMAT");
        }
        BASE64.decode_sep(this.DEC_INT_SOURCE, this.DEC_INT_TARGET);
        returnValue = ((this.DEC_INT_TARGET[0] & 0xFF) << 16) + ((this.DEC_INT_TARGET[1] & 0xFF) << 8) + ((this.DEC_INT_TARGET[2] & 0xFF) << 0);
        return returnValue;
    }
}

