/*
 * Decompiled with CFR 0.152.
 */
package pluto.db;

import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatementInterface;
import pluto.util.PlutoLinkedList;

public class eMsPreparedStatement
implements eMsStatementInterface {
    private static final Logger log = LoggerFactory.getLogger(eMsPreparedStatement.class);
    public static final char STRING_PARAM_INDEX = '\'';
    public static final short STRING_TYPE_PARAMETER = 1;
    public static final short NUMERIC_TYPE_PARAMETER = 2;
    private PreparedStatement ps = null;
    private String ORIGINAL_QUERY = null;
    private String CONVERT_QUERY = null;
    private PlutoLinkedList PARAMETER_INFOS = null;
    private eMsConnection EMS_CONNECTION = null;

    public eMsPreparedStatement(String src, String START_INDEX, String END_INDEX) throws Exception {
        this.ORIGINAL_QUERY = src;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            this.convertSql(buffer, this.ORIGINAL_QUERY, START_INDEX, END_INDEX);
            this.CONVERT_QUERY = buffer.toString();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    @Override
    public void connectTo(eMsConnection conn) throws SQLException {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.EMS_CONNECTION = conn;
        this.ps = this.EMS_CONNECTION.prepareStatement(conn.encode(this.CONVERT_QUERY));
    }

    @Override
    public void close() {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void convertSql(StringBuffer myBuffer, String source, String START_INDEX, String END_INDEX) throws Exception {
        if (source == null) {
            throw new RuntimeException("TARGET QUERY IS NULL");
        }
        this.PARAMETER_INFOS = new PlutoLinkedList();
        source = source.concat("             ");
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        while ((idx1 = source.indexOf(START_INDEX, idx3)) >= 0) {
            idx2 = source.indexOf(END_INDEX, idx1);
            if (idx2 < 0) {
                throw new RuntimeException("PARSE ERROR NEAR=>" + source.substring(idx1 - 3));
            }
            if (source.charAt(idx1 - 1) == '\'' && source.charAt(idx2 + END_INDEX.length()) == '\'') {
                this.PARAMETER_INFOS.addLast(new PreparedParameter(1, source.substring(idx1 + 2, idx2)));
                if (log.isDebugEnabled()) {
                    log.debug("STRING_TYPE_PARAMETER:" + source.substring(idx1 + START_INDEX.length(), idx2) + " ADDED");
                }
                myBuffer.append(source.substring(idx3, idx1 - 1));
                myBuffer.append("?");
                idx3 = idx2 + END_INDEX.length() + 1;
                continue;
            }
            if (source.charAt(idx1 - 1) != '\'' && source.charAt(idx2 + END_INDEX.length()) != '\'') {
                this.PARAMETER_INFOS.addLast(new PreparedParameter(2, source.substring(idx1 + 2, idx2)));
                if (log.isDebugEnabled()) {
                    log.debug("NUMERIC_TYPE_PARAMETER:" + source.substring(idx1 + START_INDEX.length(), idx2) + " ADDED");
                }
                myBuffer.append(source.substring(idx3, idx1));
                myBuffer.append("?");
                idx3 = idx2 + END_INDEX.length();
                continue;
            }
            throw new RuntimeException("PARSE ERROR NEAR=>" + source.substring(idx1 - 3));
        }
        myBuffer.append(source.substring(idx3));
    }

    protected synchronized void setParameter(Map map) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("INSERT PARAMETER:{}", (Object)map);
        }
        int idx = 1;
        for (PreparedParameter param : this.PARAMETER_INFOS) {
            Object value = map.get(param.getIndex());
            switch (param.getType()) {
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug("STRING_TYPE_PARAMETER set:" + param.getIndex() + " => [" + value.toString() + "]");
                    }
                    this.ps.setString(idx, value == null ? "" : this.EMS_CONNECTION.encode(value.toString()));
                    break;
                }
                case 2: {
                    if (value == null) {
                        throw new RuntimeException("CAN'T SET NUMERIC TO NULL:" + param.getIndex());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("NUMERIC_TYPE_PARAMETER set:" + param.getIndex() + " => [" + value.toString() + "]");
                    }
                    this.ps.setInt(idx, Integer.parseInt(value.toString()));
                    break;
                }
                default: {
                    throw new RuntimeException("UNKNOWN TYPE:" + String.valueOf(param.getType()));
                }
            }
            ++idx;
        }
    }

    protected synchronized void setParameterLong(Map map) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("INSERT PARAMETER:" + map.toString());
        }
        int idx = 1;
        for (PreparedParameter param : this.PARAMETER_INFOS) {
            Object value = map.get(param.getIndex());
            switch (param.getType()) {
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug("STRING_TYPE_PARAMETER set:" + param.getIndex() + " => [" + value.toString() + "]");
                    }
                    this.ps.setString(idx, value == null ? "" : this.EMS_CONNECTION.encode(value.toString()));
                    break;
                }
                case 2: {
                    if (value == null) {
                        throw new RuntimeException("CAN'T SET NUMERIC TO NULL:" + param.getIndex());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("NUMERIC_TYPE_PARAMETER set:" + param.getIndex() + " => [" + value.toString() + "]");
                    }
                    this.ps.setLong(idx, Long.parseLong(value.toString()));
                    break;
                }
                default: {
                    throw new RuntimeException("UNKNOWN TYPE:" + String.valueOf(param.getType()));
                }
            }
            ++idx;
        }
    }

    protected synchronized void setParameterMMS(Map map) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("INSERT  MMS PARAMETER:" + map.toString());
        }
        int idx = 1;
        for (PreparedParameter param : this.PARAMETER_INFOS) {
            Object value = map.get(param.getIndex());
            switch (param.getType()) {
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug("STRING_TYPE_PARAMETER set:" + param.getIndex() + " => [" + value.toString() + "]");
                    }
                    if (value.toString().getBytes().length <= 1024) {
                        this.ps.setString(idx, value == null ? "" : this.EMS_CONNECTION.encode(value.toString()));
                        break;
                    }
                    this.ps.setCharacterStream(idx, (Reader)(value == null ? new StringReader("") : new StringReader(this.EMS_CONNECTION.encode(value.toString()))), value.toString().length());
                    break;
                }
                case 2: {
                    if (value == null) {
                        throw new RuntimeException("CAN'T SET NUMERIC TO NULL:" + param.getIndex());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("NUMERIC_TYPE_PARAMETER set:" + param.getIndex() + " => [" + value.toString() + "]");
                    }
                    this.ps.setInt(idx, Integer.parseInt(value.toString()));
                    break;
                }
                default: {
                    throw new RuntimeException("UNKNOWN TYPE:" + String.valueOf(param.getType()));
                }
            }
            ++idx;
        }
    }

    public int executeUpdate(Map map) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameter(map);
            int n = this.ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public int executeUpdateLong(Map map) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameterLong(map);
            int n = this.ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public void addBatch(Map map) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameter(map);
            this.ps.addBatch();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public void addBatchLong(Map map) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameterLong(map);
            this.ps.addBatch();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = this.ps.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public int executeUpdateMMS(Map map) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameterMMS(map);
            int n = this.ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public eMsResultSet executeQuery(Map map) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameter(map);
            eMsResultSet eMsResultSet2 = new eMsResultSet(this.EMS_CONNECTION, this.ps.executeQuery());
            return eMsResultSet2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public eMsResultSet executeQuery(Map map, String dbType) throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameter(map);
            eMsResultSet eMsResultSet2 = new eMsResultSet(this.EMS_CONNECTION, this.ps.executeQuery(), dbType);
            return eMsResultSet2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public String toString() {
        return "ORIGINAL=>" + this.ORIGINAL_QUERY + "\r\n" + "CONVERT_QUERY=>" + this.CONVERT_QUERY + "\r\n" + this.PARAMETER_INFOS.toString();
    }

    @Override
    public boolean check(String query) {
        return true;
    }

    public boolean checkResultSet(Map map) throws SQLException {
        ResultSet rs = null;
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            this.setParameter(map);
            rs = this.ps.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
    }

    static class PreparedParameter {
        short type;
        String index;

        PreparedParameter(short t, String i) {
            this.type = t;
            this.index = i;
        }

        public short getType() {
            return this.type;
        }

        public String getIndex() {
            return this.index;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "STRING_TYPE_PARAMETER:".concat(this.index);
                }
                case 2: {
                    return "NUMERIC_TYPE_PARAMETER:".concat(this.index);
                }
            }
            return "UNKNOWN TYPE";
        }
    }
}

