/*
 * Decompiled with CFR 0.152.
 */
package pluto.db;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectInfo;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.db.eMsStatementInterface;
import pluto.lang.Name;
import pluto.lang.eMsLocale;
import pluto.schedule.ScheduledMonitor;
import pluto.util.AmailHashtable;
import pluto.util.Cal;
import pluto.util.FIFOBuffer;
import pluto.util.KeyValueEntry;
import pluto.util.StringConvertUtil;

public abstract class eMsConnection
extends Name {
    private static final Logger log = LoggerFactory.getLogger(eMsConnection.class);
    public static final String DEFAULT_CLASS_NAME = "pluto.common.db.NotPooledConnection";
    public static final int __DEFAULT_QUERY_TIMEOUT__ = 1800000;
    public static final int __CONNECTION_INDEX_TYPE__ = 1;
    public static final int __CONNECTION_INFORMATION_TYPE__ = 2;
    public static final int __MAXIMUM_RECYCLE_STATEMENT__ = 5;
    public static int GET_CONNECTION_TYPE = 2;
    public static String GET_CONNECTION_INDEX = "CONNECTION_INDEX";
    protected static Hashtable info = new Hashtable();
    private static String TargetFileName = null;
    private static File TargetFile = null;
    private static Class SUB_IMPLEMENTS_CLASS = null;
    private static Class BASIC_IMPLEMENTS_CLASS = null;
    private static Vector DRIVER_NAMES = new Vector();
    protected static boolean STATEMENT_RECYCLING_FLAG = true;
    protected static AmailHashtable MONITORED_TARGET_CONNECTIONS = new AmailHashtable();
    protected static ConnectionMonitor INNER_CONNECTION_MONITOR = null;
    protected static boolean CONNECTION_MONITOR_PRESENT = false;
    private static final String oracle_class = "class oracle.jdbc.driver.OraclePreparedStatementWrapper";
    protected Connection conn = null;
    protected FIFOBuffer RECYCLE_STATMENTS = new FIFOBuffer(5);
    protected FIFOBuffer INSTANT_STATMENTS = new FIFOBuffer(-1);
    protected String name = null;
    protected Object lock = null;
    protected static Object __MONITOR_LOCK__;
    protected ConnectInfo CONNECT_INFO = null;
    private boolean db_in_convert = false;
    private boolean db_out_convert = false;
    private String db_base_charset = "KSC5601";
    private String db_in_charset = "KSC5601";
    private String db_out_charset = "KSC5601";
    private String BASIC_CONNECTION_NAME = null;
    private static final byte[] __NULL_RETURN_BYTE_ARRAY__;
    private long IDLE_CHOICE_TIME = -1L;

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        String getConnectionType = prop.getProperty("get.connection.type", "info");
        if (getConnectionType.equalsIgnoreCase("index")) {
            GET_CONNECTION_TYPE = 1;
            GET_CONNECTION_INDEX = prop.getProperty("get.connection.index", "CONNECTION_INDEX");
        } else {
            GET_CONNECTION_TYPE = 2;
        }
        TargetFileName = prop.getProperty("info.file");
        if (TargetFileName == null) {
            return;
        }
        TargetFile = new File(TargetFileName);
        info.clear();
        Properties tmpinfo = new Properties();
        tmpinfo.load(new FileInputStream(TargetFile));
        Enumeration<Object> eNum = tmpinfo.keys();
        while (eNum.hasMoreElements()) {
            String key = (String)eNum.nextElement();
            if (!key.endsWith(".name")) continue;
            String id = key.substring(0, key.lastIndexOf("."));
            String driver = tmpinfo.getProperty(id + ".driver");
            eMsConnection.registDriver(driver);
            ConnectInfo tmpInfo = new ConnectInfo();
            tmpInfo.setDB_ID(id);
            tmpInfo.setDRIVER(driver);
            tmpInfo.setDB_NAME(tmpinfo.getProperty(key));
            tmpInfo.setDB_BASE_CHARSET(tmpinfo.getProperty(id + ".base.charset", eMsLocale.CHAR_SET));
            tmpInfo.setDB_IN_CHARSET(tmpinfo.getProperty(id + ".in.charset", eMsLocale.CHAR_SET));
            tmpInfo.setDB_OUT_CHARSET(tmpinfo.getProperty(id + ".out.charset", eMsLocale.CHAR_SET));
            tmpInfo.setDB_PASS(tmpinfo.getProperty(id + ".pass"));
            tmpInfo.setDB_UID(tmpinfo.getProperty(id + ".id"));
            tmpInfo.setDB_URL(tmpinfo.getProperty(id + ".url"));
            tmpInfo.setDB_INIT_QUERY(tmpinfo.getProperty(id + ".default"));
            if (log.isDebugEnabled()) {
                log.debug(id + ":base:" + tmpInfo.getDB_BASE_CHARSET());
                log.debug(id + ":in:" + tmpInfo.getDB_IN_CHARSET());
                log.debug(id + ":out:" + tmpInfo.getDB_OUT_CHARSET());
            }
            key.getBytes(tmpInfo.getDB_BASE_CHARSET());
            key.getBytes(tmpInfo.getDB_IN_CHARSET());
            key.getBytes(tmpInfo.getDB_OUT_CHARSET());
            info.put(id, tmpInfo);
        }
        if (!info.containsKey("ems")) {
            throw new RuntimeException("EMS Connection info is not set!!!!");
        }
        STATEMENT_RECYCLING_FLAG = prop.getProperty("statement.recycle.flag", "false").equalsIgnoreCase("true");
        String sub_class = prop.getProperty("connection.class", DEFAULT_CLASS_NAME);
        SUB_IMPLEMENTS_CLASS = Class.forName(sub_class);
        Method TargetMethod = null;
        Class[] method_args = new Class[]{Object.class};
        Object[] args = new Object[]{tmp};
        TargetMethod = SUB_IMPLEMENTS_CLASS.getDeclaredMethod("init", method_args);
        TargetMethod.invoke(null, args);
        if (prop.getProperty("connection.monitor.init", "false").equalsIgnoreCase("true")) {
            INNER_CONNECTION_MONITOR = new ConnectionMonitor();
            INNER_CONNECTION_MONITOR.start();
            CONNECTION_MONITOR_PRESENT = true;
            if (log.isDebugEnabled()) {
                log.debug("INIT ConnectionMonitor");
            }
        }
    }

    public static synchronized void unload() throws Exception {
        INNER_CONNECTION_MONITOR.close();
    }

    public static boolean isMonitorPresent() {
        return CONNECTION_MONITOR_PRESENT;
    }

    protected eMsConnection() {
    }

    public Connection getPureConnection() {
        return this.conn;
    }

    @Override
    public void setName(String name) {
        if (this.BASIC_CONNECTION_NAME == null) {
            this.BASIC_CONNECTION_NAME = name.toString();
            super.setName(this.BASIC_CONNECTION_NAME);
        } else {
            super.setName(this.BASIC_CONNECTION_NAME.concat(":").concat(name));
        }
    }

    public static final void registDriver(String driver) throws SQLException {
        if (!DRIVER_NAMES.contains(driver)) {
            DRIVER_NAMES.addElement(driver);
            try {
                Class.forName(driver);
            }
            catch (Exception e) {
                throw new SQLException("Driver Class Not Fount in ClassPath");
            }
        }
    }

    public static ConnectInfo getConnectInfo(String index) throws Exception {
        ConnectInfo returnValue = (ConnectInfo)info.get(index);
        if (returnValue == null) {
            throw new Exception("Not Regist DB Index : " + index);
        }
        return returnValue.getClone();
    }

    public static eMsConnection getInstance() throws Exception {
        eMsConnection returnValue = (eMsConnection)SUB_IMPLEMENTS_CLASS.newInstance();
        return returnValue;
    }

    public static eMsConnection getBasicInstance() throws Exception {
        return (eMsConnection)BASIC_IMPLEMENTS_CLASS.newInstance();
    }

    public static final void releaseConnection(eMsConnection con) {
        if (con != null) {
            con.close();
        }
    }

    public void execute() throws SQLException {
        this.execute((ConnectInfo)info.get("ems"));
    }

    public void execute(ConnectInfo info) throws SQLException {
        this.CONNECT_INFO = info;
        this.lock = new Object();
        eMsConnection.registDriver(this.CONNECT_INFO.getDRIVER());
        this.db_base_charset = this.CONNECT_INFO.getDB_BASE_CHARSET();
        this.db_in_charset = this.CONNECT_INFO.getDB_IN_CHARSET();
        this.db_out_charset = this.CONNECT_INFO.getDB_OUT_CHARSET();
        this.db_in_convert = !this.db_base_charset.equals(this.db_in_charset);
        this.db_out_convert = !this.db_base_charset.equals(this.db_out_charset);
        this.ensureOpen();
    }

    public String encode(String src) {
        if (src == null) {
            return "";
        }
        if (!this.db_in_convert) {
            return src;
        }
        try {
            return new String(src.getBytes(this.db_in_charset), this.db_base_charset);
        }
        catch (Exception e) {
            return src;
        }
    }

    public String decode(String src) {
        if (src == null) {
            return "";
        }
        if (!this.db_out_convert) {
            return src;
        }
        try {
            return new String(src.getBytes(this.db_base_charset), this.db_out_charset);
        }
        catch (Exception e) {
            return src;
        }
    }

    public byte[] decodeByteArray(String src) {
        if (src == null) {
            return __NULL_RETURN_BYTE_ARRAY__;
        }
        try {
            return src.getBytes(this.db_out_charset);
        }
        catch (Exception e) {
            return src.getBytes();
        }
    }

    public final String getIN_CHARSET() {
        return this.db_in_charset;
    }

    public final String getOUT_CHARSET() {
        return this.db_out_charset;
    }

    public final String getBASE_CHARSET() {
        return this.db_base_charset;
    }

    public String toString() {
        return this.getName();
    }

    public synchronized boolean isClosed() {
        try {
            return this.conn.isClosed();
        }
        catch (Exception e) {
            this.clean();
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }

    public synchronized void releaseConnection() {
        if (log.isDebugEnabled()) {
            log.debug("releaseConnection");
        }
        this.close();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement returnValue = this.conn.prepareStatement(sql);
        this.INSTANT_STATMENTS.push(returnValue);
        return returnValue;
    }

    public eMsPreparedStatement prepareStatement(String sql, String start, String end) throws Exception {
        eMsPreparedStatement returnValue = null;
        try {
            returnValue = new eMsPreparedStatement(sql, start, end);
            returnValue.connectTo(this);
        }
        catch (Exception e) {
            try {
                Statement stmt = this.conn.createStatement();
                stmt.close();
                throw new SQLException(e.toString());
            }
            catch (SQLException ex) {
                this.reconnect();
                returnValue = new eMsPreparedStatement(sql, start, end);
                returnValue.connectTo(this);
            }
        }
        this.INSTANT_STATMENTS.push(returnValue);
        return returnValue;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement returnValue = null;
        try {
            returnValue = this.conn.prepareCall(this.encode(sql));
        }
        catch (Exception e) {
            try {
                Statement stmt = this.conn.createStatement();
                stmt.close();
                throw new SQLException(e.toString());
            }
            catch (Exception ex) {
                this.reconnect();
                returnValue = this.conn.prepareCall(sql);
            }
        }
        this.INSTANT_STATMENTS.push(returnValue);
        return returnValue;
    }

    protected synchronized Statement createInnerStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public synchronized eMsStatement createStatement() throws SQLException {
        Object tmp = this.RECYCLE_STATMENTS.pop();
        if (tmp != null) {
            return (eMsStatement)tmp;
        }
        eMsStatement returnValue = new eMsStatement();
        returnValue.connectTo(this);
        return returnValue;
    }

    public void clean() {
        if (log.isDebugEnabled()) {
            log.debug(" ==> cleaning Opened Statement [START]");
        }
        this.cleanInstantStatements();
        if (log.isDebugEnabled()) {
            log.debug(" ==> cleaning Opened Statement [END]");
        }
    }

    protected synchronized void cleanInstantStatements() {
        Object tmp = null;
        while ((tmp = this.INSTANT_STATMENTS.pop()) != null) {
            Class<?> tmpClass = tmp.getClass();
            Method tmpMethod = null;
            try {
                if (oracle_class.equals(tmpClass.toString())) {
                    PreparedStatement returnValue = (PreparedStatement)tmp;
                    returnValue.close();
                    continue;
                }
                tmpMethod = tmpClass.getMethod("close", null);
                tmpMethod.invoke(tmp, null);
            }
            catch (Exception e) {
                log.error("clean instance error", (Throwable)e);
            }
        }
    }

    protected synchronized void cleanRecycleStatements() {
        Object tmp = null;
        while ((tmp = this.RECYCLE_STATMENTS.pop()) != null) {
            eMsStatementInterface target = (eMsStatementInterface)tmp;
            try {
                target.close();
            }
            catch (Exception e) {
                log.error("clean recycle error", (Throwable)e);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(" ==> cleaning -> " + target.toString());
        }
    }

    public synchronized void recycleStatement(eMsStatementInterface stmt) {
        if (stmt == null) {
            return;
        }
        stmt.close();
    }

    public synchronized void reconnect() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("reconnect");
        }
        this.releaseConnection();
        this.ensureOpen();
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("INTO DESTROY");
        }
        this.lock = null;
        this.close();
    }

    public synchronized void recycle() {
        if (log.isDebugEnabled()) {
            log.debug("INTO RECYCLE");
        }
        this.close();
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("INTO CLOSE");
        }
        this.cleanInstantStatements();
        this.cleanRecycleStatements();
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CONNECTION_MONITOR_PRESENT) {
            this.releaseIdleMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeUpdateList(List __QUERY_LIST__, Map __INFO__, String __START__, String __END__, boolean __CHECK_FAIL__) throws Exception {
        eMsStatement __UPDATE_STATEMENT__ = null;
        StringBuffer buffer = null;
        try {
            __UPDATE_STATEMENT__ = this.createStatement();
            buffer = new StringBuffer(1024);
            List list = __QUERY_LIST__;
            synchronized (list) {
                for (String query : __QUERY_LIST__) {
                    buffer.setLength(0);
                    StringConvertUtil.ConvertString(buffer, query, __INFO__, __START__, __END__, true, false);
                    if (log.isDebugEnabled()) {
                        log.debug(buffer.toString());
                    }
                    if (__UPDATE_STATEMENT__.executeUpdate(buffer.toString()) >= 1 || !__CHECK_FAIL__) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            if (__UPDATE_STATEMENT__ != null) {
                this.recycleStatement(__UPDATE_STATEMENT__);
            }
            buffer = null;
        }
        {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String query) throws SQLException {
        eMsStatement __UPDATE_STATEMENT__ = null;
        try {
            __UPDATE_STATEMENT__ = this.createStatement();
            int n = __UPDATE_STATEMENT__.executeUpdate(query);
            return n;
        }
        finally {
            if (__UPDATE_STATEMENT__ != null) {
                this.recycleStatement(__UPDATE_STATEMENT__);
            }
        }
    }

    protected final boolean isIdleConnection() {
        if (log.isDebugEnabled()) {
            log.debug("TARGET DATE" + Cal.getDate(this.IDLE_CHOICE_TIME));
        }
        if (log.isDebugEnabled()) {
            log.debug("NOW DATE" + Cal.getDate());
        }
        return this.IDLE_CHOICE_TIME > 0L && this.IDLE_CHOICE_TIME < System.currentTimeMillis();
    }

    protected final void releaseIdleLimitTime() {
        this.IDLE_CHOICE_TIME = -1L;
    }

    protected final void setIdleLimitTime(int sec) {
        this.IDLE_CHOICE_TIME = sec > 0 ? System.currentTimeMillis() + (long)sec * 1000L : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseIdleMonitor() {
        this.IDLE_CHOICE_TIME = -1L;
        AmailHashtable amailHashtable = MONITORED_TARGET_CONNECTIONS;
        synchronized (amailHashtable) {
            if (log.isDebugEnabled()) {
                log.debug("EXIT MONITOR");
            }
            MONITORED_TARGET_CONNECTIONS.remove(this);
        }
    }

    public final void interruptConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            log.error("INTERRUPT CONNECTION ERROR", (Throwable)e);
        }
    }

    protected void log(String logStr) {
        log.info("log :{}", (Object)logStr);
    }

    public abstract void ensureOpen() throws SQLException;

    public abstract boolean expire();

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean executeUpdate(List __QUERY_LIST__, Map __INFO__, String __START__, String __END__, boolean __CHECK_FAIL__) throws Exception {
        eMsStatement __UPDATE_STATEMENT__ = null;
        try {
            __UPDATE_STATEMENT__ = this.createStatement();
            for (String query : __QUERY_LIST__) {
                if (__UPDATE_STATEMENT__.executeUpdate(query, __INFO__, __START__, __END__) >= 1 || !__CHECK_FAIL__) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (__UPDATE_STATEMENT__ != null) {
                this.recycleStatement(__UPDATE_STATEMENT__);
            }
        }
        return true;
    }

    public void execTargetQueryUpdate(List __QUERY_LIST__) throws Exception {
        this.executeUpdate(__QUERY_LIST__, null, null, null, false);
    }

    public int execTargetQueryUpdate(String query, Map map, String start, String end) throws Exception {
        eMsStatement stmt = null;
        try {
            stmt = this.createStatement();
            int n = stmt.executeUpdate(query, map, start, end);
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.recycleStatement(stmt);
        }
    }

    public int execTargetQueryUpdate(String query) throws Exception {
        return this.execTargetQueryUpdate(query, null, null, null);
    }

    public boolean putSingleResultToMap(String query, Map map) throws Exception {
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                rs.putToMap(map, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            this.recycleStatement(stmt);
        }
    }

    public Properties putSingleResultToMapConvert(String query, Map map, String start, String end) throws Exception {
        StringBuffer buffer = null;
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        Properties prop = null;
        try {
            prop = new Properties();
            buffer = new StringBuffer(512);
            StringConvertUtil.ConvertString(buffer, query, map, start, end, true, false);
            stmt = this.createStatement();
            rs = stmt.executeQuery(buffer.toString());
            if (rs.next()) {
                rs.putToMap(prop, false);
            }
            if (rs != null) {
                rs.close();
            }
            this.recycleStatement(stmt);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    rs.close();
                }
                this.recycleStatement(stmt);
                throw throwable;
            }
        }
        return prop;
    }

    public ArrayList<Properties> putResultToList(String query, Map map, String start, String end) throws Exception {
        StringBuffer buffer = null;
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        Properties prop = null;
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            buffer = new StringBuffer(512);
            StringConvertUtil.ConvertString(buffer, query, map, start, end, true, false);
            stmt = this.createStatement();
            rs = stmt.executeQuery(buffer.toString());
            while (rs.next()) {
                prop = new Properties();
                rs.putToMap(prop, false);
                list.add(prop);
            }
            if (rs != null) {
                rs.close();
            }
            this.recycleStatement(stmt);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    rs.close();
                }
                this.recycleStatement(stmt);
                throw throwable;
            }
        }
        return list;
    }

    public static boolean checkConnectionAboutException(Exception e) {
        SQLException se;
        if (e == null) {
            return false;
        }
        return e instanceof SQLException && ((se = (SQLException)e).getErrorCode() == 0 || se.getSQLState() == null);
    }

    static {
        try {
            SUB_IMPLEMENTS_CLASS = Class.forName(DEFAULT_CLASS_NAME);
            BASIC_IMPLEMENTS_CLASS = Class.forName(DEFAULT_CLASS_NAME);
        }
        catch (Exception ignore) {
            log.error("query init errror", (Throwable)ignore);
        }
        __MONITOR_LOCK__ = new Object();
        __NULL_RETURN_BYTE_ARRAY__ = " ".getBytes();
    }

    static class ConnectionMonitor
    extends ScheduledMonitor {
        Object[] __TARGET_CONNECTIONS__ = null;

        ConnectionMonitor() {
            super("eMsConnection inner Monitor");
            super.setName("eMsConnection inner Monitor");
            this.__TARGET_CONNECTIONS__ = new Object[10];
        }

        @Override
        protected void check() throws Exception {
            if (log.isDebugEnabled()) {
                log.debug("CHECK IDLE CONNECTION");
            }
            Iterator iter = MONITORED_TARGET_CONNECTIONS.iterator();
            while (iter.hasNext()) {
                KeyValueEntry value = (KeyValueEntry)iter.next();
                eMsConnection conn = (eMsConnection)value.getKey();
                String name = (String)value.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("CHECK " + name);
                }
                if (conn.isIdleConnection()) {
                    log.error("FOUND IDLE DB CONNECTION {}", (Object)(conn.getName() + name));
                    try {
                        conn.interruptConnection();
                    }
                    catch (Exception e) {
                        log.error("interrupt connection error", (Throwable)e);
                    }
                    log.error("CLOSE IDLE DB CONNECTION DONE... :{}", (Object)(conn.getName() + name));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("CHECK " + name + " OK");
            }
        }
    }
}

