/*
 * Decompiled with CFR 0.152.
 */
package pluto.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pluto.io.FileElement;

public class ZipFileManager {
    public static boolean isCompressed(String file_name) {
        if (file_name == null) {
            return false;
        }
        String temp = file_name.toLowerCase();
        return temp.endsWith(".zip");
    }

    public static String makeZip(String base, String fileName) throws Exception {
        return ZipFileManager.makeZip(base, fileName, true);
    }

    public static String makeZip(String base, String fileName, boolean keepOriginal) throws Exception {
        int i;
        File f = new File(base + File.separator + fileName);
        FileInputStream fis = new FileInputStream(f);
        String zipFileName = fileName + ".zip";
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(base + File.separator + zipFileName));
        ZipEntry ze = new ZipEntry(fileName);
        zos.putNextEntry(ze);
        byte[] b = new byte[128];
        while ((i = fis.read(b)) > 0) {
            zos.write(b, 0, i);
            zos.flush();
        }
        fis.close();
        zos.close();
        if (!keepOriginal) {
            f.delete();
        }
        return base + "/" + zipFileName;
    }

    public static String unZip(String zipFile, String destBase, boolean keepZipFile) throws Exception {
        return ZipFileManager.unZip(zipFile, destBase, null, keepZipFile);
    }

    public static String unZip(String zipFile, String destBase, String newFile, boolean keepZipFile) throws Exception {
        int i;
        if (zipFile == null || !zipFile.toLowerCase().endsWith(".zip")) {
            throw new Exception(" Not a zip file");
        }
        InputStream is = null;
        boolean fromHttp = false;
        if (zipFile.toLowerCase().startsWith("http://")) {
            FileElement fe = FileElement.getFileElement(zipFile);
            is = fe.getStream();
            fromHttp = true;
        } else {
            is = new FileInputStream(new File(zipFile));
        }
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = zis.getNextEntry();
        if (newFile == null || newFile.trim().equals("")) {
            newFile = ze.getName();
        }
        FileOutputStream fos = new FileOutputStream(destBase + File.separator + newFile);
        byte[] b = new byte[128];
        while ((i = zis.read(b)) > 0) {
            fos.write(b, 0, i);
            fos.flush();
        }
        zis.close();
        fos.close();
        if (!keepZipFile && !fromHttp) {
            File f = new File(zipFile);
            f.delete();
        }
        return newFile;
    }
}

