/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.Name;
import pluto.log.LogUpdator;
import pluto.util.StringConvertUtil;

public abstract class LogUpdatorImpl
extends Name
implements LogUpdator {
    public static final String OK = "SUCCESS";
    public static final String FAIL = "FAIL";
    public static final String MESSAGE_UPDATE_SUCCESS = "UPDATE SUCCESS";
    public static final String MESSAGE_INVALID_KEY = "KEY IS INVALID";
    public static final String MESSAGE_DUR_OPEN_FAIL = "DURATION OPEN LOG";
    public static final String MESSAGE_OUT_DATE_FAIL = "OUT OF DATE LOG";
    public static final String MESSAGE_OUT_OF_DUR_FAIL = "OUT OF DURATION TIME";
    public static final String MESSAGE_LOG_NULL = "LOG IS NULL";
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement EMS_UPDATE_STATEMENT = null;
    protected LinkedList<LogUpdator> ADDITIONAL_MODULES = null;
    protected StringBuffer TMP_WORK_BUFFER = new StringBuffer(512);

    @Override
    public void init_connection(eMsConnection conn) throws Exception {
        this.EMS_CONNECTION = conn;
        if (this.EMS_CONNECTION == null) {
            throw new NullPointerException(this.getName() + "CONNECTION IS NULL");
        }
        this.EMS_UPDATE_STATEMENT = this.EMS_CONNECTION.createStatement();
        if (this.ADDITIONAL_MODULES != null) {
            Iterator iterator = this.ADDITIONAL_MODULES.iterator();
            while (iterator.hasNext()) {
                ((LogUpdator)iterator.next()).init_connection(conn);
            }
        }
    }

    @Override
    public void clear_connection() {
        if (this.ADDITIONAL_MODULES != null) {
            Iterator iterator = this.ADDITIONAL_MODULES.iterator();
            while (iterator.hasNext()) {
                ((LogUpdator)iterator.next()).clear_connection();
            }
        }
        this.EMS_CONNECTION.recycleStatement(this.EMS_UPDATE_STATEMENT);
    }

    @Override
    public void ensureDBConnection() throws Exception {
        if (this.ADDITIONAL_MODULES != null) {
            Iterator iterator = this.ADDITIONAL_MODULES.iterator();
            while (iterator.hasNext()) {
                ((LogUpdator)iterator.next()).ensureDBConnection();
            }
        }
    }

    @Override
    public void setEnd() throws Exception {
        if (this.ADDITIONAL_MODULES != null) {
            Iterator iterator = this.ADDITIONAL_MODULES.iterator();
            while (iterator.hasNext()) {
                ((LogUpdator)iterator.next()).setEnd();
            }
        }
    }

    @Override
    public void setStart() throws Exception {
        if (this.ADDITIONAL_MODULES != null) {
            Iterator iterator = this.ADDITIONAL_MODULES.iterator();
            while (iterator.hasNext()) {
                ((LogUpdator)iterator.next()).setStart();
            }
        }
    }

    @Override
    public void setUpdateRules(Object tmp) throws Exception {
    }

    @Override
    public void setDefaultUpdator(LogUpdator updator) {
        if (this.ADDITIONAL_MODULES == null) {
            this.ADDITIONAL_MODULES = new LinkedList();
        }
        this.ADDITIONAL_MODULES.addLast(updator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUpdateList(List<LogUpdator> list, Object obj) throws Exception {
        List<LogUpdator> list2 = list;
        synchronized (list2) {
            Iterator<LogUpdator> iter = list.iterator();
            while (iter.hasNext()) {
                String query = iter.next().toString();
                this.executeUpdate(query, obj);
            }
        }
    }

    protected int executeUpdate(String query, Object obj) throws Exception {
        this.TMP_WORK_BUFFER.setLength(0);
        StringConvertUtil.ConvertString(this.TMP_WORK_BUFFER, query, obj, "${", "}", true, false);
        return this.EMS_UPDATE_STATEMENT.executeUpdate(this.TMP_WORK_BUFFER.toString());
    }

    protected eMsResultSet executeQuery(String query, Object obj) throws Exception {
        this.TMP_WORK_BUFFER.setLength(0);
        StringConvertUtil.ConvertString(this.TMP_WORK_BUFFER, query, obj, "${", "}", true, false);
        return this.EMS_UPDATE_STATEMENT.executeQuery(this.TMP_WORK_BUFFER.toString());
    }

    protected void finalize() throws Throwable {
        this.TMP_WORK_BUFFER = null;
    }

    @Override
    public abstract String update(Object var1) throws Exception;
}

