/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import pluto.DNS.Cache;
import pluto.DNS.Lookup;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.ReverseMap;
import pluto.DNS.TextParseException;

public final class dns {
    private dns() {
    }

    public static String inaddrString(InetAddress addr) {
        return ReverseMap.fromAddress(addr).toString();
    }

    public static String inaddrString(String s) {
        try {
            return ReverseMap.fromAddress(s).toString();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static synchronized void setSearchPath(String[] domains) {
        if (domains == null || domains.length == 0) {
            Lookup.setDefaultSearchPath((Name[])null);
            return;
        }
        ArrayList<Name> l = new ArrayList<Name>();
        for (int i = 0; i < domains.length; ++i) {
            try {
                l.add(Name.fromString(domains[i], Name.root));
                continue;
            }
            catch (TextParseException textParseException) {
                // empty catch block
            }
        }
        Name[] searchPath = l.toArray(new Name[l.size()]);
        Lookup.setDefaultSearchPath(searchPath);
    }

    public static synchronized Cache getCache(int dclass) {
        return Lookup.getDefaultCache(dclass);
    }

    public static synchronized Cache getCache() {
        return Lookup.getDefaultCache(1);
    }

    public static Record[] getRecords(String namestr, int type, int dclass, int cred) {
        try {
            Lookup lookup = new Lookup(Name.fromString(namestr), type, dclass);
            lookup.setCredibility(cred);
            return lookup.run();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Record[] getRecords(String namestr, int type, int dclass) {
        return dns.getRecords(namestr, type, dclass, 3);
    }

    public static Record[] getAnyRecords(String namestr, int type, int dclass) {
        return dns.getRecords(namestr, type, dclass, 1);
    }

    public static Record[] getRecords(String namestr, int type) {
        return dns.getRecords(namestr, type, 1, 3);
    }

    public static Record[] getAnyRecords(String namestr, int type) {
        return dns.getRecords(namestr, type, 1, 1);
    }

    public static Record[] getRecordsByAddress(String addr, int type) {
        String namestr = dns.inaddrString(addr);
        return dns.getRecords(namestr, type, 1, 3);
    }

    public static Record[] getAnyRecordsByAddress(String addr, int type) {
        String name = dns.inaddrString(addr);
        return dns.getRecords(name, type, 1, 1);
    }
}

