/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.DNSSEC;
import pluto.DNS.KEYBase;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.Tokenizer;

public class DNSKEYRecord
extends KEYBase {
    DNSKEYRecord() {
    }

    @Override
    Record getObject() {
        return new DNSKEYRecord();
    }

    public DNSKEYRecord(Name name, int dclass, long ttl, int flags, int proto, int alg, byte[] key) {
        super(name, 48, dclass, ttl, flags, proto, alg, key);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.flags = st.getUInt16();
        this.proto = st.getUInt8();
        String algString = st.getString();
        this.alg = DNSSEC.Algorithm.value(algString);
        if (this.alg < 0) {
            throw st.exception("Invalid algorithm: " + algString);
        }
        this.key = st.getBase64();
    }

    public static class Flags {
        public static final int ZONE_KEY = 256;
        public static final int SEP_KEY = 1;

        private Flags() {
        }
    }

    public static class Protocol {
        public static final int DNSSEC = 3;

        private Protocol() {
        }
    }
}

