/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Inet6Address;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.TextParseException;
import pluto.DNS.Tokenizer;

public class A6Record
extends Record {
    private int prefixBits;
    private Inet6Address suffix;
    private Name prefix;

    A6Record() {
    }

    @Override
    Record getObject() {
        return new A6Record();
    }

    public A6Record(Name name, int dclass, long ttl, int prefixBits, Inet6Address suffix, Name prefix) {
        super(name, 38, dclass, ttl);
        this.prefixBits = A6Record.checkU8("prefixBits", prefixBits);
        this.suffix = suffix;
        if (prefix != null) {
            this.prefix = A6Record.checkName("prefix", prefix);
        }
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.prefixBits = in.readU8();
        int suffixbits = 128 - this.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        if (this.prefixBits < 128) {
            this.suffix = new Inet6Address(128 - this.prefixBits, in.readByteArray(suffixbytes));
        }
        if (this.prefixBits > 0) {
            this.prefix = new Name(in);
        }
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.prefixBits = st.getUInt8();
        if (this.prefixBits > 128) {
            throw st.exception("prefix bits must be [0..128]");
        }
        if (this.prefixBits < 128) {
            try {
                this.suffix = new Inet6Address(st.getString());
            }
            catch (TextParseException e) {
                throw st.exception(e.getMessage());
            }
        }
        if (this.prefixBits > 0) {
            this.prefix = st.getName(origin);
        }
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.prefixBits);
        if (this.suffix != null) {
            sb.append(" ");
            sb.append(this.suffix);
        }
        if (this.prefix != null) {
            sb.append(" ");
            sb.append(this.prefix);
        }
        return sb.toString();
    }

    public int getPrefixBits() {
        return this.prefixBits;
    }

    public Inet6Address getSuffix() {
        return this.suffix;
    }

    public Name getPrefix() {
        return this.prefix;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU8(this.prefixBits);
        if (this.suffix != null) {
            int suffixbits = 128 - this.prefixBits;
            int suffixbytes = (suffixbits + 7) / 8;
            byte[] data = this.suffix.toBytes();
            out.writeByteArray(data, 16 - suffixbytes, suffixbytes);
        }
        if (this.prefix != null) {
            this.prefix.toWire(out, null, canonical);
        }
    }
}

