/*
 * Decompiled with CFR 0.152.
 */
package moon.logprocess.module;

import java.io.FileInputStream;
import java.io.IOException;
import moon.logprocess.module.LogFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsSizeIndexedInputStream;

public class SizeIndexedBlockLogFileReader
extends LogFileReader {
    private static final Logger log = LoggerFactory.getLogger(SizeIndexedBlockLogFileReader.class);
    protected eMsSizeIndexedInputStream _LOG_FILE_READER_ = null;

    public SizeIndexedBlockLogFileReader() {
        this.setName("LineReadLogFileReader");
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public long getFilePoint() throws IOException {
        return this._LOG_FILE_READER_.getFilePointer();
    }

    @Override
    public void openFile(String filename, long filepoint) throws IOException {
        if (this._LOG_FILE_READER_ != null) {
            try {
                this._LOG_FILE_READER_.close();
            }
            catch (Exception _ex) {
                // empty catch block
            }
        }
        this._CURRENT_LOG_FILENAME_ = filename;
        this._LOG_FILE_READER_ = new eMsSizeIndexedInputStream(new FileInputStream(this._LOG_FILE_FILTER_.getTargetDir() + "/" + this._CURRENT_LOG_FILENAME_));
        filepoint = filepoint < 0L ? 0L : filepoint;
        this._LOG_FILE_READER_.skip(filepoint);
        this._LOG_FILE_FILTER_.setCurrFilename(this._CURRENT_LOG_FILENAME_);
    }

    @Override
    public void close() {
        try {
            this._LOG_FILE_READER_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._LOG_FILE_READER_ = null;
        this._CURRENT_LOG_FILENAME_ = null;
    }

    @Override
    public String readLine() throws IOException {
        return this._LOG_FILE_READER_.next();
    }

    @Override
    public boolean next() {
        String tmpFile = this._LOG_FILE_FILTER_.getNextFilename();
        if (tmpFile == null) {
            return false;
        }
        try {
            this.openFile(tmpFile, 0L);
        }
        catch (Exception _ex) {
            return false;
        }
        return true;
    }
}

